/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb.deployment;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.connector.outbound.connectiontracking.TrackedConnectionAssociator;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.j2ee.deployment.ApplicationInfo;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.jndi.JndiKey;
import org.apache.geronimo.j2ee.jndi.JndiScope;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.naming.deployment.AbstractNamingBuilder;
import org.apache.geronimo.naming.deployment.GBeanResourceEnvironmentBuilder;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentBuilder;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentSetter;
import org.apache.geronimo.openejb.EntityDeploymentGBean;
import org.apache.geronimo.openejb.ManagedDeploymentGBean;
import org.apache.geronimo.openejb.MessageDrivenDeploymentGBean;
import org.apache.geronimo.openejb.OpenEjbSystem;
import org.apache.geronimo.openejb.SingletonDeploymentGBean;
import org.apache.geronimo.openejb.StatefulDeploymentGBean;
import org.apache.geronimo.openejb.StatelessDeploymentGBean;
import org.apache.geronimo.openejb.deployment.BasicEjbDeploymentGBeanNameBuilder;
import org.apache.geronimo.openejb.deployment.EjbDeploymentGBeanNameBuilder;
import org.apache.geronimo.openejb.deployment.EjbInterface;
import org.apache.geronimo.openejb.deployment.EjbModule;
import org.apache.geronimo.openejb.deployment.SecurityBuilder;
import org.apache.geronimo.openejb.xbeans.ejbjar.OpenejbGeronimoEjbJarType;
import org.apache.geronimo.security.deployment.GeronimoSecurityBuilderImpl;
import org.apache.geronimo.security.deployment.SecurityConfiguration;
import org.apache.geronimo.security.jacc.ComponentPermissions;
import org.apache.geronimo.xbeans.geronimo.naming.GerResourceRefType;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.JndiBuilder;
import org.apache.openejb.core.ivm.naming.IntraVmJndiReference;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.EntityBean;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.ManagedBean;
import org.apache.openejb.jee.MessageDrivenBean;
import org.apache.openejb.jee.RemoteBean;
import org.apache.openejb.jee.ResourceRef;
import org.apache.openejb.jee.SecurityIdentity;
import org.apache.openejb.jee.SessionBean;
import org.apache.openejb.jee.SessionType;
import org.apache.openejb.jee.TransactionType;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xmlbeans.XmlObject;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EjbDeploymentBuilder {
    private static final Logger log = LoggerFactory.getLogger(EjbDeploymentBuilder.class);
    private final EARContext earContext;
    private final EjbModule ejbModule;
    private final NamingBuilder namingBuilder;
    private final ResourceEnvironmentSetter resourceEnvironmentSetter;
    private final EjbDeploymentGBeanNameBuilder beanNameBuilder;
    private final Map<String, GBeanData> gbeans = new TreeMap<String, GBeanData>();

    public EjbDeploymentBuilder(EARContext earContext, EjbModule ejbModule, NamingBuilder namingBuilder, ResourceEnvironmentSetter resourceEnvironmentSetter) {
        this.earContext = earContext;
        this.ejbModule = ejbModule;
        this.namingBuilder = namingBuilder;
        this.resourceEnvironmentSetter = resourceEnvironmentSetter;
        this.beanNameBuilder = new BasicEjbDeploymentGBeanNameBuilder();
    }

    public void initContext() throws DeploymentException {
        for (EnterpriseBean enterpriseBean : this.ejbModule.getEjbJar().getEnterpriseBeans()) {
            AbstractName abstractName = this.beanNameBuilder.createEjbName(this.earContext, this.ejbModule, enterpriseBean);
            GBeanData gbean = null;
            if (enterpriseBean instanceof SessionBean) {
                SessionBean sessionBean = (SessionBean)enterpriseBean;
                switch (sessionBean.getSessionType()) {
                    case STATELESS: {
                        gbean = new GBeanData(abstractName, StatelessDeploymentGBean.GBEAN_INFO);
                        break;
                    }
                    case STATEFUL: {
                        gbean = new GBeanData(abstractName, StatefulDeploymentGBean.GBEAN_INFO);
                        break;
                    }
                    case SINGLETON: {
                        gbean = new GBeanData(abstractName, SingletonDeploymentGBean.GBEAN_INFO);
                        break;
                    }
                    case MANAGED: {
                        gbean = new GBeanData(abstractName, ManagedDeploymentGBean.GBEAN_INFO);
                    }
                }
            } else if (enterpriseBean instanceof EntityBean) {
                gbean = new GBeanData(abstractName, EntityDeploymentGBean.GBEAN_INFO);
            } else if (enterpriseBean instanceof MessageDrivenBean) {
                gbean = new GBeanData(abstractName, MessageDrivenDeploymentGBean.GBEAN_INFO);
            }
            if (gbean == null) {
                throw new DeploymentException("Unknown enterprise bean type " + enterpriseBean.getClass().getName());
            }
            String ejbName = enterpriseBean.getEjbName();
            EjbDeployment ejbDeployment = (EjbDeployment)this.ejbModule.getOpenejbJar().getDeploymentsByEjbName().get(ejbName);
            if (ejbDeployment == null) {
                throw new DeploymentException("OpenEJB configuration not found for ejb " + ejbName);
            }
            gbean.setAttribute("deploymentId", (Object)ejbDeployment.getDeploymentId());
            gbean.setAttribute("ejbName", (Object)ejbName);
            if (enterpriseBean instanceof RemoteBean) {
                RemoteBean remoteBean = (RemoteBean)enterpriseBean;
                if (remoteBean.getRemote() != null) {
                    String remoteInterfaceName = remoteBean.getRemote();
                    EjbDeploymentBuilder.assureEJBObjectInterface(remoteInterfaceName, this.earContext.getDeploymentBundle());
                    gbean.setAttribute(EjbInterface.REMOTE.getAttributeName(), (Object)remoteInterfaceName);
                    String homeInterfaceName = remoteBean.getHome();
                    EjbDeploymentBuilder.assureEJBHomeInterface(homeInterfaceName, this.earContext.getDeploymentBundle());
                    gbean.setAttribute(EjbInterface.HOME.getAttributeName(), (Object)homeInterfaceName);
                }
                if (remoteBean.getLocal() != null) {
                    String localInterfaceName = remoteBean.getLocal();
                    EjbDeploymentBuilder.assureEJBLocalObjectInterface(localInterfaceName, this.earContext.getDeploymentBundle());
                    gbean.setAttribute(EjbInterface.LOCAL.getAttributeName(), (Object)localInterfaceName);
                    String localHomeInterfaceName = remoteBean.getLocalHome();
                    EjbDeploymentBuilder.assureEJBLocalHomeInterface(localHomeInterfaceName, this.earContext.getDeploymentBundle());
                    gbean.setAttribute(EjbInterface.LOCAL_HOME.getAttributeName(), (Object)localHomeInterfaceName);
                }
                if (enterpriseBean instanceof SessionBean && ((SessionBean)enterpriseBean).getSessionType() == SessionType.STATELESS) {
                    SessionBean statelessBean = (SessionBean)enterpriseBean;
                    gbean.setAttribute(EjbInterface.SERVICE_ENDPOINT.getAttributeName(), (Object)statelessBean.getServiceEndpoint());
                }
            }
            gbean.setReferencePattern("TrackedConnectionAssociator", new AbstractNameQuery(null, Collections.EMPTY_MAP, TrackedConnectionAssociator.class.getName()));
            gbean.setReferencePattern("OpenEjbSystem", new AbstractNameQuery(null, Collections.EMPTY_MAP, OpenEjbSystem.class.getName()));
            try {
                this.ejbModule.addGBean(gbean);
            }
            catch (GBeanAlreadyExistsException e) {
                throw new DeploymentException("Could not add entity bean to context", (Throwable)e);
            }
            this.gbeans.put(ejbName, gbean);
        }
    }

    private static Set<AbstractName> getResourceDependencies(EARContext earContext) {
        AbstractNameQuery cfNameQuery = new AbstractNameQuery(earContext.getConfigID(), Collections.singletonMap("j2eeType", "JCAManagedConnectionFactory"));
        AbstractNameQuery aoNameQuery = new AbstractNameQuery(earContext.getConfigID(), Collections.singletonMap("j2eeType", "JCAAdminObject"));
        AbstractNameQuery raNameQuery = new AbstractNameQuery(earContext.getConfigID(), Collections.singletonMap("j2eeType", "JCAResourceAdapter"));
        HashSet<AbstractName> dependencies = new HashSet<AbstractName>();
        dependencies.addAll(earContext.findGBeans(cfNameQuery));
        dependencies.addAll(earContext.findGBeans(aoNameQuery));
        dependencies.addAll(earContext.findGBeans(raNameQuery));
        return dependencies;
    }

    public void addEjbModuleDependency(GBeanData ejbModule) {
        Set<AbstractName> resourceDependencies = EjbDeploymentBuilder.getResourceDependencies(this.earContext);
        for (GBeanData gbean : this.gbeans.values()) {
            ejbModule.addDependency(gbean.getAbstractName());
            gbean.addDependencies(resourceDependencies);
        }
    }

    public void buildComponentPermissions(ComponentPermissions componentPermissions) throws DeploymentException {
        List methodPermissions = this.ejbModule.getEjbJar().getAssemblyDescriptor().getMethodPermission();
        if (this.earContext.getSecurityConfiguration() != null) {
            this.earContext.setHasSecurity(true);
        }
        if (this.earContext.getSecurityConfiguration() == null && methodPermissions.size() > 0) {
            throw new DeploymentException("Ejb app has method permissions but no security configuration supplied in geronimo plan");
        }
        for (EnterpriseBean enterpriseBean : this.ejbModule.getEjbJar().getEnterpriseBeans()) {
            this.addSecurityData(enterpriseBean, componentPermissions);
        }
    }

    private void addSecurityData(EnterpriseBean enterpriseBean, ComponentPermissions componentPermissions) throws DeploymentException {
        SecurityConfiguration securityConfiguration = (SecurityConfiguration)this.earContext.getSecurityConfiguration();
        if (securityConfiguration != null) {
            String runAsName;
            GBeanData gbean = this.getEjbGBean(enterpriseBean.getEjbName());
            SecurityBuilder securityBuilder = new SecurityBuilder();
            HashSet<Permission> allPermissions = new HashSet<Permission>();
            if (enterpriseBean instanceof RemoteBean) {
                RemoteBean remoteBean = (RemoteBean)enterpriseBean;
                securityBuilder.addToPermissions(allPermissions, remoteBean.getEjbName(), EjbInterface.HOME.getJaccInterfaceName(), remoteBean.getHome(), this.ejbModule.getClassLoader());
                securityBuilder.addToPermissions(allPermissions, remoteBean.getEjbName(), EjbInterface.REMOTE.getJaccInterfaceName(), remoteBean.getRemote(), this.ejbModule.getClassLoader());
                securityBuilder.addToPermissions(allPermissions, remoteBean.getEjbName(), EjbInterface.LOCAL.getJaccInterfaceName(), remoteBean.getLocal(), this.ejbModule.getClassLoader());
                securityBuilder.addToPermissions(allPermissions, remoteBean.getEjbName(), EjbInterface.LOCAL_HOME.getJaccInterfaceName(), remoteBean.getLocalHome(), this.ejbModule.getClassLoader());
                if (remoteBean instanceof SessionBean) {
                    securityBuilder.addToPermissions(allPermissions, remoteBean.getEjbName(), EjbInterface.SERVICE_ENDPOINT.getJaccInterfaceName(), ((SessionBean)remoteBean).getServiceEndpoint(), this.ejbModule.getClassLoader());
                }
                if (remoteBean.getBusinessRemote() != null && !remoteBean.getBusinessRemote().isEmpty()) {
                    for (String businessRemote : remoteBean.getBusinessRemote()) {
                        securityBuilder.addToPermissions(allPermissions, remoteBean.getEjbName(), EjbInterface.REMOTE.getJaccInterfaceName(), businessRemote, this.ejbModule.getClassLoader());
                    }
                    securityBuilder.addToPermissions(new PermissionCollectionAdapter(componentPermissions.getUncheckedPermissions()), remoteBean.getEjbName(), EjbInterface.HOME.getJaccInterfaceName(), BeanContext.BusinessRemoteHome.class.getName(), this.ejbModule.getClassLoader());
                }
                if (remoteBean.getBusinessLocal() != null && !remoteBean.getBusinessLocal().isEmpty()) {
                    for (String businessLocal : remoteBean.getBusinessLocal()) {
                        securityBuilder.addToPermissions(allPermissions, remoteBean.getEjbName(), EjbInterface.LOCAL.getJaccInterfaceName(), businessLocal, this.ejbModule.getClassLoader());
                    }
                    securityBuilder.addToPermissions(new PermissionCollectionAdapter(componentPermissions.getUncheckedPermissions()), remoteBean.getEjbName(), EjbInterface.LOCAL_HOME.getJaccInterfaceName(), BeanContext.BusinessLocalHome.class.getName(), this.ejbModule.getClassLoader());
                }
            }
            securityBuilder.addEjbTimeout(enterpriseBean, this.ejbModule, allPermissions);
            String defaultRole = securityConfiguration.getDefaultRole();
            securityBuilder.addComponentPermissions(defaultRole, allPermissions, this.ejbModule.getEjbJar().getAssemblyDescriptor(), enterpriseBean.getEjbName(), enterpriseBean.getSecurityRoleRef(), componentPermissions);
            SecurityIdentity securityIdentity = enterpriseBean.getSecurityIdentity();
            if (securityIdentity != null && securityIdentity.getRunAs() != null && (runAsName = securityIdentity.getRunAs()) != null) {
                gbean.setAttribute("runAsRole", (Object)runAsName);
            }
            gbean.setAttribute("securityEnabled", (Object)true);
            gbean.setReferencePattern("RunAsSource", (AbstractNameQuery)GeronimoSecurityBuilderImpl.ROLE_MAPPER_DATA_NAME.get(this.earContext.getGeneralData()));
        }
    }

    public void buildEnc() throws DeploymentException {
        GBeanData gbean;
        EjbJar ejbJar = (EjbJar)this.ejbModule.getSpecDD();
        if (!ejbJar.isMetadataComplete().booleanValue()) {
            // empty if block
        }
        String appName = null;
        for (Module parentModule = this.ejbModule.getParentModule(); parentModule != null; parentModule = parentModule.getParentModule()) {
            if (!(parentModule instanceof ApplicationInfo)) continue;
            appName = (String)this.ejbModule.getJndiScope((JndiKey)JndiScope.app).get("app/AppName");
            break;
        }
        EjbJarInfo ejbJarInfo = this.ejbModule.getEjbJarInfo();
        for (EnterpriseBean bean : ejbJar.getEnterpriseBeans()) {
            String ejbName = bean.getEjbName();
            String deploymentId = this.getDeploymentId(ejbName, ejbJarInfo);
            gbean = this.getEjbGBean(ejbName);
            this.addEnc(gbean, bean, appName, deploymentId);
        }
        OpenejbGeronimoEjbJarType geronimoOpenejb = (OpenejbGeronimoEjbJarType)this.ejbModule.getVendorDD();
        for (EnterpriseBean bean : ejbJar.getEnterpriseBeans()) {
            String ejbName = bean.getEjbName().trim();
            gbean = this.getEjbGBean(ejbName);
            Collection resourceRefs = bean.getResourceRef();
            this.processResourceEnvironment(gbean, resourceRefs, geronimoOpenejb);
        }
        if (!ejbJar.isMetadataComplete().booleanValue()) {
            ejbJar.setMetadataComplete(Boolean.valueOf(true));
            this.ejbModule.setOriginalSpecDD(((EjbJar)this.ejbModule.getSpecDD()).toString());
        }
    }

    private String getDeploymentId(String ejbName, EjbJarInfo ejbJarInfo) throws DeploymentException {
        for (EnterpriseBeanInfo info : ejbJarInfo.enterpriseBeans) {
            if (!ejbName.equals(info.ejbName)) continue;
            return info.ejbDeploymentId;
        }
        throw new DeploymentException("EnterpriseBeanInfo not found for ejb: " + ejbName);
    }

    private void addEnc(GBeanData gbean, EnterpriseBean bean, String appName, String deploymentId) throws DeploymentException {
        HashMap<EARContext.Key, AbstractName> buildingContext = new HashMap<EARContext.Key, AbstractName>();
        buildingContext.put(NamingBuilder.GBEAN_NAME_KEY, gbean.getAbstractName());
        try {
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Could not load ejb class", (Throwable)e);
        }
        ArrayList classes = new ArrayList();
        for (Class ejbClass = this.ejbModule.getEarContext().getDeploymentBundle().loadClass(bean.getEjbClass()); ejbClass != null && !ejbClass.equals(Object.class); ejbClass = ejbClass.getSuperclass()) {
            classes.add(ejbClass);
        }
        ClassFinder finder = new ClassFinder(classes);
        Module module = this.ejbModule.newEJb(finder, bean);
        this.bind(bean, appName, this.ejbModule.getName(), deploymentId, module.getJndiContext());
        OpenejbGeronimoEjbJarType geronimoOpenejb = (OpenejbGeronimoEjbJarType)this.ejbModule.getVendorDD();
        this.namingBuilder.buildNaming((JndiConsumer)bean, (XmlObject)geronimoOpenejb, module, buildingContext);
        AbstractName applicationJndiName = (AbstractName)this.earContext.getGeneralData().get(EARContext.APPLICATION_JNDI_NAME_KEY);
        gbean.setReferencePattern("ApplicationJndi", applicationJndiName);
        gbean.setAttribute("moduleContextMap", (Object)module.getJndiScope((JndiKey)JndiScope.module));
        gbean.setAttribute("componentContextMap", (Object)module.getJndiScope((JndiKey)JndiScope.comp));
        gbean.setReferencePattern("TransactionManager", this.earContext.getTransactionManagerName());
        gbean.setAttribute("beanManagedTransactions", (Object)(bean.getTransactionType() == TransactionType.BEAN ? 1 : 0));
    }

    private void processResourceEnvironment(GBeanData gbean, Collection<ResourceRef> resourceRefs, OpenejbGeronimoEjbJarType geronimoOpenejb) throws DeploymentException {
        GerResourceRefType[] gerResourceRefs = null;
        if (geronimoOpenejb != null) {
            gerResourceRefs = geronimoOpenejb.getResourceRefArray();
        }
        GBeanResourceEnvironmentBuilder refBuilder = new GBeanResourceEnvironmentBuilder(gbean);
        this.resourceEnvironmentSetter.setResourceEnvironment((ResourceEnvironmentBuilder)refBuilder, resourceRefs, gerResourceRefs);
    }

    public void bind(EnterpriseBean bean, String appName, String moduleName, String id, Map<JndiKey, Map<String, Object>> jndiContext) {
        IntraVmJndiReference ref;
        String name;
        appName = appName == null || appName.isEmpty() ? "" : appName + "/";
        moduleName = moduleName + "/";
        String beanName = bean.getEjbName();
        int count = 0;
        IntraVmJndiReference singleRef = null;
        if (bean instanceof RemoteBean) {
            IntraVmJndiReference ref2;
            String name2;
            try {
                String homeInterface = ((RemoteBean)bean).getHome();
                if (homeInterface != null) {
                    name = "openejb/Deployment/" + JndiBuilder.format((String)id, (String)homeInterface, (InterfaceType)InterfaceType.EJB_HOME);
                    ref = new IntraVmJndiReference(name);
                    ++count;
                    singleRef = ref;
                    this.bindJava(appName, moduleName, beanName, homeInterface, (Reference)ref, jndiContext);
                }
            }
            catch (NamingException e) {
                throw new RuntimeException("Unable to bind remote home interface for deployment " + id, e);
            }
            try {
                String localHomeInterface = ((RemoteBean)bean).getLocalHome();
                if (localHomeInterface != null) {
                    name = "openejb/Deployment/" + JndiBuilder.format((String)id, (String)localHomeInterface, (InterfaceType)InterfaceType.EJB_LOCAL_HOME);
                    ref = new IntraVmJndiReference(name);
                    ++count;
                    singleRef = ref;
                    this.bindJava(appName, moduleName, beanName, localHomeInterface, (Reference)ref, jndiContext);
                }
            }
            catch (NamingException e) {
                throw new RuntimeException("Unable to bind local home interface for deployment " + id, e);
            }
            try {
                for (String interfce : ((RemoteBean)bean).getBusinessLocal()) {
                    name2 = "openejb/Deployment/" + JndiBuilder.format((String)id, (String)interfce, (InterfaceType)InterfaceType.BUSINESS_LOCAL);
                    ref2 = new IntraVmJndiReference(name2);
                    ++count;
                    singleRef = ref2;
                    this.bindJava(appName, moduleName, beanName, interfce, (Reference)ref2, jndiContext);
                }
            }
            catch (NamingException e) {
                throw new RuntimeException("Unable to bind business local interface for deployment " + id, e);
            }
            try {
                for (String interfce : ((RemoteBean)bean).getBusinessRemote()) {
                    name2 = "openejb/Deployment/" + JndiBuilder.format((String)id, (String)interfce, (InterfaceType)InterfaceType.BUSINESS_REMOTE);
                    ref2 = new IntraVmJndiReference(name2);
                    ++count;
                    singleRef = ref2;
                    this.bindJava(appName, moduleName, beanName, interfce, (Reference)ref2, jndiContext);
                }
            }
            catch (NamingException e) {
                throw new RuntimeException("Unable to bind business remote deployment in jndi.", e);
            }
        }
        try {
            if (bean instanceof SessionBean && ((SessionBean)bean).getLocalBean() != null || bean instanceof ManagedBean) {
                String beanClass = bean.getEjbClass();
                name = "openejb/Deployment/" + JndiBuilder.format((String)id, (String)beanClass, (InterfaceType)InterfaceType.BUSINESS_LOCALBEAN_HOME);
                ref = new IntraVmJndiReference(name);
                ++count;
                singleRef = ref;
                this.bindJava(appName, moduleName, beanName, beanClass, (Reference)ref, jndiContext);
            }
        }
        catch (NamingException e) {
            throw new RuntimeException("Unable to bind business remote deployment in jndi.", e);
        }
        if (count == 1 || bean instanceof ManagedBean) {
            try {
                this.bindJava(appName, moduleName, beanName, null, (Reference)singleRef, jndiContext);
            }
            catch (NamingException e) {
                throw new RuntimeException("Unable to single interface in jndi.", e);
            }
        }
    }

    private void bindJava(String appName, String moduleName, String beanName, String interfaceName, Reference ref, Map<JndiKey, Map<String, Object>> contexts) throws NamingException {
        if (interfaceName != null) {
            beanName = beanName + "!" + interfaceName;
        }
        this.bind("global", appName + moduleName + beanName, ref, contexts);
        this.bind("app", moduleName + beanName, ref, contexts);
        this.bind("module", beanName, ref, contexts);
    }

    private void bind(String context, String name, Object object, Map<JndiKey, Map<String, Object>> contexts) throws NamingException {
        JndiScope jndiKey = JndiScope.valueOf((String)context);
        Map<String, Object> scope = contexts.get(jndiKey);
        if (scope == null) {
            scope = new HashMap<String, Object>();
            contexts.put((JndiKey)jndiKey, scope);
        }
        String fullName = context + "/" + name;
        scope.put(fullName, object);
        log.debug("bound at " + fullName + " reference " + object);
    }

    private GBeanData getEjbGBean(String ejbName) throws DeploymentException {
        GBeanData gbean = this.gbeans.get(ejbName);
        if (gbean == null) {
            throw new DeploymentException("EJB not gbean not found " + ejbName);
        }
        return gbean;
    }

    private static Class assureEJBObjectInterface(String remote, Bundle bundle) throws DeploymentException {
        return AbstractNamingBuilder.assureInterface((String)remote, (String)"javax.ejb.EJBObject", (String)"Remote", (Bundle)bundle);
    }

    private static Class assureEJBHomeInterface(String home, Bundle bundle) throws DeploymentException {
        return AbstractNamingBuilder.assureInterface((String)home, (String)"javax.ejb.EJBHome", (String)"Home", (Bundle)bundle);
    }

    public static Class assureEJBLocalObjectInterface(String local, Bundle bundle) throws DeploymentException {
        return AbstractNamingBuilder.assureInterface((String)local, (String)"javax.ejb.EJBLocalObject", (String)"Local", (Bundle)bundle);
    }

    public static Class assureEJBLocalHomeInterface(String localHome, Bundle bundle) throws DeploymentException {
        return AbstractNamingBuilder.assureInterface((String)localHome, (String)"javax.ejb.EJBLocalHome", (String)"LocalHome", (Bundle)bundle);
    }

    private static class PermissionCollectionAdapter
    implements Collection<Permission> {
        private final PermissionCollection p;

        private PermissionCollectionAdapter(PermissionCollection p) {
            this.p = p;
        }

        @Override
        public int size() {
            throw new RuntimeException("not implemented");
        }

        @Override
        public boolean isEmpty() {
            throw new RuntimeException("not implemented");
        }

        @Override
        public boolean contains(Object o) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public Iterator<Permission> iterator() {
            throw new RuntimeException("not implemented");
        }

        @Override
        public Object[] toArray() {
            throw new RuntimeException("not implemented");
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public boolean add(Permission o) {
            if (this.p.implies(o)) {
                return false;
            }
            this.p.add(o);
            return true;
        }

        @Override
        public boolean remove(Object o) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public boolean addAll(Collection<? extends Permission> c) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public void clear() {
            throw new RuntimeException("not implemented");
        }
    }
}

