/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb.deployment;

import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.openejb.deployment.EjbDeploymentGBeanNameBuilder;
import org.apache.geronimo.openejb.deployment.EjbModule;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.EntityBean;
import org.apache.openejb.jee.MessageDrivenBean;
import org.apache.openejb.jee.SessionBean;

public class BasicEjbDeploymentGBeanNameBuilder
implements EjbDeploymentGBeanNameBuilder {
    @Override
    public AbstractName createEjbName(EARContext earContext, EjbModule ejbModule, EnterpriseBean enterpriseBean) {
        String ejbName = enterpriseBean.getEjbName();
        String type = null;
        if (enterpriseBean instanceof SessionBean) {
            SessionBean sessionBean = (SessionBean)enterpriseBean;
            switch (sessionBean.getSessionType()) {
                case STATELESS: {
                    type = "StatelessSessionBean";
                    break;
                }
                case STATEFUL: {
                    type = "StatefulSessionBean";
                    break;
                }
                case SINGLETON: {
                    type = "SingletonBean";
                    break;
                }
                case MANAGED: {
                    type = "ManagedBean";
                }
            }
        } else if (enterpriseBean instanceof EntityBean) {
            type = "EntityBean";
        } else if (enterpriseBean instanceof MessageDrivenBean) {
            type = "MessageDrivenBean";
        }
        if (type == null) {
            throw new IllegalArgumentException("Unknown enterprise bean type XXX " + enterpriseBean.getClass().getName());
        }
        return earContext.getNaming().createChildName(ejbModule.getModuleName(), ejbName, type);
    }
}

