/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb.deployment;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.connector.outbound.connectiontracking.TrackedConnectionAssociator;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotatedEjbJar;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.naming.deployment.AbstractNamingBuilder;
import org.apache.geronimo.naming.deployment.GBeanResourceEnvironmentBuilder;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentBuilder;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentSetter;
import org.apache.geronimo.openejb.EntityDeploymentGBean;
import org.apache.geronimo.openejb.MessageDrivenDeploymentGBean;
import org.apache.geronimo.openejb.OpenEjbSystem;
import org.apache.geronimo.openejb.SingletonDeploymentGBean;
import org.apache.geronimo.openejb.StatefulDeploymentGBean;
import org.apache.geronimo.openejb.StatelessDeploymentGBean;
import org.apache.geronimo.openejb.deployment.BasicEjbDeploymentGBeanNameBuilder;
import org.apache.geronimo.openejb.deployment.EjbDeploymentGBeanNameBuilder;
import org.apache.geronimo.openejb.deployment.EjbInterface;
import org.apache.geronimo.openejb.deployment.EjbModule;
import org.apache.geronimo.openejb.deployment.SecurityBuilder;
import org.apache.geronimo.openejb.xbeans.ejbjar.OpenejbGeronimoEjbJarType;
import org.apache.geronimo.security.deployment.SecurityConfiguration;
import org.apache.geronimo.security.jacc.ComponentPermissions;
import org.apache.geronimo.xbeans.geronimo.naming.GerResourceRefType;
import org.apache.geronimo.xbeans.javaee.EjbJarType;
import org.apache.geronimo.xbeans.javaee.EnterpriseBeansType;
import org.apache.geronimo.xbeans.javaee.ResourceRefType;
import org.apache.geronimo.xbeans.javaee.SessionBeanType;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.EntityBean;
import org.apache.openejb.jee.MessageDrivenBean;
import org.apache.openejb.jee.RemoteBean;
import org.apache.openejb.jee.SecurityIdentity;
import org.apache.openejb.jee.SessionBean;
import org.apache.openejb.jee.SessionType;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbDeploymentBuilder {
    private static final String ROLE_MAPPER_DATA_NAME = "roleMapperDataName";
    private final EARContext earContext;
    private final EjbModule ejbModule;
    private final NamingBuilder namingBuilder;
    private final ResourceEnvironmentSetter resourceEnvironmentSetter;
    private final EjbDeploymentGBeanNameBuilder beanNameBuilder;
    private final Map<String, GBeanData> gbeans = new TreeMap<String, GBeanData>();

    public EjbDeploymentBuilder(EARContext earContext, EjbModule ejbModule, NamingBuilder namingBuilder, ResourceEnvironmentSetter resourceEnvironmentSetter) {
        this.earContext = earContext;
        this.ejbModule = ejbModule;
        this.namingBuilder = namingBuilder;
        this.resourceEnvironmentSetter = resourceEnvironmentSetter;
        this.beanNameBuilder = new BasicEjbDeploymentGBeanNameBuilder();
    }

    public void initContext() throws DeploymentException {
        for (EnterpriseBean enterpriseBean : this.ejbModule.getEjbJar().getEnterpriseBeans()) {
            AbstractName abstractName = this.beanNameBuilder.createEjbName(this.earContext, this.ejbModule, enterpriseBean);
            GBeanData gbean = null;
            if (enterpriseBean instanceof SessionBean) {
                SessionBean sessionBean = (SessionBean)enterpriseBean;
                switch (sessionBean.getSessionType()) {
                    case STATELESS: {
                        gbean = new GBeanData(abstractName, StatelessDeploymentGBean.GBEAN_INFO);
                        break;
                    }
                    case STATEFUL: {
                        gbean = new GBeanData(abstractName, StatefulDeploymentGBean.GBEAN_INFO);
                        break;
                    }
                    case SINGLETON: {
                        gbean = new GBeanData(abstractName, SingletonDeploymentGBean.GBEAN_INFO);
                    }
                }
            } else if (enterpriseBean instanceof EntityBean) {
                gbean = new GBeanData(abstractName, EntityDeploymentGBean.GBEAN_INFO);
            } else if (enterpriseBean instanceof MessageDrivenBean) {
                gbean = new GBeanData(abstractName, MessageDrivenDeploymentGBean.GBEAN_INFO);
            }
            if (gbean == null) {
                throw new DeploymentException("Unknown enterprise bean type " + enterpriseBean.getClass().getName());
            }
            String ejbName = enterpriseBean.getEjbName();
            EjbDeployment ejbDeployment = (EjbDeployment)this.ejbModule.getOpenejbJar().getDeploymentsByEjbName().get(ejbName);
            if (ejbDeployment == null) {
                throw new DeploymentException("OpenEJB configuration not found for ejb " + ejbName);
            }
            gbean.setAttribute("deploymentId", (Object)ejbDeployment.getDeploymentId());
            gbean.setAttribute("ejbName", (Object)ejbName);
            if (enterpriseBean instanceof RemoteBean) {
                RemoteBean remoteBean = (RemoteBean)enterpriseBean;
                if (remoteBean.getRemote() != null) {
                    String remoteInterfaceName = remoteBean.getRemote();
                    EjbDeploymentBuilder.assureEJBObjectInterface(remoteInterfaceName, this.ejbModule.getClassLoader());
                    gbean.setAttribute(EjbInterface.REMOTE.getAttributeName(), (Object)remoteInterfaceName);
                    String homeInterfaceName = remoteBean.getHome();
                    EjbDeploymentBuilder.assureEJBHomeInterface(homeInterfaceName, this.ejbModule.getClassLoader());
                    gbean.setAttribute(EjbInterface.HOME.getAttributeName(), (Object)homeInterfaceName);
                }
                if (remoteBean.getLocal() != null) {
                    String localInterfaceName = remoteBean.getLocal();
                    EjbDeploymentBuilder.assureEJBLocalObjectInterface(localInterfaceName, this.ejbModule.getClassLoader());
                    gbean.setAttribute(EjbInterface.LOCAL.getAttributeName(), (Object)localInterfaceName);
                    String localHomeInterfaceName = remoteBean.getLocalHome();
                    EjbDeploymentBuilder.assureEJBLocalHomeInterface(localHomeInterfaceName, this.ejbModule.getClassLoader());
                    gbean.setAttribute(EjbInterface.LOCAL_HOME.getAttributeName(), (Object)localHomeInterfaceName);
                }
                if (enterpriseBean instanceof SessionBean && ((SessionBean)enterpriseBean).getSessionType() == SessionType.STATELESS) {
                    SessionBean statelessBean = (SessionBean)enterpriseBean;
                    gbean.setAttribute(EjbInterface.SERVICE_ENDPOINT.getAttributeName(), (Object)statelessBean.getServiceEndpoint());
                }
            }
            gbean.setReferencePattern("TrackedConnectionAssociator", new AbstractNameQuery(null, Collections.EMPTY_MAP, TrackedConnectionAssociator.class.getName()));
            gbean.setReferencePattern("OpenEjbSystem", new AbstractNameQuery(null, Collections.EMPTY_MAP, OpenEjbSystem.class.getName()));
            try {
                this.earContext.addGBean(gbean);
            }
            catch (GBeanAlreadyExistsException e) {
                throw new DeploymentException("Could not add entity bean to context", (Throwable)e);
            }
            this.gbeans.put(ejbName, gbean);
        }
    }

    private static Set<AbstractName> getResourceDependencies(EARContext earContext) {
        AbstractNameQuery cfNameQuery = new AbstractNameQuery(earContext.getConfigID(), Collections.singletonMap("j2eeType", "JCAManagedConnectionFactory"));
        AbstractNameQuery aoNameQuery = new AbstractNameQuery(earContext.getConfigID(), Collections.singletonMap("j2eeType", "JCAAdminObject"));
        AbstractNameQuery raNameQuery = new AbstractNameQuery(earContext.getConfigID(), Collections.singletonMap("j2eeType", "JCAResourceAdapter"));
        HashSet<AbstractName> dependencies = new HashSet<AbstractName>();
        dependencies.addAll(earContext.findGBeans(cfNameQuery));
        dependencies.addAll(earContext.findGBeans(aoNameQuery));
        dependencies.addAll(earContext.findGBeans(raNameQuery));
        return dependencies;
    }

    public void addEjbModuleDependency(GBeanData ejbModule) {
        Set<AbstractName> resourceDependencies = EjbDeploymentBuilder.getResourceDependencies(this.earContext);
        for (GBeanData gbean : this.gbeans.values()) {
            ejbModule.addDependency(gbean.getAbstractName());
            gbean.addDependencies(resourceDependencies);
        }
    }

    public ComponentPermissions buildComponentPermissions() throws DeploymentException {
        List methodPermissions = this.ejbModule.getEjbJar().getAssemblyDescriptor().getMethodPermission();
        if (this.earContext.getSecurityConfiguration() != null) {
            this.earContext.setHasSecurity(true);
        }
        if (this.earContext.getSecurityConfiguration() == null && methodPermissions.size() > 0) {
            throw new DeploymentException("Ejb app has method permissions but no security configuration supplied in geronimo plan");
        }
        ComponentPermissions componentPermissions = new ComponentPermissions((PermissionCollection)new Permissions(), (PermissionCollection)new Permissions(), new HashMap());
        for (EnterpriseBean enterpriseBean : this.ejbModule.getEjbJar().getEnterpriseBeans()) {
            this.addSecurityData(enterpriseBean, componentPermissions);
        }
        return componentPermissions;
    }

    private void addSecurityData(EnterpriseBean enterpriseBean, ComponentPermissions componentPermissions) throws DeploymentException {
        SecurityConfiguration securityConfiguration = (SecurityConfiguration)this.earContext.getSecurityConfiguration();
        if (securityConfiguration != null) {
            String runAsName;
            SecurityIdentity securityIdentity;
            GBeanData gbean = this.getEjbGBean(enterpriseBean.getEjbName());
            if (enterpriseBean instanceof RemoteBean) {
                RemoteBean remoteBean = (RemoteBean)enterpriseBean;
                SecurityBuilder securityBuilder = new SecurityBuilder();
                HashSet<Permission> allPermissions = new HashSet<Permission>();
                securityBuilder.addToPermissions(allPermissions, remoteBean.getEjbName(), EjbInterface.HOME.getJaccInterfaceName(), remoteBean.getHome(), this.ejbModule.getClassLoader());
                securityBuilder.addToPermissions(allPermissions, remoteBean.getEjbName(), EjbInterface.REMOTE.getJaccInterfaceName(), remoteBean.getRemote(), this.ejbModule.getClassLoader());
                securityBuilder.addToPermissions(allPermissions, remoteBean.getEjbName(), EjbInterface.LOCAL.getJaccInterfaceName(), remoteBean.getLocal(), this.ejbModule.getClassLoader());
                securityBuilder.addToPermissions(allPermissions, remoteBean.getEjbName(), EjbInterface.LOCAL_HOME.getJaccInterfaceName(), remoteBean.getLocalHome(), this.ejbModule.getClassLoader());
                if (remoteBean instanceof SessionBean) {
                    securityBuilder.addToPermissions(allPermissions, remoteBean.getEjbName(), EjbInterface.SERVICE_ENDPOINT.getJaccInterfaceName(), ((SessionBean)remoteBean).getServiceEndpoint(), this.ejbModule.getClassLoader());
                }
                if (remoteBean.getBusinessRemote() != null && !remoteBean.getBusinessRemote().isEmpty()) {
                    for (String businessRemote : remoteBean.getBusinessRemote()) {
                        securityBuilder.addToPermissions(allPermissions, remoteBean.getEjbName(), EjbInterface.REMOTE.getJaccInterfaceName(), businessRemote, this.ejbModule.getClassLoader());
                    }
                    securityBuilder.addToPermissions(new PermissionCollectionAdapter(componentPermissions.getUncheckedPermissions()), remoteBean.getEjbName(), EjbInterface.HOME.getJaccInterfaceName(), DeploymentInfo.BusinessRemoteHome.class.getName(), this.ejbModule.getClassLoader());
                }
                if (remoteBean.getBusinessLocal() != null && !remoteBean.getBusinessLocal().isEmpty()) {
                    for (String businessLocal : remoteBean.getBusinessLocal()) {
                        securityBuilder.addToPermissions(allPermissions, remoteBean.getEjbName(), EjbInterface.LOCAL.getJaccInterfaceName(), businessLocal, this.ejbModule.getClassLoader());
                    }
                    securityBuilder.addToPermissions(new PermissionCollectionAdapter(componentPermissions.getUncheckedPermissions()), remoteBean.getEjbName(), EjbInterface.LOCAL_HOME.getJaccInterfaceName(), DeploymentInfo.BusinessLocalHome.class.getName(), this.ejbModule.getClassLoader());
                }
                securityBuilder.addEjbTimeout(remoteBean, this.ejbModule, allPermissions);
                String defaultRole = securityConfiguration.getDefaultRole();
                securityBuilder.addComponentPermissions(defaultRole, allPermissions, this.ejbModule.getEjbJar().getAssemblyDescriptor(), enterpriseBean.getEjbName(), remoteBean.getSecurityRoleRef(), componentPermissions);
            }
            if ((securityIdentity = enterpriseBean.getSecurityIdentity()) != null && securityIdentity.getRunAs() != null && (runAsName = securityIdentity.getRunAs()) != null) {
                gbean.setAttribute("runAsRole", (Object)runAsName);
            }
            gbean.setAttribute("securityEnabled", (Object)true);
            gbean.setReferencePattern("RunAsSource", (AbstractNameQuery)this.earContext.getGeneralData().get(ROLE_MAPPER_DATA_NAME));
        }
    }

    public void buildEnc() throws DeploymentException {
        EnterpriseBeansType enterpriseBeans;
        EjbJarType ejbJarType = (EjbJarType)this.ejbModule.getSpecDD();
        if (!ejbJarType.getMetadataComplete()) {
            this.ejbModule.setClassFinder(this.createEjbJarClassFinder(this.ejbModule));
        }
        if ((enterpriseBeans = ejbJarType.getEnterpriseBeans()) != null) {
            ResourceRefType[] resourceRefs;
            GBeanData gbean;
            String ejbName;
            for (SessionBeanType sessionBeanType : enterpriseBeans.getSessionArray()) {
                ejbName = sessionBeanType.getEjbName().getStringValue().trim();
                gbean = this.getEjbGBean(ejbName);
                resourceRefs = sessionBeanType.getResourceRefArray();
                this.addEnc(gbean, (XmlObject)sessionBeanType, resourceRefs);
            }
            for (SessionBeanType sessionBeanType : enterpriseBeans.getMessageDrivenArray()) {
                ejbName = sessionBeanType.getEjbName().getStringValue().trim();
                gbean = this.getEjbGBean(ejbName);
                resourceRefs = sessionBeanType.getResourceRefArray();
                this.addEnc(gbean, (XmlObject)sessionBeanType, resourceRefs);
            }
            for (SessionBeanType sessionBeanType : enterpriseBeans.getEntityArray()) {
                ejbName = sessionBeanType.getEjbName().getStringValue().trim();
                gbean = this.getEjbGBean(ejbName);
                resourceRefs = sessionBeanType.getResourceRefArray();
                this.addEnc(gbean, (XmlObject)sessionBeanType, resourceRefs);
            }
        }
        if (!ejbJarType.getMetadataComplete()) {
            ejbJarType.setMetadataComplete(true);
            this.ejbModule.setOriginalSpecDD(this.ejbModule.getSpecDD().toString());
        }
    }

    private void addEnc(GBeanData gbean, XmlObject xmlbeansEjb, ResourceRefType[] resourceRefs) throws DeploymentException {
        OpenejbGeronimoEjbJarType geronimoOpenejb = this.ejbModule.getVendorDD();
        HashMap<NamingBuilder.Key, AbstractName> buildingContext = new HashMap<NamingBuilder.Key, AbstractName>();
        buildingContext.put(NamingBuilder.GBEAN_NAME_KEY, gbean.getAbstractName());
        ((AnnotatedEjbJar)this.ejbModule.getAnnotatedApp()).setBean(xmlbeansEjb);
        this.namingBuilder.buildNaming(xmlbeansEjb, (XmlObject)geronimoOpenejb, (Module)this.ejbModule, buildingContext);
        Map compContext = (Map)NamingBuilder.JNDI_KEY.get(buildingContext);
        gbean.setAttribute("componentContextMap", (Object)compContext);
        GerResourceRefType[] gerResourceRefs = null;
        if (geronimoOpenejb != null) {
            gerResourceRefs = geronimoOpenejb.getResourceRefArray();
        }
        GBeanResourceEnvironmentBuilder refBuilder = new GBeanResourceEnvironmentBuilder(gbean);
        this.resourceEnvironmentSetter.setResourceEnvironment((ResourceEnvironmentBuilder)refBuilder, (XmlObject[])resourceRefs, gerResourceRefs);
    }

    private ClassFinder createEjbJarClassFinder(EjbModule ejbModule) throws DeploymentException {
        try {
            ClassLoader classLoader = ejbModule.getEarContext().getClassLoader();
            ArrayList classes = new ArrayList();
            for (EnterpriseBean bean : ejbModule.getEjbJar().getEnterpriseBeans()) {
                classes.add(classLoader.loadClass(bean.getEjbClass()));
            }
            return new ClassFinder(classes);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Unable to load bean class.", (Throwable)e);
        }
    }

    private GBeanData getEjbGBean(String ejbName) throws DeploymentException {
        GBeanData gbean = this.gbeans.get(ejbName);
        if (gbean == null) {
            throw new DeploymentException("EJB not gbean not found " + ejbName);
        }
        return gbean;
    }

    private static Class assureEJBObjectInterface(String remote, ClassLoader cl) throws DeploymentException {
        return AbstractNamingBuilder.assureInterface((String)remote, (String)"javax.ejb.EJBObject", (String)"Remote", (ClassLoader)cl);
    }

    private static Class assureEJBHomeInterface(String home, ClassLoader cl) throws DeploymentException {
        return AbstractNamingBuilder.assureInterface((String)home, (String)"javax.ejb.EJBHome", (String)"Home", (ClassLoader)cl);
    }

    public static Class assureEJBLocalObjectInterface(String local, ClassLoader cl) throws DeploymentException {
        return AbstractNamingBuilder.assureInterface((String)local, (String)"javax.ejb.EJBLocalObject", (String)"Local", (ClassLoader)cl);
    }

    public static Class assureEJBLocalHomeInterface(String localHome, ClassLoader cl) throws DeploymentException {
        return AbstractNamingBuilder.assureInterface((String)localHome, (String)"javax.ejb.EJBLocalHome", (String)"LocalHome", (ClassLoader)cl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PermissionCollectionAdapter
    implements Collection<Permission> {
        private final PermissionCollection p;

        private PermissionCollectionAdapter(PermissionCollection p) {
            this.p = p;
        }

        @Override
        public int size() {
            throw new RuntimeException("not implemented");
        }

        @Override
        public boolean isEmpty() {
            throw new RuntimeException("not implemented");
        }

        @Override
        public boolean contains(Object o) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public Iterator<Permission> iterator() {
            throw new RuntimeException("not implemented");
        }

        @Override
        public Object[] toArray() {
            throw new RuntimeException("not implemented");
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public boolean add(Permission o) {
            if (this.p.implies(o)) {
                return false;
            }
            this.p.add(o);
            return true;
        }

        @Override
        public boolean remove(Object o) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public boolean addAll(Collection<? extends Permission> c) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public void clear() {
            throw new RuntimeException("not implemented");
        }
    }
}

