/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb.deployment;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotatedApp;
import org.apache.geronimo.j2ee.deployment.annotation.EJBAnnotationHelper;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.AbstractNamingBuilder;
import org.apache.geronimo.openejb.ClientEjbReference;
import org.apache.geronimo.openejb.deployment.EjbModuleBuilder;
import org.apache.geronimo.schema.NamespaceElementConverter;
import org.apache.geronimo.xbeans.geronimo.naming.GerEjbLocalRefDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerEjbLocalRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerEjbRefDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerEjbRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerPatternType;
import org.apache.geronimo.xbeans.javaee.EjbLocalRefType;
import org.apache.geronimo.xbeans.javaee.EjbRefType;
import org.apache.geronimo.xbeans.javaee.InjectionTargetType;
import org.apache.geronimo.xbeans.javaee.XsdStringType;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.JndiEncBuilder;
import org.apache.openejb.assembler.classic.JndiEncInfo;
import org.apache.openejb.config.JndiEncInfoBuilder;
import org.apache.openejb.core.ivm.naming.IntraVmJndiReference;
import org.apache.openejb.jee.EjbLocalRef;
import org.apache.openejb.jee.EjbRef;
import org.apache.openejb.jee.EjbReference;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.SessionBean;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.QNameSetSpecification;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbRefBuilder
extends AbstractNamingBuilder {
    private static final Log log = LogFactory.getLog(EjbRefBuilder.class);
    private final QNameSet ejbRefQNameSet;
    private final QNameSet ejbLocalRefQNameSet;
    private final URI uri;
    public static final GBeanInfo GBEAN_INFO;

    public EjbRefBuilder(Environment defaultEnvironment, String[] eeNamespaces, String host, int port) throws URISyntaxException {
        super(defaultEnvironment);
        this.uri = host != null ? new URI("ejb", null, host, port, null, null, null) : null;
        this.ejbRefQNameSet = EjbRefBuilder.buildQNameSet((String[])eeNamespaces, (String)"ejb-ref");
        this.ejbLocalRefQNameSet = EjbRefBuilder.buildQNameSet((String[])eeNamespaces, (String)"ejb-local-ref");
        this.ejbRefQNameSet.union((QNameSetSpecification)this.ejbLocalRefQNameSet);
    }

    public QNameSet getSpecQNameSet() {
        return this.ejbRefQNameSet;
    }

    public QNameSet getPlanQNameSet() {
        return QNameSet.EMPTY;
    }

    protected boolean willMergeEnvironment(XmlObject specDD, XmlObject plan) {
        return specDD.selectChildren(this.ejbRefQNameSet).length > 0 || specDD.selectChildren(this.ejbLocalRefQNameSet).length > 0;
    }

    public void buildNaming(XmlObject specDD, XmlObject plan, Module module, Map componentContext) throws DeploymentException {
        if (module.getType() == ConfigurationModuleType.EJB) {
            return;
        }
        Map<String, GerEjbRefType> refMap = this.mapEjbRefs(plan);
        Map<String, GerEjbLocalRefType> localRefMap = this.mapEjbLocalRefs(plan);
        SessionBean consumer = new SessionBean();
        List<EjbRefType> ejbRefs = EjbRefBuilder.convert((XmlObject[])specDD.selectChildren(this.ejbRefQNameSet), (NamespaceElementConverter)JEE_CONVERTER, EjbRefType.class, (SchemaType)EjbRefType.type);
        List<EjbLocalRefType> ejbLocalRefs = EjbRefBuilder.convert((XmlObject[])specDD.selectChildren(this.ejbLocalRefQNameSet), (NamespaceElementConverter)JEE_CONVERTER, EjbLocalRefType.class, (SchemaType)EjbLocalRefType.type);
        this.addRefs((JndiConsumer)consumer, ejbRefs, refMap, ejbLocalRefs, localRefMap, componentContext);
        if (module != null && module.getClassFinder() != null) {
            this.processAnnotations(module);
            ejbRefs = EjbRefBuilder.asList(module.getAnnotatedApp().getEjbRefArray());
            ejbLocalRefs = EjbRefBuilder.asList(module.getAnnotatedApp().getEjbLocalRefArray());
            ejbRefs.addAll(module.getAnnotatedApp().getAmbiguousEjbRefs());
            this.addRefs((JndiConsumer)consumer, ejbRefs, refMap, ejbLocalRefs, localRefMap, componentContext);
        }
        Map map = null;
        try {
            EjbModuleBuilder.EarData earData = (EjbModuleBuilder.EarData)module.getRootEarContext().getGeneralData().get(EjbModuleBuilder.EarData.class);
            Collection<Object> ejbJars = Collections.emptySet();
            if (earData != null) {
                ejbJars = earData.getEjbJars();
            }
            AppInfo appInfo = new AppInfo();
            appInfo.ejbJars.addAll(ejbJars);
            JndiEncInfoBuilder jndiEncInfoBuilder = new JndiEncInfoBuilder(appInfo);
            JndiEncInfo jndiEncInfo = module.isStandAlone() ? jndiEncInfoBuilder.build((JndiConsumer)consumer, "GeronimoEnc", null) : jndiEncInfoBuilder.build((JndiConsumer)consumer, "GeronimoEnc", module.getTargetPath());
            JndiEncBuilder jndiEncBuilder = new JndiEncBuilder(jndiEncInfo, null, module.getName(), ((Object)((Object)this)).getClass().getClassLoader());
            map = jndiEncBuilder.buildMap();
        }
        catch (OpenEJBException e) {
            throw new DeploymentException((Throwable)e);
        }
        for (Map.Entry entry : map.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (name.startsWith("java:comp/")) {
                name = name.substring("java:comp/".length());
            }
            if (!name.startsWith("env/")) continue;
            if (this.uri != null) {
                value = this.createClientRef(value);
            }
            this.getJndiContextMap(componentContext).put(name, value);
        }
    }

    private Object createClientRef(Object value) {
        if (value instanceof IntraVmJndiReference) {
            IntraVmJndiReference intraVmJndiReference = (IntraVmJndiReference)value;
            String deploymentId = intraVmJndiReference.getJndiName();
            if (deploymentId.startsWith("java:openejb/ejb/")) {
                deploymentId = deploymentId.substring("java:openejb/ejb/".length());
            }
            if (deploymentId.startsWith("java:openejb/Deployment/")) {
                deploymentId = deploymentId.substring("java:openejb/Deployment/".length());
            }
            ClientEjbReference clientRef = new ClientEjbReference(this.uri.toString(), deploymentId);
            return clientRef;
        }
        return value;
    }

    private void addRefs(JndiConsumer jndiConsumer, List<EjbRefType> ejbRefs, Map<String, GerEjbRefType> refMap, List<EjbLocalRefType> ejbLocalRefs, Map<String, GerEjbLocalRefType> localRefMap, Map componentContext) {
        String refType;
        EjbRef ref;
        TreeSet<String> declaredEjbRefs = new TreeSet<String>();
        for (EjbRef ejbRef : jndiConsumer.getEjbRef()) {
            declaredEjbRefs.add(ejbRef.getName());
        }
        for (EjbRefType xmlbeansRef : ejbRefs) {
            GerEjbRefType ejbRefType;
            String refName = EjbRefBuilder.getStringValue((org.apache.geronimo.xbeans.javaee.String)xmlbeansRef.getEjbRefName());
            if (declaredEjbRefs.contains(refName) || (ejbRefType = refMap.get(refName)) != null && ejbRefType.getNsCorbaloc() != null) continue;
            ref = new EjbRef();
            ref.setEjbRefName(refName);
            jndiConsumer.getEjbRef().add(ref);
            refType = EjbRefBuilder.getStringValue((org.apache.geronimo.xbeans.javaee.String)xmlbeansRef.getEjbRefType());
            if ("SESSION".equalsIgnoreCase(refType)) {
                ref.setEjbRefType(org.apache.openejb.jee.EjbRefType.SESSION);
            } else if ("ENTITY".equalsIgnoreCase(refType)) {
                ref.setEjbRefType(org.apache.openejb.jee.EjbRefType.ENTITY);
            } else {
                ref.setRefType(EjbReference.Type.UNKNOWN);
            }
            ref.setHome(EjbRefBuilder.getStringValue((org.apache.geronimo.xbeans.javaee.String)xmlbeansRef.getHome()));
            ref.setRemote(EjbRefBuilder.getStringValue((org.apache.geronimo.xbeans.javaee.String)xmlbeansRef.getRemote()));
            ref.setEjbLink(EjbRefBuilder.getStringValue((org.apache.geronimo.xbeans.javaee.String)xmlbeansRef.getEjbLink()));
            ref.setMappedName(EjbRefBuilder.getStringValue((XsdStringType)xmlbeansRef.getMappedName()));
            if (ejbRefType != null) {
                if (ejbRefType.getNsCorbaloc() != null) {
                    ref.setMappedName("jndi:java:comp/geronimo/env/" + ref.getEjbRefName());
                } else if (ejbRefType.getPattern() != null) {
                    GerPatternType pattern = ejbRefType.getPattern();
                    String module = pattern.getModule();
                    if (module == null) {
                        module = pattern.getArtifactId();
                    }
                    String ejbName = pattern.getName();
                    String deploymentId = module.trim() + "/" + ejbName;
                    ref.setMappedName(deploymentId.trim());
                }
            }
            if (xmlbeansRef.getInjectionTargetArray() != null) {
                for (InjectionTargetType injectionTargetType : xmlbeansRef.getInjectionTargetArray()) {
                    InjectionTarget injectionTarget = new InjectionTarget();
                    injectionTarget.setInjectionTargetClass(EjbRefBuilder.getStringValue((org.apache.geronimo.xbeans.javaee.String)injectionTargetType.getInjectionTargetClass()));
                    injectionTarget.setInjectionTargetName(EjbRefBuilder.getStringValue((org.apache.geronimo.xbeans.javaee.String)injectionTargetType.getInjectionTargetName()));
                    ref.getInjectionTarget().add(injectionTarget);
                }
            }
            this.addInjections(refName, xmlbeansRef.getInjectionTargetArray(), componentContext);
        }
        TreeSet<String> declaredEjbLocalRefs = new TreeSet<String>();
        for (EjbLocalRef ejbLocalRef : jndiConsumer.getEjbLocalRef()) {
            declaredEjbLocalRefs.add(ejbLocalRef.getName());
        }
        for (EjbLocalRefType xmlbeansRef : ejbLocalRefs) {
            String refName = EjbRefBuilder.getStringValue((org.apache.geronimo.xbeans.javaee.String)xmlbeansRef.getEjbRefName());
            if (declaredEjbLocalRefs.contains(refName)) continue;
            ref = new EjbLocalRef();
            ref.setEjbRefName(refName);
            jndiConsumer.getEjbLocalRef().add(ref);
            refType = EjbRefBuilder.getStringValue((org.apache.geronimo.xbeans.javaee.String)xmlbeansRef.getEjbRefType());
            if ("SESSION".equalsIgnoreCase(refType)) {
                ref.setEjbRefType(org.apache.openejb.jee.EjbRefType.SESSION);
            } else if ("ENTITY".equalsIgnoreCase(refType)) {
                ref.setEjbRefType(org.apache.openejb.jee.EjbRefType.ENTITY);
            }
            ref.setLocalHome(EjbRefBuilder.getStringValue((org.apache.geronimo.xbeans.javaee.String)xmlbeansRef.getLocalHome()));
            ref.setLocal(EjbRefBuilder.getStringValue((org.apache.geronimo.xbeans.javaee.String)xmlbeansRef.getLocal()));
            ref.setEjbLink(EjbRefBuilder.getStringValue((org.apache.geronimo.xbeans.javaee.String)xmlbeansRef.getEjbLink()));
            ref.setMappedName(EjbRefBuilder.getStringValue((XsdStringType)xmlbeansRef.getMappedName()));
            GerEjbLocalRefType ejbLocalRefType = localRefMap.get(ref.getEjbRefName());
            if (ejbLocalRefType != null && ejbLocalRefType.getPattern() != null) {
                GerPatternType pattern = ejbLocalRefType.getPattern();
                String module = pattern.getModule();
                if (module == null) {
                    module = pattern.getArtifactId();
                }
                String ejbName = pattern.getName();
                String deploymentId = module.trim() + "/" + ejbName;
                ref.setMappedName(deploymentId.trim());
            }
            if (xmlbeansRef.getInjectionTargetArray() != null) {
                for (InjectionTargetType injectionTargetType : xmlbeansRef.getInjectionTargetArray()) {
                    InjectionTarget injectionTarget = new InjectionTarget();
                    injectionTarget.setInjectionTargetClass(EjbRefBuilder.getStringValue((org.apache.geronimo.xbeans.javaee.String)injectionTargetType.getInjectionTargetClass()));
                    injectionTarget.setInjectionTargetName(EjbRefBuilder.getStringValue((org.apache.geronimo.xbeans.javaee.String)injectionTargetType.getInjectionTargetName()));
                    ref.getInjectionTarget().add(injectionTarget);
                }
            }
            this.addInjections(refName, xmlbeansRef.getInjectionTargetArray(), componentContext);
        }
    }

    private Map<String, GerEjbRefType> mapEjbRefs(XmlObject plan) {
        HashMap<String, GerEjbRefType> refMap = new HashMap<String, GerEjbRefType>();
        if (plan == null) {
            return refMap;
        }
        QNameSet qnameSet = QNameSet.singleton((QName)GerEjbRefDocument.type.getDocumentElementName());
        XmlObject[] xmlObjects = plan.selectChildren(qnameSet);
        if (xmlObjects != null) {
            for (XmlObject xmlObject : xmlObjects) {
                GerEjbRefType ref = (GerEjbRefType)xmlObject.copy().changeType(GerEjbRefType.type);
                refMap.put(ref.getRefName().trim(), ref);
            }
        }
        return refMap;
    }

    private Map<String, GerEjbLocalRefType> mapEjbLocalRefs(XmlObject plan) {
        HashMap<String, GerEjbLocalRefType> refMap = new HashMap<String, GerEjbLocalRefType>();
        if (plan == null) {
            return refMap;
        }
        QNameSet qnameSet = QNameSet.singleton((QName)GerEjbLocalRefDocument.type.getDocumentElementName());
        XmlObject[] xmlObjects = plan.selectChildren(qnameSet);
        if (xmlObjects != null) {
            for (XmlObject xmlObject : xmlObjects) {
                GerEjbLocalRefType ref = (GerEjbLocalRefType)xmlObject.copy().changeType(GerEjbLocalRefType.type);
                refMap.put(ref.getRefName().trim(), ref);
            }
        }
        return refMap;
    }

    public static <E> List<E> asList(E[] array) {
        if (array == null) {
            return new ArrayList();
        }
        return new ArrayList<E>(Arrays.asList(array));
    }

    private void processAnnotations(Module module) {
        if (EJBAnnotationHelper.annotationsPresent((ClassFinder)module.getClassFinder())) {
            try {
                EJBAnnotationHelper.processAnnotations((AnnotatedApp)module.getAnnotatedApp(), (ClassFinder)module.getClassFinder());
            }
            catch (Exception e) {
                log.warn((Object)("Unable to process @EJB annotations for module" + module.getName()), (Throwable)e);
            }
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(EjbRefBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("eeNamespaces", String[].class, true, true);
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("host", String.class, true);
        infoBuilder.addAttribute("port", Integer.TYPE, true);
        infoBuilder.setConstructor(new String[]{"defaultEnvironment", "eeNamespaces", "host", "port"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

