/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.reference;

import javax.naming.NameNotFoundException;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.naming.reference.ConfigurationAwareReference;

public class ResourceReference
extends ConfigurationAwareReference {
    private final Class iface;

    public ResourceReference(Artifact[] configId, AbstractNameQuery abstractNameQuery, Class iface) {
        super(configId, abstractNameQuery);
        this.iface = iface;
    }

    public String getClassName() {
        return this.iface.getName();
    }

    public Object getContent() throws NameNotFoundException {
        Object proxy;
        AbstractName target;
        Kernel kernel = this.getKernel();
        try {
            target = this.resolveTargetName();
        }
        catch (GBeanNotFoundException e) {
            throw (NameNotFoundException)new NameNotFoundException("Could not resolve name query: " + this.abstractNameQueries).initCause(e);
        }
        try {
            proxy = kernel.invoke(target, "$getResource");
        }
        catch (Exception e) {
            throw (IllegalStateException)new IllegalStateException("Could not get proxy").initCause(e);
        }
        if (proxy == null) {
            throw new IllegalStateException("Proxy not returned. Target " + target + " not started");
        }
        if (!this.iface.isAssignableFrom(proxy.getClass())) {
            Class<?> proxyClass = proxy.getClass();
            Class<?>[] interfaces = proxyClass.getInterfaces();
            StringBuffer message = new StringBuffer();
            boolean namesMatch = false;
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> anInterface = interfaces[i];
                if (!this.iface.getName().equals(anInterface.getName())) continue;
                namesMatch = true;
                message.append("Proxy implements correct interface: ").append(this.iface.getName()).append(", but classloaders differ\n");
                message.append("lookup interface classloader: ").append(this.iface.getClassLoader().toString()).append("\n");
                message.append("target interface classloader: ").append(anInterface.getClassLoader().toString()).append("\n");
                message.append("target proxy classloader: ").append(proxy.getClass().getClassLoader());
                break;
            }
            if (!namesMatch) {
                message.append("Proxy does not implement an interface named: ").append(this.iface.getName());
            }
            throw new ClassCastException(message.toString());
        }
        return proxy;
    }
}

