/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.deployment;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotatedApp;
import org.apache.geronimo.j2ee.deployment.annotation.ResourceAnnotationHelper;
import org.apache.geronimo.j2ee.deployment.annotation.WebServiceRefAnnotationHelper;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.AbstractNamingBuilder;
import org.apache.geronimo.naming.deployment.ServiceRefBuilder;
import org.apache.geronimo.xbeans.geronimo.naming.GerServiceRefDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerServiceRefType;
import org.apache.geronimo.xbeans.javaee.DescriptionType;
import org.apache.geronimo.xbeans.javaee.FullyQualifiedClassType;
import org.apache.geronimo.xbeans.javaee.InjectionTargetType;
import org.apache.geronimo.xbeans.javaee.JndiNameType;
import org.apache.geronimo.xbeans.javaee.ServiceRefType;
import org.apache.geronimo.xbeans.javaee.String;
import org.apache.geronimo.xbeans.javaee.XsdStringType;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.XmlObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchingServiceRefBuilder
extends AbstractNamingBuilder {
    private static final Logger log = LoggerFactory.getLogger(SwitchingServiceRefBuilder.class);
    private static final QName GER_SERVICE_REF_QNAME = GerServiceRefDocument.type.getDocumentElementName();
    private static final QNameSet GER_SERVICE_REF_QNAME_SET = QNameSet.singleton((QName)GER_SERVICE_REF_QNAME);
    private final QNameSet serviceRefQNameSet;
    private final Collection jaxrpcBuilders;
    private final Collection jaxwsBuilders;
    public static final GBeanInfo GBEAN_INFO;

    public SwitchingServiceRefBuilder(java.lang.String[] eeNamespaces, Collection jaxrpcBuilders, Collection jaxwsBuilders) {
        super(null);
        this.jaxrpcBuilders = jaxrpcBuilders;
        this.jaxwsBuilders = jaxwsBuilders;
        this.serviceRefQNameSet = SwitchingServiceRefBuilder.buildQNameSet(eeNamespaces, "service-ref");
    }

    public void buildEnvironment(XmlObject specDD, XmlObject plan, Environment environment) throws DeploymentException {
        if (this.jaxrpcBuilders != null && !this.jaxrpcBuilders.isEmpty()) {
            this.mergeEnvironment(environment, this.getJAXRCPBuilder());
        }
        if (this.jaxwsBuilders != null && !this.jaxwsBuilders.isEmpty()) {
            this.mergeEnvironment(environment, this.getJAXWSBuilder());
        }
    }

    public void buildNaming(XmlObject specDD, XmlObject plan, Module module, Map componentContext) throws DeploymentException {
        if (module != null && module.getClassFinder() != null) {
            this.processAnnotations(module);
        }
        ClassLoader cl = module.getEarContext().getClassLoader();
        Class jaxrpcClass = this.loadClass("javax.xml.rpc.Service", cl);
        Class jaxwsClass = this.loadClass("javax.xml.ws.Service", cl);
        XmlObject[] serviceRefs = specDD.selectChildren(this.serviceRefQNameSet);
        XmlObject[] gerServiceRefsUntyped = plan == null ? NO_REFS : plan.selectChildren(GER_SERVICE_REF_QNAME_SET);
        Map serviceRefMap = SwitchingServiceRefBuilder.mapServiceRefs(gerServiceRefsUntyped);
        for (XmlObject serviceRef : serviceRefs) {
            ServiceRefType serviceRefType = (ServiceRefType)SwitchingServiceRefBuilder.convert(serviceRef, JEE_CONVERTER, ServiceRefType.type);
            java.lang.String name = SwitchingServiceRefBuilder.getStringValue((String)serviceRefType.getServiceRefName());
            GerServiceRefType gerServiceRefType = (GerServiceRefType)serviceRefMap.get(name);
            serviceRefMap.remove(name);
            java.lang.String serviceInterfaceName = SwitchingServiceRefBuilder.getStringValue((String)serviceRefType.getServiceInterface());
            Class serviceInterfaceClass = this.loadClass(serviceInterfaceName, cl);
            InjectionTargetType[] injections = serviceRefType.getInjectionTargetArray();
            this.addInjections(name, injections, componentContext);
            if (jaxrpcClass.isAssignableFrom(serviceInterfaceClass)) {
                ServiceRefBuilder jaxrpcBuilder = this.getJAXRCPBuilder();
                jaxrpcBuilder.buildNaming(serviceRef, gerServiceRefType, module, componentContext);
                continue;
            }
            if (jaxwsClass.isAssignableFrom(serviceInterfaceClass)) {
                ServiceRefBuilder jaxwsBuilder = this.getJAXWSBuilder();
                jaxwsBuilder.buildNaming(serviceRef, gerServiceRefType, module, componentContext);
                continue;
            }
            throw new DeploymentException(serviceInterfaceName + " does not extend " + jaxrpcClass.getName() + " or " + jaxwsClass.getName());
        }
        if (serviceRefMap.size() > 0) {
            log.warn("Failed to build reference to service reference " + serviceRefMap.keySet() + " defined in plan file, reason - corresponding entry in deployment descriptor missing.");
        }
    }

    private ServiceRefBuilder getJAXWSBuilder() throws DeploymentException {
        ServiceRefBuilder jaxwsBuilder = null;
        if (this.jaxwsBuilders == null || this.jaxwsBuilders.isEmpty()) {
            throw new DeploymentException("No JAX-WS ServiceRefBuilders registered");
        }
        jaxwsBuilder = (ServiceRefBuilder)this.jaxwsBuilders.iterator().next();
        return jaxwsBuilder;
    }

    private ServiceRefBuilder getJAXRCPBuilder() throws DeploymentException {
        ServiceRefBuilder jaxrpcBuilder = null;
        if (this.jaxrpcBuilders == null || this.jaxrpcBuilders.isEmpty()) {
            throw new DeploymentException("No JAX-RPC ServiceRefBuilders registered");
        }
        jaxrpcBuilder = (ServiceRefBuilder)this.jaxrpcBuilders.iterator().next();
        return jaxrpcBuilder;
    }

    private void mergeEnvironment(Environment environment, ServiceRefBuilder builder) {
        Environment env = builder.getEnvironment();
        if (env != null) {
            EnvironmentBuilder.mergeEnvironments((Environment)environment, (Environment)env);
        }
    }

    private Class loadClass(java.lang.String name, ClassLoader cl) throws DeploymentException {
        try {
            return cl.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Could not load service class " + name, (Throwable)e);
        }
    }

    private static Map mapServiceRefs(XmlObject[] refs) {
        HashMap<java.lang.String, GerServiceRefType> refMap = new HashMap<java.lang.String, GerServiceRefType>();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                GerServiceRefType ref = (GerServiceRefType)refs[i].copy().changeType(GerServiceRefType.type);
                java.lang.String serviceRefName = ref.getServiceRefName().trim();
                refMap.put(serviceRefName, ref);
            }
        }
        return refMap;
    }

    private void processAnnotations(Module module) throws DeploymentException {
        try {
            WebServiceRefAnnotationHelper.processAnnotations((AnnotatedApp)module.getAnnotatedApp(), (ClassFinder)module.getClassFinder());
            ResourceAnnotationHelper.processAnnotations((AnnotatedApp)module.getAnnotatedApp(), (ClassFinder)module.getClassFinder(), (ResourceAnnotationHelper.ResourceProcessor)ServiceRefProcessor.INSTANCE);
        }
        catch (Exception e) {
            log.warn("Unable to process @Resource annotations for module" + module.getName(), (Throwable)e);
        }
    }

    public QNameSet getSpecQNameSet() {
        return this.serviceRefQNameSet;
    }

    public QNameSet getPlanQNameSet() {
        return GER_SERVICE_REF_QNAME_SET;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(SwitchingServiceRefBuilder.class, (java.lang.String)"ModuleBuilder");
        infoBuilder.addAttribute("eeNamespaces", java.lang.String[].class, true, true);
        infoBuilder.addReference("JAXRPCBuilder", ServiceRefBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("JAXWSBuilder", ServiceRefBuilder.class, "ModuleBuilder");
        infoBuilder.setConstructor(new java.lang.String[]{"eeNamespaces", "JAXRPCBuilder", "JAXWSBuilder"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }

    public static class ServiceRefProcessor
    extends ResourceAnnotationHelper.ResourceProcessor {
        public static final ServiceRefProcessor INSTANCE = new ServiceRefProcessor();

        private ServiceRefProcessor() {
        }

        public boolean processResource(AnnotatedApp annotatedApp, Resource annotation, Class cls, Method method, Field field) {
            log.debug("processResource( [annotatedApp] " + annotatedApp.toString() + "," + '\n' + "[annotation] " + annotation.toString() + "," + '\n' + "[cls] " + (cls != null ? cls.getName() : null) + "," + '\n' + "[method] " + (method != null ? method.getName() : null) + "," + '\n' + "[field] " + (field != null ? field.getName() : null) + " ): Entry");
            java.lang.String resourceName = ServiceRefProcessor.getResourceName((Resource)annotation, (Method)method, (Field)field);
            java.lang.String resourceType = ServiceRefProcessor.getResourceType((Resource)annotation, (Method)method, (Field)field);
            log.debug("processResource(): resourceName: " + resourceName);
            log.debug("processResource(): resourceType: " + resourceType);
            if (resourceType.equals("javax.xml.rpc.Service") || resourceType.equals("javax.xml.ws.Service") || resourceType.equals("javax.jws.WebService")) {
                ServiceRefType[] serviceRefs;
                log.debug("processResource(): <service-ref> found");
                boolean exists = false;
                for (ServiceRefType serviceRef : serviceRefs = annotatedApp.getServiceRefArray()) {
                    InjectionTargetType[] targets;
                    if (!serviceRef.getServiceRefName().getStringValue().trim().equals(resourceName)) continue;
                    if (!(method == null && field == null || ServiceRefProcessor.hasTarget((Method)method, (Field)field, (InjectionTargetType[])(targets = serviceRef.getInjectionTargetArray())))) {
                        ServiceRefProcessor.configureInjectionTarget((InjectionTargetType)serviceRef.addNewInjectionTarget(), (Method)method, (Field)field);
                    }
                    exists = true;
                    break;
                }
                if (!exists) {
                    try {
                        log.debug("processResource(): Does not exist in DD: " + resourceName);
                        ServiceRefType serviceRef = annotatedApp.addNewServiceRef();
                        JndiNameType serviceRefName = serviceRef.addNewServiceRefName();
                        serviceRefName.setStringValue(resourceName);
                        serviceRef.setServiceRefName(serviceRefName);
                        FullyQualifiedClassType serviceRefInterfaceClass = serviceRef.addNewServiceInterface();
                        serviceRefInterfaceClass.setStringValue(resourceType);
                        serviceRef.setServiceInterface(serviceRefInterfaceClass);
                        java.lang.String descriptionAnnotation = annotation.description();
                        if (!descriptionAnnotation.equals("")) {
                            DescriptionType description = serviceRef.addNewDescription();
                            description.setStringValue(descriptionAnnotation);
                        }
                        if (!serviceRef.isSetServiceRefType()) {
                            FullyQualifiedClassType serviceRefTypeClass = serviceRef.addNewServiceRefType();
                            serviceRefTypeClass.setStringValue(resourceType);
                            serviceRef.setServiceRefType(serviceRefTypeClass);
                        }
                        if (method != null || field != null) {
                            InjectionTargetType injectionTarget = serviceRef.addNewInjectionTarget();
                            ServiceRefProcessor.configureInjectionTarget((InjectionTargetType)injectionTarget, (Method)method, (Field)field);
                        }
                        if (!serviceRef.isSetMappedName() && annotation.mappedName().trim().length() > 0) {
                            XsdStringType mappedName = serviceRef.addNewMappedName();
                            mappedName.setStringValue(annotation.mappedName().trim());
                            serviceRef.setMappedName(mappedName);
                        }
                    }
                    catch (Exception anyException) {
                        log.debug("SwitchServiceRefBuilder: Exception caught while processing <service-ref>");
                    }
                }
                return true;
            }
            return false;
        }
    }
}

