/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.deployment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.j2ee.annotation.Holder;
import org.apache.geronimo.j2ee.annotation.Injection;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.ImportType;
import org.apache.geronimo.naming.deployment.ENCConfigBuilder;
import org.apache.geronimo.schema.NamespaceElementConverter;
import org.apache.geronimo.xbeans.geronimo.naming.GerAbstractNamingEntryDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerAbstractNamingEntryType;
import org.apache.geronimo.xbeans.geronimo.naming.GerPatternType;
import org.apache.geronimo.xbeans.javaee.InjectionTargetType;
import org.apache.geronimo.xbeans.javaee.String;
import org.apache.geronimo.xbeans.javaee.XsdStringType;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNamingBuilder
implements NamingBuilder {
    protected static final QName BASE_NAMING_QNAME = GerAbstractNamingEntryType.type.getDocumentElementName();
    protected static final java.lang.String J2EE_NAMESPACE = "http://java.sun.com/xml/ns/j2ee";
    protected static final java.lang.String JEE_NAMESPACE = "http://java.sun.com/xml/ns/javaee";
    protected static final NamespaceElementConverter J2EE_CONVERTER = new NamespaceElementConverter("http://java.sun.com/xml/ns/j2ee");
    protected static final NamespaceElementConverter JEE_CONVERTER = new NamespaceElementConverter("http://java.sun.com/xml/ns/javaee");
    protected static final NamespaceElementConverter NAMING_CONVERTER = new NamespaceElementConverter(GerAbstractNamingEntryDocument.type.getDocumentElementName().getNamespaceURI());
    private final Environment defaultEnvironment;

    protected AbstractNamingBuilder() {
        this.defaultEnvironment = null;
    }

    protected AbstractNamingBuilder(Environment defaultEnvironment) {
        this.defaultEnvironment = defaultEnvironment;
    }

    public Environment getEnvironment() {
        return this.defaultEnvironment;
    }

    public void buildEnvironment(XmlObject specDD, XmlObject plan, Environment environment) throws DeploymentException {
        EnvironmentBuilder.mergeEnvironments((Environment)environment, (Environment)this.defaultEnvironment);
    }

    protected boolean willMergeEnvironment(XmlObject specDD, XmlObject plan) throws DeploymentException {
        return false;
    }

    protected boolean matchesDefaultEnvironment(Environment environment) {
        for (Dependency defaultDependency : this.defaultEnvironment.getDependencies()) {
            boolean matches = false;
            for (Dependency actualDependency : environment.getDependencies()) {
                if (!this.matches(defaultDependency, actualDependency)) continue;
                matches = true;
                break;
            }
            if (matches) continue;
            return false;
        }
        return true;
    }

    private boolean matches(Dependency defaultDependency, Dependency actualDependency) {
        if (defaultDependency.getArtifact().matches(actualDependency.getArtifact()) || actualDependency.getArtifact().matches(defaultDependency.getArtifact())) {
            return defaultDependency.getImportType() == actualDependency.getImportType() || actualDependency.getImportType() == ImportType.ALL;
        }
        return false;
    }

    public void initContext(XmlObject specDD, XmlObject plan, Module module) throws DeploymentException {
    }

    public int getPriority() {
        return 50;
    }

    protected Object lookupJndiContextMap(Map sharedContext, java.lang.String name) {
        Map<java.lang.String, Object> jndiContext = this.getJndiContextMap(sharedContext);
        return jndiContext.get(name);
    }

    protected Map<java.lang.String, Object> getJndiContextMap(Map sharedContext) {
        return (Map)NamingBuilder.JNDI_KEY.get(sharedContext);
    }

    protected AbstractName getGBeanName(Map sharedContext) {
        return (AbstractName)GBEAN_NAME_KEY.get(sharedContext);
    }

    protected static QNameSet buildQNameSet(java.lang.String[] eeNamespaces, java.lang.String localPart) {
        HashSet<QName> qnames = new HashSet<QName>(eeNamespaces.length);
        for (int i = 0; i < eeNamespaces.length; ++i) {
            java.lang.String namespace = eeNamespaces[i];
            qnames.add(new QName(namespace, localPart));
        }
        return QNameSet.forSets(null, (Set)Collections.EMPTY_SET, (Set)Collections.EMPTY_SET, qnames);
    }

    protected static XmlObject[] convert(XmlObject[] xmlObjects, NamespaceElementConverter converter, SchemaType type) throws DeploymentException {
        XmlObject[] converted = new XmlObject[xmlObjects.length];
        for (int i = 0; i < xmlObjects.length; ++i) {
            XmlObject xmlObject = xmlObjects[i].copy();
            if (xmlObject.schemaType() != type) {
                converter.convertElement(xmlObject);
                converted[i] = xmlObject.changeType(type);
            } else {
                converted[i] = xmlObject;
            }
            try {
                XmlBeansUtil.validateDD((XmlObject)converted[i]);
                continue;
            }
            catch (XmlException e) {
                throw new DeploymentException("Could not validate xmlObject of type " + type, (Throwable)e);
            }
        }
        return converted;
    }

    protected static <T extends XmlObject> List<T> convert(XmlObject[] xmlObjects, NamespaceElementConverter converter, Class<T> c, SchemaType type) throws DeploymentException {
        ArrayList<XmlObject> result = new ArrayList<XmlObject>(xmlObjects.length);
        for (XmlObject xmlObject : xmlObjects) {
            xmlObject = AbstractNamingBuilder.convert(xmlObject, converter, type);
            result.add(xmlObject);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static XmlObject convert(XmlObject xmlObject, NamespaceElementConverter converter, SchemaType type) throws DeploymentException {
        HashMap ns = new HashMap();
        XmlCursor cursor = xmlObject.newCursor();
        try {
            cursor.getAllNamespaces(ns);
        }
        finally {
            cursor.dispose();
        }
        xmlObject = xmlObject.copy();
        cursor = xmlObject.newCursor();
        cursor.toNextToken();
        try {
            Iterator i$ = ns.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = i$.next();
                cursor.insertNamespace((java.lang.String)entry.getKey(), (java.lang.String)entry.getValue());
            }
        }
        finally {
            cursor.dispose();
        }
        if (xmlObject.schemaType() != type) {
            converter.convertElement(xmlObject);
            xmlObject = xmlObject.changeType(type);
        }
        try {
            XmlBeansUtil.validateDD((XmlObject)xmlObject);
        }
        catch (XmlException e) {
            throw new DeploymentException("Could not validate xmlObject of type " + type, (Throwable)e);
        }
        return xmlObject;
    }

    protected static java.lang.String getStringValue(String string) {
        if (string == null) {
            return null;
        }
        java.lang.String s = string.getStringValue();
        return s == null ? null : s.trim();
    }

    protected static java.lang.String getUntrimmedStringValue(String string) {
        if (string == null) {
            return null;
        }
        return string.getStringValue();
    }

    protected static java.lang.String getStringValue(XsdStringType string) {
        if (string == null) {
            return null;
        }
        java.lang.String s = string.getStringValue();
        return s == null ? null : s.trim();
    }

    protected static java.lang.String getUntrimmedStringValue(XsdStringType string) {
        if (string == null) {
            return null;
        }
        return string.getStringValue();
    }

    public static AbstractNameQuery buildAbstractNameQuery(GerPatternType pattern, java.lang.String type, java.lang.String moduleType, Set interfaceTypes) {
        return ENCConfigBuilder.buildAbstractNameQueryFromPattern(pattern, null, type, moduleType, interfaceTypes);
    }

    public static AbstractNameQuery buildAbstractNameQuery(Artifact configId, java.lang.String module, java.lang.String name, java.lang.String type, java.lang.String moduleType) {
        return ENCConfigBuilder.buildAbstractNameQuery(configId, module, name, type, moduleType);
    }

    public static Class assureInterface(java.lang.String interfaceName, java.lang.String superInterfaceName, java.lang.String interfaceType, ClassLoader cl) throws DeploymentException {
        Class<?> superInterface;
        Class<?> clazz;
        if (interfaceName == null || interfaceName.equals("")) {
            throw new DeploymentException("interface name cannot be blank");
        }
        try {
            clazz = cl.loadClass(interfaceName);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException(interfaceType + " interface class not found: " + interfaceName, (Throwable)e);
        }
        if (!clazz.isInterface()) {
            throw new DeploymentException(interfaceType + " interface is not an interface: " + interfaceName);
        }
        try {
            superInterface = cl.loadClass(superInterfaceName);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Class " + superInterfaceName + " could not be loaded", (Throwable)e);
        }
        if (!superInterface.isAssignableFrom(clazz)) {
            throw new DeploymentException(interfaceType + " interface does not extend " + superInterfaceName + ": " + interfaceName);
        }
        return clazz;
    }

    protected void addInjections(java.lang.String jndiName, InjectionTargetType[] injectionTargetArray, Map sharedContext) {
        Holder holder = (Holder)NamingBuilder.INJECTION_KEY.get(sharedContext);
        for (InjectionTargetType injectionTarget : injectionTargetArray) {
            java.lang.String targetName = injectionTarget.getInjectionTargetName().getStringValue().trim();
            java.lang.String targetClassName = injectionTarget.getInjectionTargetClass().getStringValue().trim();
            holder.addInjection(targetClassName, new Injection(targetClassName, targetName, jndiName));
        }
    }

    protected static Artifact[] getConfigId(Configuration localConfiguration, Configuration earConfiguration) {
        if (localConfiguration == earConfiguration) {
            return new Artifact[]{earConfiguration.getId()};
        }
        return new Artifact[]{earConfiguration.getId(), localConfiguration.getId()};
    }

    public QName getBaseQName() {
        return BASE_NAMING_QNAME;
    }
}

