/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.deployment;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotatedApp;
import org.apache.geronimo.j2ee.deployment.annotation.ResourceAnnotationHelper;
import org.apache.geronimo.naming.deployment.AbstractNamingBuilder;
import org.apache.geronimo.naming.reference.KernelReference;
import org.apache.geronimo.xbeans.javaee.DescriptionType;
import org.apache.geronimo.xbeans.javaee.EnvEntryType;
import org.apache.geronimo.xbeans.javaee.EnvEntryTypeValuesType;
import org.apache.geronimo.xbeans.javaee.InjectionTargetType;
import org.apache.geronimo.xbeans.javaee.JndiNameType;
import org.apache.geronimo.xbeans.javaee.String;
import org.apache.geronimo.xbeans.javaee.XsdStringType;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.XmlObject;

public class EnvironmentEntryBuilder
extends AbstractNamingBuilder
implements GBeanLifecycle {
    private static final Log log = LogFactory.getLog(EnvironmentEntryBuilder.class);
    private static final Map<java.lang.String, java.lang.String> NAMESPACE_UPDATES = new HashMap<java.lang.String, java.lang.String>();
    private final QNameSet envEntryQNameSet;
    public static final GBeanInfo GBEAN_INFO;

    public EnvironmentEntryBuilder(java.lang.String[] eeNamespaces) {
        this.envEntryQNameSet = EnvironmentEntryBuilder.buildQNameSet(eeNamespaces, "env-entry");
    }

    public void doStart() throws Exception {
        XmlBeansUtil.registerNamespaceUpdates(NAMESPACE_UPDATES);
    }

    public void doStop() {
        XmlBeansUtil.unregisterNamespaceUpdates(NAMESPACE_UPDATES);
    }

    public void doFail() {
        this.doStop();
    }

    public void buildNaming(XmlObject specDD, XmlObject plan, Module module, Map componentContext) throws DeploymentException {
        if (module != null && module.getClassFinder() != null) {
            try {
                ResourceAnnotationHelper.processAnnotations((AnnotatedApp)module.getAnnotatedApp(), (ClassFinder)module.getClassFinder(), (ResourceAnnotationHelper.ResourceProcessor)EnvEntryRefProcessor.INSTANCE);
            }
            catch (Exception e) {
                log.warn((Object)("Unable to process @Resource annotations for module" + module.getName()), (Throwable)e);
            }
        }
        List<EnvEntryType> envEntriesUntyped = EnvironmentEntryBuilder.convert(specDD.selectChildren(this.envEntryQNameSet), JEE_CONVERTER, EnvEntryType.class, EnvEntryType.type);
        for (EnvEntryType envEntry : envEntriesUntyped) {
            java.lang.String name = EnvironmentEntryBuilder.getStringValue((String)envEntry.getEnvEntryName());
            java.lang.String type = EnvironmentEntryBuilder.getStringValue((String)envEntry.getEnvEntryType());
            java.lang.String text = EnvironmentEntryBuilder.getStringValue(envEntry.getEnvEntryValue());
            try {
                Object value;
                if (text == null) {
                    value = "org.apache.geronimo.kernel.Kernel".equals(type) ? new KernelReference() : null;
                } else if ("java.lang.String".equals(type)) {
                    value = text;
                } else if ("java.lang.Character".equals(type)) {
                    value = Character.valueOf(text.charAt(0));
                } else if ("java.lang.Boolean".equals(type)) {
                    value = Boolean.valueOf(text);
                } else if ("java.lang.Byte".equals(type)) {
                    value = Byte.valueOf(text);
                } else if ("java.lang.Short".equals(type)) {
                    value = Short.valueOf(text);
                } else if ("java.lang.Integer".equals(type)) {
                    value = Integer.valueOf(text);
                } else if ("java.lang.Long".equals(type)) {
                    value = Long.valueOf(text);
                } else if ("java.lang.Float".equals(type)) {
                    value = Float.valueOf(text);
                } else if ("java.lang.Double".equals(type)) {
                    value = Double.valueOf(text);
                } else {
                    throw new DeploymentException("unrecognized type: " + type);
                }
                if (value == null) continue;
                this.addInjections(name, envEntry.getInjectionTargetArray(), componentContext);
                this.getJndiContextMap(componentContext).put("env/" + name, value);
            }
            catch (NumberFormatException e) {
                throw new DeploymentException("Invalid env-entry value for name: " + name, (Throwable)e);
            }
        }
    }

    public QNameSet getSpecQNameSet() {
        return this.envEntryQNameSet;
    }

    public QNameSet getPlanQNameSet() {
        return QNameSet.EMPTY;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/naming", "http://geronimo.apache.org/xml/ns/naming-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/naming-1.1", "http://geronimo.apache.org/xml/ns/naming-1.2");
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(EnvironmentEntryBuilder.class, (java.lang.String)"ModuleBuilder");
        infoBuilder.addAttribute("eeNamespaces", java.lang.String[].class, true, true);
        infoBuilder.setConstructor(new java.lang.String[]{"eeNamespaces"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }

    public static class EnvEntryRefProcessor
    extends ResourceAnnotationHelper.ResourceProcessor {
        public static final EnvEntryRefProcessor INSTANCE = new EnvEntryRefProcessor();

        private EnvEntryRefProcessor() {
        }

        public boolean processResource(AnnotatedApp annotatedApp, Resource annotation, Class cls, Method method, Field field) {
            java.lang.String resourceName = EnvEntryRefProcessor.getResourceName((Resource)annotation, (Method)method, (Field)field);
            java.lang.String resourceType = EnvEntryRefProcessor.getResourceType((Resource)annotation, (Method)method, (Field)field);
            if (resourceType.equals("java.lang.String") || resourceType.equals("java.lang.Character") || resourceType.equals("java.lang.Integer") || resourceType.equals("java.lang.Boolean") || resourceType.equals("java.lang.Double") || resourceType.equals("java.lang.Byte") || resourceType.equals("java.lang.Short") || resourceType.equals("java.lang.Long") || resourceType.equals("java.lang.Float")) {
                EnvEntryType[] envEntries;
                log.debug((Object)"addResource(): <env-entry> found");
                boolean exists = false;
                for (EnvEntryType envEntry : envEntries = annotatedApp.getEnvEntryArray()) {
                    InjectionTargetType[] targets;
                    if (!AbstractNamingBuilder.getStringValue((String)envEntry.getEnvEntryName()).equals(resourceName)) continue;
                    exists = true;
                    if (method == null && field == null || EnvEntryRefProcessor.hasTarget((Method)method, (Field)field, (InjectionTargetType[])(targets = envEntry.getInjectionTargetArray()))) break;
                    EnvEntryRefProcessor.configureInjectionTarget((InjectionTargetType)envEntry.addNewInjectionTarget(), (Method)method, (Field)field);
                    break;
                }
                if (!exists) {
                    try {
                        java.lang.String descriptionAnnotation;
                        java.lang.String mappdedNameAnnotation;
                        log.debug((Object)("addResource(): Does not exist in DD: " + resourceName));
                        EnvEntryType envEntry = annotatedApp.addNewEnvEntry();
                        JndiNameType envEntryName = envEntry.addNewEnvEntryName();
                        envEntryName.setStringValue(resourceName);
                        if (!resourceType.equals("")) {
                            EnvEntryTypeValuesType envEntryType = envEntry.addNewEnvEntryType();
                            envEntryType.setStringValue(resourceType);
                        }
                        if (method != null || field != null) {
                            InjectionTargetType injectionTarget = envEntry.addNewInjectionTarget();
                            EnvEntryRefProcessor.configureInjectionTarget((InjectionTargetType)injectionTarget, (Method)method, (Field)field);
                        }
                        if (!(mappdedNameAnnotation = annotation.mappedName()).equals("")) {
                            XsdStringType mappedName = envEntry.addNewMappedName();
                            mappedName.setStringValue(mappdedNameAnnotation);
                            envEntry.setMappedName(mappedName);
                        }
                        if (!(descriptionAnnotation = annotation.description()).equals("")) {
                            DescriptionType description = envEntry.addNewDescription();
                            description.setStringValue(descriptionAnnotation);
                        }
                    }
                    catch (Exception anyException) {
                        log.debug((Object)"ResourceAnnotationHelper: Exception caught while processing <env-entry>");
                    }
                }
            }
            return false;
        }
    }
}

