/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.deployment;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.ImportType;
import org.apache.geronimo.naming.deployment.ENCConfigBuilder;
import org.apache.geronimo.naming.reference.EntityManagerFactoryReference;
import org.apache.geronimo.schema.NamespaceElementConverter;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.xbeans.geronimo.naming.GerEntityManagerFactoryRefDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerEntityManagerFactoryRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerPatternType;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.XmlObject;

public class EntityManagerFactoryRefBuilder
implements NamingBuilder {
    private static final QName ENTITY_MANAGER_FACTORY_REF_QNAME = GerEntityManagerFactoryRefDocument.type.getDocumentElementName();
    private static final QNameSet ENTITY_MANAGER_FACTORY_REF_QNAME_SET = QNameSet.singleton((QName)ENTITY_MANAGER_FACTORY_REF_QNAME);
    private final Environment defaultEnvironment = new Environment();
    public static final GBeanInfo GBEAN_INFO;

    public EntityManagerFactoryRefBuilder() {
        this.defaultEnvironment.addDependency(new Dependency(new Artifact("org.apache.geronimo.modules", "geronimo-persistence-jpa10", (String)null, "jar"), ImportType.CLASSES));
    }

    public void buildEnvironment(XmlObject specDD, XmlObject plan, Environment environment) {
        if (this.getEntityManagerFactoryRefs(plan).length > 0) {
            EnvironmentBuilder.mergeEnvironments((Environment)environment, (Environment)this.defaultEnvironment);
        }
    }

    public void initContext(XmlObject specDD, XmlObject plan, Configuration localConfiguration, Configuration remoteConfiguration, Module module) throws DeploymentException {
    }

    public void buildNaming(XmlObject specDD, XmlObject plan, Configuration localConfiguration, Configuration remoteConfiguration, Module module, Map componentContext) throws DeploymentException {
        XmlObject[] EntityManagerFactoryRefsUntyped = this.getEntityManagerFactoryRefs(plan);
        for (int i = 0; i < EntityManagerFactoryRefsUntyped.length; ++i) {
            AbstractNameQuery persistenceUnitNameQuery;
            XmlObject EntityManagerFactoryRefUntyped = EntityManagerFactoryRefsUntyped[i];
            GerEntityManagerFactoryRefType EntityManagerFactoryRef = (GerEntityManagerFactoryRefType)EntityManagerFactoryRefUntyped.copy().changeType(GerEntityManagerFactoryRefType.type);
            if (EntityManagerFactoryRef == null) {
                throw new DeploymentException("Could not read EntityManagerFactoryRef " + EntityManagerFactoryRefUntyped + " as the correct xml type");
            }
            String EntityManagerFactoryRefName = EntityManagerFactoryRef.getEntityManagerFactoryRefName();
            Set<String> interfaceTypes = Collections.singleton("org.apache.geronimo.persistence.PersistenceUnitGBean");
            if (EntityManagerFactoryRef.isSetPersistenceUnitName()) {
                String persistenceUnitName = EntityManagerFactoryRef.getPersistenceUnitName();
                persistenceUnitNameQuery = new AbstractNameQuery(null, Collections.singletonMap("name", persistenceUnitName), interfaceTypes);
            } else {
                GerPatternType gbeanLocator = EntityManagerFactoryRef.getPattern();
                persistenceUnitNameQuery = ENCConfigBuilder.buildAbstractNameQuery(gbeanLocator, null, null, interfaceTypes);
            }
            try {
                localConfiguration.findGBeanData(persistenceUnitNameQuery);
            }
            catch (GBeanNotFoundException e) {
                throw new DeploymentException("Could not resolve reference at deploy time for query " + persistenceUnitNameQuery, (Throwable)e);
            }
            EntityManagerFactoryReference reference = new EntityManagerFactoryReference(localConfiguration.getId(), persistenceUnitNameQuery);
            ((Map)componentContext.get("JNDI_COMPONENT_CONTEXT")).put("env/" + EntityManagerFactoryRefName, reference);
        }
    }

    public QNameSet getSpecQNameSet() {
        SchemaConversionUtils.registerNamespaceConversions(Collections.singletonMap(ENTITY_MANAGER_FACTORY_REF_QNAME.getLocalPart(), new NamespaceElementConverter(ENTITY_MANAGER_FACTORY_REF_QNAME.getNamespaceURI())));
        return QNameSet.EMPTY;
    }

    public QNameSet getPlanQNameSet() {
        return ENTITY_MANAGER_FACTORY_REF_QNAME_SET;
    }

    private XmlObject[] getEntityManagerFactoryRefs(XmlObject plan) {
        return plan == null ? NO_REFS : plan.selectChildren(ENTITY_MANAGER_FACTORY_REF_QNAME_SET);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((Class)EntityManagerFactoryRefBuilder.class, (String)"ModuleBuilder");
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

