/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.myfaces;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.myfaces.spi.ServiceProviderFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeronimoServiceProviderFinder
extends ServiceProviderFinder {
    private static final Logger logger = LoggerFactory.getLogger(GeronimoServiceProviderFinder.class);
    private Map<String, List<String>> spiProvidersMap = new HashMap<String, List<String>>();
    private static final String META_INF_SERVICE_PREFIX = "META-INF/services";
    private ClassLoader classLoader;

    public GeronimoServiceProviderFinder(Map<String, List<String>> spiProvidersMap, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.spiProvidersMap = spiProvidersMap;
    }

    public List<String> getServiceProviderList(String spiClass) {
        List<String> providers = this.spiProvidersMap.get(spiClass);
        return providers == null ? this.searchByClassLoader(spiClass) : providers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> searchByClassLoader(String spiClass) {
        Enumeration<URL> en;
        try {
            en = this.classLoader.getResources("META-INF/services/" + spiClass);
        }
        catch (IOException e) {
            logger.warn("Fail to scan META-INF/services/" + spiClass, (Throwable)e);
            return Collections.emptyList();
        }
        ArrayList<String> spiProviderClasses = new ArrayList<String>();
        while (en.hasMoreElements()) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(en.nextElement().openStream(), "UTF-8"));
                String line = null;
                while ((line = bufferedReader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                    spiProviderClasses.add(line);
                }
            }
            catch (IOException e) {
                try {
                    logger.warn("Fail to scan META-INF/services/" + spiClass, (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.close(bufferedReader);
                    throw throwable;
                }
                IOUtils.close((Closeable)bufferedReader);
                continue;
            }
            IOUtils.close((Closeable)bufferedReader);
        }
        return spiProviderClasses;
    }
}

