/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.myfaces.deployment;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.config.element.FacesConfig;
import org.apache.myfaces.config.element.Factory;
import org.apache.myfaces.spi.FacesConfigurationProvider;
import org.apache.myfaces.spi.ServiceProviderFinderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeronimoFacesConfigurationProvider
extends FacesConfigurationProvider {
    private static final Logger logger = LoggerFactory.getLogger(GeronimoFacesConfigurationProvider.class);
    private static final Set<String> FACTORY_NAMES = new HashSet<String>();
    private FacesConfig annotationsFacesConfig;
    private List<FacesConfig> classloaderFacesConfigs;
    private List<FacesConfig> contextSpecifiedFacesConfigs;
    private FacesConfig webAppFacesConfig;
    private FacesConfig standardFacesConfig;

    public GeronimoFacesConfigurationProvider(FacesConfig standardFacesConfig, FacesConfig webAppFacesConfig, FacesConfig annotationsFacesConfig, List<FacesConfig> classloaderFacesConfigs, List<FacesConfig> contextSpecifiedFacesConfigs) {
        FACTORY_NAMES.add("javax.faces.application.ApplicationFactory");
        FACTORY_NAMES.add("javax.faces.context.ExceptionHandlerFactory");
        FACTORY_NAMES.add("javax.faces.context.ExternalContextFactory");
        FACTORY_NAMES.add("javax.faces.context.FacesContextFactory");
        FACTORY_NAMES.add("javax.faces.lifecycle.LifecycleFactory");
        FACTORY_NAMES.add("javax.faces.render.RenderKitFactory");
        FACTORY_NAMES.add("javax.faces.view.facelets.TagHandlerDelegateFactory");
        FACTORY_NAMES.add("javax.faces.context.PartialViewContextFactory");
        FACTORY_NAMES.add("javax.faces.component.visit.VisitContextFactory");
        FACTORY_NAMES.add("javax.faces.view.ViewDeclarationLanguageFactory");
        this.annotationsFacesConfig = annotationsFacesConfig;
        this.classloaderFacesConfigs = classloaderFacesConfigs;
        this.contextSpecifiedFacesConfigs = contextSpecifiedFacesConfigs;
        this.webAppFacesConfig = webAppFacesConfig;
        this.standardFacesConfig = standardFacesConfig;
    }

    public FacesConfig getAnnotationsFacesConfig(ExternalContext ectx, boolean metadataComplete) {
        return this.annotationsFacesConfig;
    }

    public List<FacesConfig> getClassloaderFacesConfig(ExternalContext externalContext) {
        return this.classloaderFacesConfigs;
    }

    public List<FacesConfig> getContextSpecifiedFacesConfig(ExternalContext externalContext) {
        return this.contextSpecifiedFacesConfigs;
    }

    public FacesConfig getStandardFacesConfig(ExternalContext externalContext) {
        return this.standardFacesConfig;
    }

    public FacesConfig getWebAppFacesConfig(ExternalContext externalContext) {
        return this.webAppFacesConfig;
    }

    public FacesConfig getMetaInfServicesFacesConfig(ExternalContext externalContext) {
        try {
            org.apache.myfaces.config.impl.digester.elements.FacesConfig facesConfig = new org.apache.myfaces.config.impl.digester.elements.FacesConfig();
            org.apache.myfaces.config.impl.digester.elements.Factory factory = new org.apache.myfaces.config.impl.digester.elements.Factory();
            facesConfig.addFactory((Factory)factory);
            for (String factoryName : FACTORY_NAMES) {
                List classList = ServiceProviderFinderFactory.getServiceProviderFinder((ExternalContext)externalContext).getServiceProviderList(factoryName);
                for (String className : classList) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Found " + factoryName + " factory implementation: " + className);
                    }
                    if (factoryName.equals("javax.faces.application.ApplicationFactory")) {
                        factory.addApplicationFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.context.ExternalContextFactory")) {
                        factory.addExternalContextFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.context.FacesContextFactory")) {
                        factory.addFacesContextFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.lifecycle.LifecycleFactory")) {
                        factory.addLifecycleFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.render.RenderKitFactory")) {
                        factory.addRenderkitFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.context.PartialViewContextFactory")) {
                        factory.addPartialViewContextFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.component.visit.VisitContextFactory")) {
                        factory.addVisitContextFactory(className);
                        continue;
                    }
                    throw new IllegalStateException("Unexpected factory name " + factoryName);
                }
            }
            return facesConfig;
        }
        catch (Throwable e) {
            throw new FacesException(e);
        }
    }
}

