/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class ClassLoaderRegistry {
    private static final List<WeakReference> list = new ArrayList<WeakReference>();

    public static synchronized List getList() {
        ArrayList<ClassLoader> ret = new ArrayList<ClassLoader>();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != null) {
                ret.add((ClassLoader)list.get(i).get());
                continue;
            }
            list.remove(i);
        }
        return ret;
    }

    public static synchronized boolean add(ClassLoader cloader) {
        if (ClassLoaderRegistry.contains(cloader)) {
            return false;
        }
        return list.add(new WeakReference<ClassLoader>(cloader));
    }

    public static synchronized boolean contains(ClassLoader cloader) {
        for (int i = 0; i < list.size(); ++i) {
            WeakReference wk = list.get(i);
            if (wk.get() == null) {
                list.remove(i);
                continue;
            }
            if (!wk.get().equals(cloader)) continue;
            return true;
        }
        return false;
    }

    public static synchronized boolean remove(ClassLoader cloader) {
        boolean result = false;
        for (int i = 0; i < list.size(); ++i) {
            WeakReference wk = list.get(i);
            if (wk.get() == null) {
                list.remove(i);
                continue;
            }
            if (!wk.get().equals(cloader)) continue;
            list.remove(i);
            result = true;
        }
        return result;
    }
}

