/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.repository;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.kernel.repository.ImportType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Environment
implements Serializable {
    private static final long serialVersionUID = 7075760873629376317L;
    private Artifact configId;
    private final LinkedHashSet dependencies = new LinkedHashSet();
    private final Set hiddenClasses = new HashSet();
    private final Set nonOverrideableClasses = new HashSet();
    private boolean inverseClassLoading;
    private boolean suppressDefaultEnvironment;

    public Environment() {
    }

    public Environment(Artifact configId) {
        this.configId = configId;
    }

    public Environment(Environment environment) {
        this.configId = environment.getConfigId();
        this.dependencies.addAll(environment.dependencies);
        this.hiddenClasses.addAll(environment.getHiddenClasses());
        this.nonOverrideableClasses.addAll(environment.getNonOverrideableClasses());
        this.inverseClassLoading = environment.isInverseClassLoading();
        this.suppressDefaultEnvironment = environment.isSuppressDefaultEnvironment();
    }

    public Artifact getConfigId() {
        return this.configId;
    }

    public void setConfigId(Artifact configId) {
        this.configId = configId;
    }

    public List<Dependency> getDependencies() {
        return Collections.unmodifiableList(new ArrayList(this.dependencies));
    }

    public void addDependency(Artifact artifact, ImportType importType) {
        this.dependencies.add(new Dependency(artifact, importType));
    }

    public void addDependency(Dependency dependency) {
        this.dependencies.add(dependency);
    }

    public void addDependencies(Collection dependencies) {
        for (Dependency dependency : dependencies) {
            this.addDependency(dependency);
        }
    }

    public void setDependencies(Collection dependencies) {
        this.dependencies.clear();
        this.addDependencies(dependencies);
    }

    public Set getHiddenClasses() {
        return this.hiddenClasses;
    }

    public void addHiddenClasses(Collection hiddenClasses) {
        this.hiddenClasses.addAll(hiddenClasses);
    }

    public void setHiddenClasses(Collection hiddenClasses) {
        this.hiddenClasses.clear();
        this.addHiddenClasses(hiddenClasses);
    }

    public Set getNonOverrideableClasses() {
        return this.nonOverrideableClasses;
    }

    public void addNonOverrideableClasses(Collection nonOverrideableClasses) {
        this.nonOverrideableClasses.addAll(nonOverrideableClasses);
    }

    public void setNonOverrideableClasses(Collection nonOverrideableClasses) {
        this.nonOverrideableClasses.clear();
        this.addNonOverrideableClasses(nonOverrideableClasses);
    }

    public boolean isInverseClassLoading() {
        return this.inverseClassLoading;
    }

    public void setInverseClassLoading(boolean inverseClassLoading) {
        this.inverseClassLoading = inverseClassLoading;
    }

    public boolean isSuppressDefaultEnvironment() {
        return this.suppressDefaultEnvironment;
    }

    public void setSuppressDefaultEnvironment(boolean suppressDefaultEnvironment) {
        this.suppressDefaultEnvironment = suppressDefaultEnvironment;
    }
}

