/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.runtime;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.gbean.runtime.AbstractGBeanReference;
import org.apache.geronimo.gbean.runtime.GBeanInstance;
import org.apache.geronimo.gbean.runtime.ProxyCollection;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.lifecycle.LifecycleAdapter;
import org.apache.geronimo.kernel.lifecycle.LifecycleListener;

public class GBeanCollectionReference
extends AbstractGBeanReference {
    private boolean isOnline = false;
    private Set patterns = Collections.EMPTY_SET;
    private final Set targets = new HashSet();
    private final LifecycleListener listener = this.createLifecycleListener();

    public GBeanCollectionReference(GBeanInstance gbeanInstance, GReferenceInfo referenceInfo, Kernel kernel, ReferencePatterns referencePatterns) throws InvalidConfigurationException {
        super(gbeanInstance, referenceInfo, kernel, GBeanCollectionReference.hasTargets(referencePatterns));
        if (referencePatterns != null) {
            this.setReferencePatterns(referencePatterns);
        }
    }

    private static boolean hasTargets(ReferencePatterns referencePatterns) {
        if (referencePatterns == null) {
            return false;
        }
        if (referencePatterns.isResolved()) {
            return true;
        }
        return !referencePatterns.getPatterns().isEmpty();
    }

    public synchronized boolean start() {
        if (!this.patterns.isEmpty() && this.getProxy() == null) {
            this.setProxy(new ProxyCollection(this.getName(), this.getReferenceType(), this.getTargets(), this.getKernel()));
        }
        return true;
    }

    public synchronized void stop() {
        ProxyCollection proxy = (ProxyCollection)this.getProxy();
        if (proxy != null) {
            proxy.destroy();
            this.setProxy(null);
        }
    }

    protected synchronized void targetAdded(AbstractName target) {
        ProxyCollection proxy = (ProxyCollection)this.getProxy();
        if (proxy != null) {
            proxy.addTarget(target);
        }
    }

    protected synchronized void targetRemoved(AbstractName target) {
        ProxyCollection proxy = (ProxyCollection)this.getProxy();
        if (proxy != null) {
            proxy.removeTarget(target);
        }
    }

    protected LifecycleListener createLifecycleListener() {
        return new LifecycleAdapter(){

            public void running(AbstractName abstractName) {
                GBeanCollectionReference.this.addTarget(abstractName);
            }

            public void stopping(AbstractName abstractName) {
                GBeanCollectionReference.this.removeTarget(abstractName);
            }

            public void stopped(AbstractName abstractName) {
                GBeanCollectionReference.this.removeTarget(abstractName);
            }

            public void failed(AbstractName abstractName) {
                GBeanCollectionReference.this.removeTarget(abstractName);
            }

            public void unloaded(AbstractName abstractName) {
                GBeanCollectionReference.this.removeTarget(abstractName);
            }
        };
    }

    public final synchronized Set getPatterns() {
        return this.patterns;
    }

    public final synchronized void setReferencePatterns(ReferencePatterns referencePatterns) {
        if (this.isOnline) {
            throw new IllegalStateException("Pattern set can not be modified while online");
        }
        this.patterns = referencePatterns.isResolved() ? Collections.unmodifiableSet(Collections.singleton(new AbstractNameQuery(referencePatterns.getAbstractName()))) : Collections.unmodifiableSet(referencePatterns.getPatterns());
    }

    public final synchronized void online() {
        Set gbeans = this.getKernel().listGBeans(this.patterns);
        for (AbstractName target : gbeans) {
            if (this.targets.contains(target) || !this.isRunning(this.getKernel(), target)) continue;
            this.targets.add(target);
        }
        this.getKernel().getLifecycleMonitor().addLifecycleListener(this.listener, this.patterns);
        this.isOnline = true;
    }

    public final synchronized void offline() {
        this.stop();
        this.getKernel().getLifecycleMonitor().removeLifecycleListener(this.listener);
        this.targets.clear();
        this.isOnline = false;
    }

    protected final Set getTargets() {
        return this.targets;
    }

    protected final void addTarget(AbstractName abstractName) {
        if (!this.targets.contains(abstractName)) {
            this.targets.add(abstractName);
            this.targetAdded(abstractName);
        }
    }

    protected final void removeTarget(AbstractName abstractName) {
        boolean wasTarget = this.targets.remove(abstractName);
        if (wasTarget) {
            this.targetRemoved(abstractName);
        }
    }
}

