/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.ReferencePatterns;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GBeanData
implements Externalizable {
    private static final long serialVersionUID = -1012491431781444074L;
    private Externalizable[] backwardExternalizables = new Externalizable[]{new V0Externalizable(), new V1Externalizable()};
    private GBeanInfo gbeanInfo;
    private final Map<String, Object> attributes;
    private final Map<String, ReferencePatterns> references;
    private final Set<ReferencePatterns> dependencies;
    private AbstractName abstractName;
    private int priority;

    public GBeanData() {
        this.attributes = new HashMap<String, Object>();
        this.references = new HashMap<String, ReferencePatterns>();
        this.dependencies = new HashSet<ReferencePatterns>();
    }

    public GBeanData(GBeanInfo gbeanInfo) {
        this();
        this.setGBeanInfo(gbeanInfo);
    }

    public GBeanData(AbstractName abstractName, GBeanInfo gbeanInfo) {
        this();
        this.abstractName = abstractName;
        this.setGBeanInfo(gbeanInfo);
    }

    public GBeanData(GBeanData gbeanData) {
        this.setGBeanInfo(gbeanData.gbeanInfo);
        this.attributes = new HashMap<String, Object>(gbeanData.attributes);
        this.references = new HashMap<String, ReferencePatterns>(gbeanData.references);
        this.dependencies = new HashSet<ReferencePatterns>(gbeanData.dependencies);
        this.abstractName = gbeanData.abstractName;
    }

    public AbstractName getAbstractName() {
        return this.abstractName;
    }

    public void setAbstractName(AbstractName abstractName) {
        this.abstractName = abstractName;
    }

    public GBeanInfo getGBeanInfo() {
        return this.gbeanInfo;
    }

    public void clearAttribute(String name) {
        this.attributes.remove(name);
    }

    public void clearReference(String name) {
        this.references.remove(name);
    }

    public void setGBeanInfo(GBeanInfo gbeanInfo) {
        this.gbeanInfo = gbeanInfo;
        this.priority = gbeanInfo == null ? 5 : gbeanInfo.getPriority();
    }

    public Map<String, Object> getAttributes() {
        return new HashMap<String, Object>(this.attributes);
    }

    public Set<String> getAttributeNames() {
        return new HashSet<String>(this.attributes.keySet());
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public Map<String, ReferencePatterns> getReferences() {
        return new HashMap<String, ReferencePatterns>(this.references);
    }

    public Set<String> getReferencesNames() {
        return new HashSet<String>(this.references.keySet());
    }

    public ReferencePatterns getReferencePatterns(String name) {
        return this.references.get(name);
    }

    public void setReferencePattern(String name, AbstractNameQuery pattern) {
        this.setReferencePatterns(name, Collections.singleton(pattern));
    }

    public void setReferencePattern(String name, AbstractName abstractName) {
        this.setReferencePatterns(name, new ReferencePatterns(abstractName));
    }

    public void setReferencePatterns(String name, Set patterns) {
        this.setReferencePatterns(name, new ReferencePatterns(patterns));
    }

    public void setReferencePatterns(String name, ReferencePatterns patterns) {
        this.references.put(name, patterns);
    }

    public Set<ReferencePatterns> getDependencies() {
        return new HashSet<ReferencePatterns>(this.dependencies);
    }

    public void setDependencies(Set<ReferencePatterns> dependencies) {
        this.dependencies.clear();
        this.addDependencies(dependencies);
    }

    public void addDependencies(Set<? extends Object> dependencies) {
        for (Object object : dependencies) {
            if (object instanceof AbstractName) {
                AbstractName name = (AbstractName)object;
                this.addDependency(name);
                continue;
            }
            if (object instanceof AbstractNameQuery) {
                AbstractNameQuery nameQuery = (AbstractNameQuery)object;
                this.addDependency(nameQuery);
                continue;
            }
            if (object instanceof ReferencePatterns) {
                ReferencePatterns referencePatterns = (ReferencePatterns)object;
                this.addDependency(referencePatterns);
                continue;
            }
            throw new IllegalArgumentException("Unknown dependency type: " + object);
        }
    }

    public void addDependency(ReferencePatterns dependency) {
        this.dependencies.add(dependency);
    }

    public void addDependency(AbstractNameQuery refInfo) {
        this.dependencies.add(new ReferencePatterns(refInfo));
    }

    public void addDependency(AbstractName dependency) {
        this.dependencies.add(new ReferencePatterns(dependency));
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        Object value;
        String name;
        out.writeObject(this.backwardExternalizables.length - 1);
        out.writeObject(this.gbeanInfo);
        out.writeObject(this.abstractName);
        out.writeInt(this.priority);
        out.writeInt(this.attributes.size());
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            name = entry.getKey();
            value = entry.getValue();
            try {
                out.writeObject(name);
                out.writeObject(value);
            }
            catch (IOException e) {
                throw (IOException)new IOException("Unable to write attribute: " + name + " in gbean: " + this.abstractName).initCause(e);
            }
            catch (NoClassDefFoundError e) {
                throw (IOException)new IOException("Unable to write attribute: " + name + " in gbean: " + this.abstractName).initCause(e);
            }
        }
        out.writeInt(this.references.size());
        for (Map.Entry<String, Object> entry : this.references.entrySet()) {
            name = entry.getKey();
            value = (ReferencePatterns)entry.getValue();
            try {
                out.writeObject(name);
                out.writeObject(value);
            }
            catch (IOException e) {
                throw (IOException)new IOException("Unable to write reference pattern: " + name + " in gbean: " + this.abstractName).initCause(e);
            }
        }
        out.writeInt(this.dependencies.size());
        for (ReferencePatterns referencePatterns : this.dependencies) {
            try {
                out.writeObject(referencePatterns);
            }
            catch (IOException e) {
                throw (IOException)new IOException("Unable to write dependency pattern in gbean: " + this.abstractName).initCause(e);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Object opaque = in.readObject();
        if (opaque instanceof Integer) {
            this.backwardExternalizables[(Integer)opaque].readExternal(in);
        } else {
            this.gbeanInfo = (GBeanInfo)opaque;
            this.backwardExternalizables[0].readExternal(in);
        }
    }

    private class V1Externalizable
    extends V0Externalizable {
        private V1Externalizable() {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }

        protected void readGBeanInfo(ObjectInput in) throws IOException, ClassNotFoundException {
            GBeanData.this.gbeanInfo = (GBeanInfo)in.readObject();
        }

        protected void readPriority(ObjectInput in) throws IOException, ClassNotFoundException {
            GBeanData.this.priority = in.readInt();
        }
    }

    private class V0Externalizable
    implements Externalizable {
        private V0Externalizable() {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }

        public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.readGBeanInfo(in);
            try {
                GBeanData.this.abstractName = (AbstractName)in.readObject();
            }
            catch (IOException e) {
                throw (IOException)new IOException("Unable to deserialize AbstractName for GBeanData of type " + GBeanData.this.gbeanInfo.getClassName()).initCause(e);
            }
            this.readPriority(in);
            try {
                int attributeCount = in.readInt();
                for (int i = 0; i < attributeCount; ++i) {
                    Object attributeValue;
                    String attributeName = (String)in.readObject();
                    try {
                        attributeValue = in.readObject();
                    }
                    catch (ClassNotFoundException e) {
                        throw new ClassNotFoundException("Unable to find class used in GBeanData " + GBeanData.this.abstractName + ", attribute: " + attributeName, e);
                    }
                    catch (IOException e) {
                        throw (IOException)new IOException("Unable to deserialize GBeanData " + GBeanData.this.abstractName + ", attribute: " + attributeName).initCause(e);
                    }
                    GBeanData.this.setAttribute(attributeName, attributeValue);
                }
                int endpointCount = in.readInt();
                for (int i = 0; i < endpointCount; ++i) {
                    ReferencePatterns referencePattern;
                    String referenceName = (String)in.readObject();
                    try {
                        referencePattern = (ReferencePatterns)in.readObject();
                    }
                    catch (ClassNotFoundException e) {
                        throw new ClassNotFoundException("Unable to find class used in GBeanData " + GBeanData.this.abstractName + ", reference: " + referenceName, e);
                    }
                    catch (IOException e) {
                        throw (IOException)new IOException("Unable to deserialize GBeanData " + GBeanData.this.abstractName + ", reference: " + referenceName).initCause(e);
                    }
                    GBeanData.this.setReferencePatterns(referenceName, referencePattern);
                }
                int dependencyCount = in.readInt();
                for (int i = 0; i < dependencyCount; ++i) {
                    ReferencePatterns depdendencyPattern = (ReferencePatterns)in.readObject();
                    GBeanData.this.dependencies.add(depdendencyPattern);
                }
            }
            catch (IOException e) {
                throw (IOException)new IOException("Unable to deserialize GBeanData " + GBeanData.this.abstractName).initCause(e);
            }
            catch (ClassNotFoundException e) {
                throw new ClassNotFoundException("Unable to find class used in GBeanData " + GBeanData.this.abstractName, e);
            }
        }

        protected void readGBeanInfo(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        protected void readPriority(ObjectInput in) throws IOException, ClassNotFoundException {
            GBeanData.this.priority = 5;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PriorityComparator
    implements Comparator<GBeanData> {
        @Override
        public int compare(GBeanData o1, GBeanData o2) {
            return o1.priority - o2.priority;
        }
    }
}

