/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactManager;

public class DefaultArtifactManager
implements ArtifactManager {
    private final Map artifactsByLoader = new HashMap();
    private final Map artifactsByArtifact = new HashMap();
    public static final GBeanInfo GBEAN_INFO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadArtifacts(Artifact loader, Set artifacts) {
        if (!loader.isResolved()) {
            throw new IllegalArgumentException("loader is not a resolved artifact: " + loader);
        }
        Iterator iterator = artifacts.iterator();
        while (iterator.hasNext()) {
            Artifact artifact = (Artifact)iterator.next();
            if (artifact.isResolved()) continue;
            throw new IllegalArgumentException("artifact is not a resolved artifact: " + artifact);
        }
        DefaultArtifactManager defaultArtifactManager = this;
        synchronized (defaultArtifactManager) {
            if (this.artifactsByLoader.containsKey(loader)) {
                throw new IllegalArgumentException("loader has already declared artifacts: " + loader);
            }
            this.artifactsByLoader.put(loader, artifacts);
            this.processArtifact(loader);
            Iterator iterator2 = artifacts.iterator();
            while (iterator2.hasNext()) {
                Artifact artifact = (Artifact)iterator2.next();
                this.processArtifact(artifact);
            }
        }
    }

    private void processArtifact(Artifact artifact) {
        ArrayList<Artifact> values = (ArrayList<Artifact>)this.artifactsByArtifact.get(artifact.getArtifactId());
        if (values == null) {
            values = new ArrayList<Artifact>();
            this.artifactsByArtifact.put(artifact.getArtifactId(), values);
        }
        values.add(artifact);
    }

    public synchronized void unloadAllArtifacts(Artifact loader) {
        this.removeArtifact(loader);
        Collection artifacts = (Collection)this.artifactsByLoader.remove(loader);
        if (artifacts == null) {
            return;
        }
        Iterator iterator = artifacts.iterator();
        while (iterator.hasNext()) {
            Artifact artifact = (Artifact)iterator.next();
            this.removeArtifact(artifact);
        }
    }

    private void removeArtifact(Artifact artifact) {
        List values = (List)this.artifactsByArtifact.get(artifact.getArtifactId());
        if (values != null) {
            values.remove(artifact);
            if (values.isEmpty()) {
                this.artifactsByArtifact.remove(artifact.getArtifactId());
            }
        }
    }

    public SortedSet getLoadedArtifacts(Artifact query) {
        List values = (List)this.artifactsByArtifact.get(query.getArtifactId());
        TreeSet<Artifact> results = new TreeSet<Artifact>();
        if (values != null) {
            for (int i = 0; i < values.size(); ++i) {
                Artifact test = (Artifact)values.get(i);
                if (!query.matches(test)) continue;
                results.add(test);
            }
        }
        return results;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(DefaultArtifactManager.class, "ArtifactManager");
        infoFactory.addInterface(ArtifactManager.class);
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

