/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.repository;

import java.io.Serializable;
import org.apache.geronimo.kernel.repository.Version;

public class Artifact
implements Comparable,
Serializable {
    private static final long serialVersionUID = -3459638899709893444L;
    public static final String DEFAULT_GROUP_ID = "default";
    private final String groupId;
    private final String artifactId;
    private final Version version;
    private final String type;
    private static int GREATER = 1;
    private static int LESS = -1;

    public Artifact(String groupId, String artifactId, String version, String type) {
        this(groupId, artifactId, version == null ? null : new Version(version), type);
    }

    public Artifact(String groupId, String artifactId, Version version, String type) {
        if (artifactId == null) {
            throw new NullPointerException("artifactId is null");
        }
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
    }

    public static Artifact create(String id) {
        String[] parts = id.split("/", -1);
        if (parts.length != 4) {
            throw new IllegalArgumentException("Invalid id: " + id);
        }
        for (int i = 0; i < parts.length; ++i) {
            if (!parts[i].equals("")) continue;
            parts[i] = null;
        }
        return new Artifact(parts[0], parts[1], parts[2], parts[3]);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public boolean isResolved() {
        return this.groupId != null && this.artifactId != null && this.version != null && this.type != null;
    }

    public int compareTo(Object object) {
        Artifact artifact = (Artifact)object;
        int i = Artifact.safeCompare((Comparable)((Object)this.groupId), (Comparable)((Object)artifact.groupId));
        if (i != 0) {
            return i;
        }
        i = Artifact.safeCompare((Comparable)((Object)this.artifactId), (Comparable)((Object)artifact.artifactId));
        if (i != 0) {
            return i;
        }
        i = Artifact.safeCompare(this.version, artifact.version);
        if (i != 0) {
            return i;
        }
        i = Artifact.safeCompare((Comparable)((Object)this.type), (Comparable)((Object)artifact.type));
        return i;
    }

    private static int safeCompare(Comparable left, Comparable right) {
        if (left == null) {
            if (right != null) {
                return LESS;
            }
            return 0;
        }
        if (right == null) {
            return GREATER;
        }
        return left.compareTo(right);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Artifact artifact = (Artifact)o;
        if (!this.artifactId.equals(artifact.artifactId)) {
            return false;
        }
        if (this.groupId != null ? !this.groupId.equals(artifact.groupId) : artifact.groupId != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(artifact.type) : artifact.type != null) {
            return false;
        }
        return !(this.version == null ? artifact.version != null : !this.version.equals(artifact.version));
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 29 * result + this.artifactId.hashCode();
        result = 29 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 29 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.groupId != null) {
            buffer.append(this.groupId);
        }
        buffer.append("/");
        buffer.append(this.artifactId);
        buffer.append("/");
        if (this.version != null) {
            buffer.append(this.version);
        }
        buffer.append("/");
        if (this.type != null) {
            buffer.append(this.type);
        }
        return buffer.toString();
    }

    public boolean matches(Artifact otherArtifact) {
        if (this.groupId != null && !this.groupId.equals(otherArtifact.groupId)) {
            return false;
        }
        if (this.artifactId != null && !this.artifactId.equals(otherArtifact.artifactId)) {
            return false;
        }
        if (this.version != null && !this.version.equals(otherArtifact.version)) {
            return false;
        }
        return this.type == null || this.type.equals(otherArtifact.type);
    }
}

