/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.mapper.Mapper;
import java.net.URI;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.xstream.AbstractNameConverter;
import org.apache.geronimo.kernel.config.xstream.AbstractNameQueryConverter;
import org.apache.geronimo.kernel.config.xstream.ConfigurationDataConverter;
import org.apache.geronimo.kernel.config.xstream.ConfigurationModuleTypeConverter;
import org.apache.geronimo.kernel.config.xstream.DomConverter;
import org.apache.geronimo.kernel.config.xstream.GBeanDataConverter;
import org.apache.geronimo.kernel.config.xstream.ImportTypeConverter;
import org.apache.geronimo.kernel.config.xstream.QNameConverter;
import org.apache.geronimo.kernel.config.xstream.URIConverter;
import org.apache.geronimo.kernel.config.xstream.VersionConverter;
import org.apache.geronimo.kernel.config.xstream.XStreamGBeanStateConverter;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.kernel.repository.ImportType;
import org.apache.geronimo.kernel.repository.Version;

public final class XStreamUtil {
    private XStreamUtil() {
    }

    public static XStream createXStream() {
        JVM jvm = new JVM();
        ReflectionProvider reflectionProvider = jvm.bestReflectionProvider();
        XStream xstream = new XStream(reflectionProvider);
        xstream.alias("abstractName", AbstractName.class);
        xstream.addImmutableType(AbstractName.class);
        xstream.registerConverter((Converter)new AbstractNameConverter());
        xstream.alias("abstractNameQuery", AbstractNameQuery.class);
        xstream.addImmutableType(AbstractNameQuery.class);
        xstream.registerConverter((Converter)new AbstractNameQueryConverter());
        xstream.alias("artifact", Artifact.class);
        xstream.addImmutableType(Artifact.class);
        xstream.alias("configurationData", ConfigurationData.class);
        xstream.registerConverter((Converter)new ConfigurationDataConverter(reflectionProvider, (Mapper)xstream.getClassMapper()));
        xstream.alias("moduleType", ConfigurationModuleType.class);
        xstream.addImmutableType(ConfigurationModuleType.class);
        xstream.registerConverter((Converter)new ConfigurationModuleTypeConverter());
        xstream.alias("dependency", Dependency.class);
        xstream.addImmutableType(Dependency.class);
        xstream.alias("gbean", GBeanData.class);
        xstream.registerConverter((Converter)new GBeanDataConverter((Mapper)xstream.getClassMapper()));
        xstream.alias("gbean-info", GBeanInfo.class);
        xstream.registerConverter((Converter)new DomConverter());
        xstream.addImmutableType(ImportType.class);
        xstream.registerConverter((Converter)new ImportTypeConverter());
        try {
            xstream.registerConverter((Converter)new QNameConverter());
        }
        catch (Exception exception) {
            // empty catch block
        }
        xstream.alias("version", Version.class);
        xstream.addImmutableType(Version.class);
        xstream.registerConverter((Converter)new VersionConverter());
        xstream.alias("uri", URI.class);
        xstream.addImmutableType(URI.class);
        xstream.registerConverter((Converter)new URIConverter());
        xstream.registerConverter((Converter)new XStreamGBeanStateConverter());
        return xstream;
    }
}

