/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config.xstream;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.net.URI;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.ReferencePatterns;

public class GBeanDataConverter
implements Converter {
    private final Mapper mapper;
    static /* synthetic */ Class class$org$apache$geronimo$gbean$GBeanInfo;
    static /* synthetic */ Class class$org$apache$geronimo$gbean$ReferencePatterns;

    public GBeanDataConverter(Mapper mapper) {
        this.mapper = mapper;
    }

    public boolean canConvert(Class clazz) {
        return GBeanData.class.isAssignableFrom(clazz);
    }

    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext marshallingContext) {
        GBeanInfo gbeanInfo;
        String sourceClass;
        GBeanData gbeanData = (GBeanData)object;
        AbstractName abstractName = gbeanData.getAbstractName();
        if (abstractName != null) {
            writer.addAttribute("name", abstractName.toString());
        }
        if ((sourceClass = (gbeanInfo = gbeanData.getGBeanInfo()).getSourceClass()) != null) {
            writer.addAttribute("sourceClass", sourceClass);
        } else {
            writer.startNode("gbean-info");
            marshallingContext.convertAnother((Object)gbeanInfo);
            writer.endNode();
        }
        Set dependencies = gbeanData.getDependencies();
        Iterator iterator = dependencies.iterator();
        while (iterator.hasNext()) {
            ReferencePatterns referencePatterns = (ReferencePatterns)iterator.next();
            writer.startNode("dependency");
            marshallingContext.convertAnother((Object)referencePatterns);
            writer.endNode();
        }
        Map attributes = gbeanData.getAttributes();
        Iterator iterator2 = attributes.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            String attributeName = (String)entry.getKey();
            Object attributeValue = entry.getValue();
            if (attributeValue == null) continue;
            writer.startNode("attribute");
            writer.addAttribute("name", attributeName);
            writer.startNode(this.mapper.serializedClass(attributeValue.getClass()));
            marshallingContext.convertAnother(attributeValue);
            writer.endNode();
            writer.endNode();
        }
        Map references = gbeanData.getReferences();
        Iterator iterator3 = references.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry entry = iterator3.next();
            String referenceName = (String)entry.getKey();
            ReferencePatterns referencePatterns = (ReferencePatterns)entry.getValue();
            writer.startNode("reference");
            writer.addAttribute("name", referenceName);
            marshallingContext.convertAnother((Object)referencePatterns);
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext unmarshallingContext) {
        Map.Entry entry;
        Object attributeValue;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        String gbeanName = reader.getAttribute("name");
        AbstractName abstractName = null;
        if (gbeanName != null) {
            abstractName = new AbstractName(URI.create(gbeanName));
        }
        GBeanInfo gbeanInfo = null;
        String sourceClass = reader.getAttribute("sourceClass");
        if (sourceClass != null) {
            gbeanInfo = GBeanInfo.getGBeanInfo(sourceClass, classLoader);
        }
        LinkedHashSet<ReferencePatterns> dependencies = new LinkedHashSet<ReferencePatterns>();
        LinkedHashMap attributes = new LinkedHashMap();
        LinkedHashMap<String, ReferencePatterns> references = new LinkedHashMap<String, ReferencePatterns>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String nodeName = reader.getNodeName();
            if (nodeName.equals("gbean-info")) {
                if (gbeanInfo != null) {
                    throw new ConversionException("GBean info declared more than once in gbean " + abstractName);
                }
                gbeanInfo = (GBeanInfo)unmarshallingContext.convertAnother((Object)reader, class$org$apache$geronimo$gbean$GBeanInfo == null ? GBeanDataConverter.class$("org.apache.geronimo.gbean.GBeanInfo") : class$org$apache$geronimo$gbean$GBeanInfo);
            } else if (nodeName.equals("dependency")) {
                ReferencePatterns referencePatterns = (ReferencePatterns)unmarshallingContext.convertAnother((Object)reader, class$org$apache$geronimo$gbean$ReferencePatterns == null ? GBeanDataConverter.class$("org.apache.geronimo.gbean.ReferencePatterns") : class$org$apache$geronimo$gbean$ReferencePatterns);
                dependencies.add(referencePatterns);
            } else if (nodeName.equals("attribute")) {
                String attributeName = reader.getAttribute("name");
                reader.moveDown();
                String classAttribute = reader.getAttribute(this.mapper.attributeForImplementationClass());
                Class type = classAttribute == null ? this.mapper.realClass(reader.getNodeName()) : this.mapper.realClass(classAttribute);
                attributeValue = unmarshallingContext.convertAnother((Object)reader, type);
                reader.moveUp();
                attributes.put(attributeName, attributeValue);
            } else if (nodeName.equals("reference")) {
                String referenceName = reader.getAttribute("name");
                ReferencePatterns referencePatterns = (ReferencePatterns)unmarshallingContext.convertAnother((Object)reader, class$org$apache$geronimo$gbean$ReferencePatterns == null ? GBeanDataConverter.class$("org.apache.geronimo.gbean.ReferencePatterns") : class$org$apache$geronimo$gbean$ReferencePatterns);
                references.put(referenceName, referencePatterns);
            } else {
                throw new ConversionException("Unknown nested node in GBean: " + nodeName);
            }
            reader.moveUp();
        }
        if (gbeanInfo == null) {
            throw new ConversionException("GBean info not declared in gbean " + abstractName);
        }
        GBeanData gbeanData = new GBeanData(abstractName, gbeanInfo);
        gbeanData.setDependencies(dependencies);
        Iterator iterator = attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            String attributeName = (String)entry.getKey();
            attributeValue = entry.getValue();
            gbeanData.setAttribute(attributeName, attributeValue);
        }
        iterator = references.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            String referenceName = (String)entry.getKey();
            ReferencePatterns referencePatterns = (ReferencePatterns)entry.getValue();
            gbeanData.setReferencePatterns(referenceName, referencePatterns);
        }
        return gbeanData;
    }
}

