/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationResolver;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.DeploymentWatcher;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.LifecycleException;
import org.apache.geronimo.kernel.config.LifecycleResults;
import org.apache.geronimo.kernel.config.ManageableAttributeStore;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.config.PersistentConfigurationList;
import org.apache.geronimo.kernel.config.SimpleConfigurationManager;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactManager;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.DefaultArtifactResolver;
import org.apache.geronimo.kernel.repository.Repository;

public class KernelConfigurationManager
extends SimpleConfigurationManager
implements GBeanLifecycle {
    protected final Kernel kernel;
    protected final ManageableAttributeStore attributeStore;
    protected final PersistentConfigurationList configurationList;
    private final ArtifactManager artifactManager;
    protected final ClassLoader classLoader;
    private final ShutdownHook shutdownHook;
    private boolean online = true;
    public static final GBeanInfo GBEAN_INFO;
    static /* synthetic */ Class class$org$apache$geronimo$kernel$config$Configuration;

    public KernelConfigurationManager(Kernel kernel, Collection stores, ManageableAttributeStore attributeStore, PersistentConfigurationList configurationList, ArtifactManager artifactManager, ArtifactResolver artifactResolver, Collection repositories, Collection watchers, ClassLoader classLoader) {
        super(stores, KernelConfigurationManager.createArtifactResolver(artifactResolver, artifactManager, repositories), repositories, watchers);
        this.kernel = kernel;
        this.attributeStore = attributeStore;
        this.configurationList = configurationList;
        this.artifactManager = artifactManager;
        this.classLoader = classLoader;
        this.shutdownHook = new ShutdownHook(kernel);
    }

    private static ArtifactResolver createArtifactResolver(ArtifactResolver artifactResolver, ArtifactManager artifactManager, Collection repositories) {
        if (artifactResolver != null) {
            return artifactResolver;
        }
        return new DefaultArtifactResolver(artifactManager, repositories, null);
    }

    public synchronized LifecycleResults loadConfiguration(Artifact configurationId) throws NoSuchConfigException, LifecycleException {
        AbstractName abstractName = null;
        try {
            abstractName = Configuration.getConfigurationAbstractName(configurationId);
        }
        catch (InvalidConfigException e) {
            throw new RuntimeException(e);
        }
        if (this.getConfiguration(configurationId) == null && this.kernel.isLoaded(abstractName)) {
            try {
                Configuration configuration = (Configuration)this.kernel.getGBean(abstractName);
                this.addNewConfigurationToModel(configuration);
                this.configurationModel.load(configurationId);
                this.configurationModel.start(configurationId);
                return new LifecycleResults();
            }
            catch (GBeanNotFoundException gBeanNotFoundException) {
                // empty catch block
            }
        }
        return super.loadConfiguration(configurationId);
    }

    protected void load(Artifact configurationId) throws NoSuchConfigException {
        super.load(configurationId);
        if (this.configurationList != null) {
            this.configurationList.addConfiguration(configurationId);
        }
    }

    protected void migrateConfiguration(Artifact oldName, Artifact newName, Configuration configuration, boolean running) throws NoSuchConfigException {
        super.migrateConfiguration(oldName, newName, configuration, running);
        if (this.configurationList != null) {
            this.configurationList.migrateConfiguration(oldName, newName, configuration);
            if (running) {
                this.configurationList.startConfiguration(newName);
            }
        }
    }

    protected Configuration load(ConfigurationData configurationData, LinkedHashSet resolvedParentIds, Map loadedConfigurations) throws InvalidConfigException {
        Configuration configuration;
        Artifact configurationId = configurationData.getId();
        AbstractName configurationName = Configuration.getConfigurationAbstractName(configurationId);
        GBeanData gbeanData = new GBeanData(configurationName, Configuration.GBEAN_INFO);
        gbeanData.setAttribute("configurationData", configurationData);
        gbeanData.setAttribute("configurationResolver", new ConfigurationResolver(configurationData, this.repositories, this.getArtifactResolver()));
        gbeanData.setAttribute("managedAttributeStore", this.attributeStore);
        LinkedHashSet<AbstractName> parentNames = new LinkedHashSet<AbstractName>();
        Iterator iterator = resolvedParentIds.iterator();
        while (iterator.hasNext()) {
            Artifact resolvedParentId = (Artifact)iterator.next();
            AbstractName parentName = Configuration.getConfigurationAbstractName(resolvedParentId);
            parentNames.add(parentName);
        }
        gbeanData.addDependencies(parentNames);
        gbeanData.setReferencePatterns("Parents", parentNames);
        try {
            this.kernel.loadGBean(gbeanData, this.classLoader);
        }
        catch (GBeanAlreadyExistsException e) {
            throw new InvalidConfigException("Unable to load configuration gbean " + configurationId, e);
        }
        try {
            this.kernel.startGBean(configurationName);
            if (1 != this.kernel.getGBeanState(configurationName)) {
                throw new InvalidConfigurationException("Configuration gbean failed to start " + configurationId);
            }
            configuration = (Configuration)this.kernel.getGBean(configurationName);
            if (this.artifactManager != null) {
                this.artifactManager.loadArtifacts(configurationId, configuration.getDependencies());
            }
            log.debug((Object)("Loaded Configuration " + configurationName));
        }
        catch (Exception e) {
            this.unload(configurationId);
            if (e instanceof InvalidConfigException) {
                throw (InvalidConfigException)e;
            }
            throw new InvalidConfigException("Error starting configuration gbean " + configurationId, e);
        }
        return configuration;
    }

    public void start(Configuration configuration) throws InvalidConfigException {
        if (this.online) {
            ConfigurationUtil.startConfigurationGBeans(configuration.getAbstractName(), configuration, this.kernel);
        }
        if (this.configurationList != null && configuration.getConfigurationData().isAutoStart()) {
            this.configurationList.startConfiguration(configuration.getId());
        }
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setOnline(boolean online) {
        this.online = online;
    }

    protected void stop(Configuration configuration) {
        this.stopRecursive(configuration);
        if (this.configurationList != null) {
            this.configurationList.stopConfiguration(configuration.getId());
        }
    }

    private void stopRecursive(Configuration configuration) {
        AbstractName gbeanName;
        GBeanData gbeanData;
        Iterator iterator = configuration.getChildren().iterator();
        while (iterator.hasNext()) {
            Configuration childConfiguration = (Configuration)iterator.next();
            this.stopRecursive(childConfiguration);
        }
        Collection gbeans = configuration.getGBeans().values();
        Iterator iterator2 = gbeans.iterator();
        while (iterator2.hasNext()) {
            gbeanData = (GBeanData)iterator2.next();
            gbeanName = gbeanData.getAbstractName();
            try {
                this.kernel.stopGBean(gbeanName);
            }
            catch (GBeanNotFoundException ignored) {
            }
            catch (IllegalStateException ignored) {
            }
            catch (InternalKernelException kernelException) {
                log.debug((Object)("Error cleaning up after failed start of configuration " + configuration.getId() + " gbean " + gbeanName), (Throwable)kernelException);
            }
        }
        iterator2 = gbeans.iterator();
        while (iterator2.hasNext()) {
            gbeanData = (GBeanData)iterator2.next();
            gbeanName = gbeanData.getAbstractName();
            try {
                this.kernel.unloadGBean(gbeanName);
            }
            catch (GBeanNotFoundException ignored) {
            }
            catch (IllegalStateException ignored) {
            }
            catch (InternalKernelException kernelException) {
                log.debug((Object)("Error cleaning up after failed start of configuration " + configuration.getId() + " gbean " + gbeanName), (Throwable)kernelException);
            }
        }
    }

    protected void unload(Configuration configuration) {
        Artifact configurationId = configuration.getId();
        this.unload(configurationId);
    }

    private void unload(Artifact configurationId) {
        AbstractName configurationName;
        try {
            configurationName = Configuration.getConfigurationAbstractName(configurationId);
        }
        catch (InvalidConfigException e) {
            throw new AssertionError((Object)e);
        }
        if (this.artifactManager != null) {
            this.artifactManager.unloadAllArtifacts(configurationId);
        }
        try {
            this.kernel.stopGBean(configurationName);
        }
        catch (GBeanNotFoundException ignored) {
        }
        catch (Exception stopException) {
            log.warn((Object)("Unable to stop failed configuration: " + configurationId), (Throwable)stopException);
        }
        try {
            this.kernel.unloadGBean(configurationName);
        }
        catch (GBeanNotFoundException ignored) {
        }
        catch (Exception unloadException) {
            log.warn((Object)("Unable to unload failed configuration: " + configurationId), (Throwable)unloadException);
        }
    }

    public void doStart() {
        this.kernel.registerShutdownHook(this.shutdownHook);
    }

    public void doStop() {
        this.kernel.unregisterShutdownHook(this.shutdownHook);
    }

    public void doFail() {
        log.error((Object)"Cofiguration manager failed");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(KernelConfigurationManager.class, "ConfigurationManager");
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addReference("Stores", ConfigurationStore.class, "ConfigurationStore");
        infoFactory.addReference("AttributeStore", ManageableAttributeStore.class, "AttributeStore");
        infoFactory.addReference("PersistentConfigurationList", PersistentConfigurationList.class, "PersistentConfigurationList");
        infoFactory.addReference("ArtifactManager", ArtifactManager.class, "ArtifactManager");
        infoFactory.addReference("ArtifactResolver", ArtifactResolver.class, "ArtifactResolver");
        infoFactory.addReference("Repositories", Repository.class, "Repository");
        infoFactory.addReference("Watchers", DeploymentWatcher.class);
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.addInterface(ConfigurationManager.class);
        infoFactory.setConstructor(new String[]{"kernel", "Stores", "AttributeStore", "PersistentConfigurationList", "ArtifactManager", "ArtifactResolver", "Repositories", "Watchers", "classLoader"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    private static class ShutdownHook
    implements Runnable {
        private final Kernel kernel;

        public ShutdownHook(Kernel kernel) {
            this.kernel = kernel;
        }

        public void run() {
            Set configs;
            block5: while (!(configs = this.kernel.listGBeans(new AbstractNameQuery((class$org$apache$geronimo$kernel$config$Configuration == null ? KernelConfigurationManager.class$("org.apache.geronimo.kernel.config.Configuration") : class$org$apache$geronimo$kernel$config$Configuration).getName()))).isEmpty()) {
                Iterator i = configs.iterator();
                while (true) {
                    if (!i.hasNext()) continue block5;
                    AbstractName configName = (AbstractName)i.next();
                    if (!this.kernel.isLoaded(configName)) continue;
                    try {
                        this.kernel.stopGBean(configName);
                    }
                    catch (GBeanNotFoundException e) {
                    }
                    catch (InternalKernelException e) {
                        SimpleConfigurationManager.log.warn((Object)("Could not stop configuration: " + configName), (Throwable)e);
                    }
                    try {
                        this.kernel.unloadGBean(configName);
                    }
                    catch (GBeanNotFoundException e) {
                    }
                }
                break;
            }
            return;
        }
    }
}

