/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.geronimo.kernel.repository.Artifact;

public class ConfigurationStatus {
    private Artifact configurationId;
    private final Set loadParents = new LinkedHashSet();
    private final Set startParents = new LinkedHashSet();
    private final LinkedHashSet loadChildren = new LinkedHashSet();
    private final LinkedHashSet startChildren = new LinkedHashSet();
    private boolean loaded = false;
    private boolean started = false;
    private boolean userLoaded = false;
    private boolean userStarted = false;

    public ConfigurationStatus(Artifact configId, Set loadParents, Set startParents) {
        if (configId == null) {
            throw new NullPointerException("configId is null");
        }
        if (loadParents == null) {
            throw new NullPointerException("loadParents is null");
        }
        if (startParents == null) {
            throw new NullPointerException("startParents is null");
        }
        if (!loadParents.containsAll(startParents)) {
            throw new IllegalArgumentException("loadParents must contain all startParents");
        }
        this.configurationId = configId;
        this.loadParents.addAll(loadParents);
        this.startParents.addAll(startParents);
        Iterator iterator = loadParents.iterator();
        while (iterator.hasNext()) {
            ConfigurationStatus loadParent = (ConfigurationStatus)iterator.next();
            loadParent.loadChildren.add(this);
        }
        iterator = startParents.iterator();
        while (iterator.hasNext()) {
            ConfigurationStatus startParent = (ConfigurationStatus)iterator.next();
            startParent.startChildren.add(this);
        }
    }

    public void destroy() {
        if (this.started) {
            throw new IllegalStateException("Configuration " + this.configurationId + " is still running");
        }
        if (this.loaded) {
            throw new IllegalStateException("Configuration " + this.configurationId + " is still loaded");
        }
        if (this.loadChildren.size() > 0 || this.startChildren.size() > 0) {
            throw new IllegalStateException("Configuration " + this.configurationId + " still has children");
        }
        Iterator iterator = this.loadParents.iterator();
        while (iterator.hasNext()) {
            ConfigurationStatus loadParent = (ConfigurationStatus)iterator.next();
            loadParent.loadChildren.remove(this);
        }
        this.loadParents.clear();
        iterator = this.startParents.iterator();
        while (iterator.hasNext()) {
            ConfigurationStatus startParent = (ConfigurationStatus)iterator.next();
            startParent.startChildren.remove(this);
        }
        this.startChildren.clear();
    }

    public Artifact getConfigurationId() {
        return this.configurationId;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isUserLoaded() {
        return this.userLoaded;
    }

    public boolean isUserStarted() {
        return this.userStarted;
    }

    public void upgrade(Artifact newId, Set newLoadParents, Set newStartParents) {
        ConfigurationStatus startParent;
        ConfigurationStatus loadParent;
        this.configurationId = newId;
        Iterator iterator = this.loadParents.iterator();
        while (iterator.hasNext()) {
            loadParent = (ConfigurationStatus)iterator.next();
            loadParent.loadChildren.remove(this);
        }
        this.loadParents.clear();
        iterator = this.startParents.iterator();
        while (iterator.hasNext()) {
            startParent = (ConfigurationStatus)iterator.next();
            startParent.startChildren.remove(this);
        }
        this.startChildren.clear();
        this.loadParents.addAll(newLoadParents);
        this.startParents.addAll(newStartParents);
        iterator = this.loadParents.iterator();
        while (iterator.hasNext()) {
            loadParent = (ConfigurationStatus)iterator.next();
            loadParent.loadChildren.add(this);
        }
        iterator = this.startParents.iterator();
        while (iterator.hasNext()) {
            startParent = (ConfigurationStatus)iterator.next();
            startParent.startChildren.add(this);
        }
    }

    public LinkedHashSet load() {
        LinkedHashSet loadList = new LinkedHashSet();
        this.loadInternal(loadList);
        this.userLoaded = true;
        return loadList;
    }

    private void loadInternal(LinkedHashSet loadList) {
        Iterator iterator = this.loadParents.iterator();
        while (iterator.hasNext()) {
            ConfigurationStatus parent = (ConfigurationStatus)iterator.next();
            if (parent.isLoaded()) continue;
            parent.loadInternal(loadList);
        }
        if (!this.loaded) {
            loadList.add(this.configurationId);
            this.loaded = true;
        }
    }

    public LinkedHashSet start() {
        if (!this.loaded) {
            throw new IllegalStateException(this.configurationId + " is not loaded");
        }
        LinkedHashSet startList = new LinkedHashSet();
        this.startInternal(startList);
        this.userLoaded = true;
        this.userStarted = true;
        return startList;
    }

    private void startInternal(LinkedHashSet startList) {
        Iterator iterator = this.startParents.iterator();
        while (iterator.hasNext()) {
            ConfigurationStatus parent = (ConfigurationStatus)iterator.next();
            if (parent.isStarted()) continue;
            parent.startInternal(startList);
        }
        if (!this.started) {
            startList.add(this.configurationId);
            this.started = true;
        }
    }

    public LinkedHashSet stop(boolean gc) {
        LinkedHashSet stopStatuses = new LinkedHashSet();
        this.stopInternal(stopStatuses, gc);
        LinkedHashSet<Artifact> stopIds = new LinkedHashSet<Artifact>(stopStatuses.size());
        Iterator iterator = stopStatuses.iterator();
        while (iterator.hasNext()) {
            ConfigurationStatus configurationStatus = (ConfigurationStatus)iterator.next();
            stopIds.add(configurationStatus.configurationId);
        }
        return stopIds;
    }

    private void stopInternal(LinkedHashSet stopList, boolean gc) {
        if (!this.started) {
            return;
        }
        Iterator iterator = this.startChildren.iterator();
        while (iterator.hasNext()) {
            ConfigurationStatus child = (ConfigurationStatus)iterator.next();
            if (!child.isStarted()) continue;
            child.stopInternal(stopList, gc);
        }
        if (this.started) {
            this.started = false;
            this.userStarted = false;
            stopList.add(this);
            if (gc) {
                iterator = this.startParents.iterator();
                while (iterator.hasNext()) {
                    ConfigurationStatus parent = (ConfigurationStatus)iterator.next();
                    if (parent.isUserStarted() || !stopList.containsAll(parent.startChildren)) continue;
                    parent.stopInternal(stopList, gc);
                }
            }
        }
    }

    public LinkedHashSet restart() {
        if (!this.started) {
            throw new IllegalStateException(this.configurationId + " is not started");
        }
        LinkedHashSet restartStatuses = new LinkedHashSet();
        this.restartInternal(restartStatuses);
        LinkedHashSet<Artifact> restartIds = new LinkedHashSet<Artifact>(restartStatuses.size());
        Iterator iterator = restartStatuses.iterator();
        while (iterator.hasNext()) {
            ConfigurationStatus configurationStatus = (ConfigurationStatus)iterator.next();
            restartIds.add(configurationStatus.configurationId);
        }
        this.userLoaded = true;
        this.userStarted = true;
        return restartIds;
    }

    private void restartInternal(LinkedHashSet restartList) {
        if (!this.started) {
            return;
        }
        Iterator iterator = this.startChildren.iterator();
        while (iterator.hasNext()) {
            ConfigurationStatus child = (ConfigurationStatus)iterator.next();
            if (!child.isStarted()) continue;
            child.restartInternal(restartList);
        }
        restartList.add(this);
    }

    public LinkedHashSet unload(boolean gc) {
        LinkedHashSet unloadStatuses = new LinkedHashSet();
        this.unloadInternal(unloadStatuses, gc);
        LinkedHashSet<Artifact> unloadIds = new LinkedHashSet<Artifact>(unloadStatuses.size());
        Iterator iterator = unloadStatuses.iterator();
        while (iterator.hasNext()) {
            ConfigurationStatus configurationStatus = (ConfigurationStatus)iterator.next();
            unloadIds.add(configurationStatus.configurationId);
        }
        return unloadIds;
    }

    private void unloadInternal(LinkedHashSet unloadList, boolean gc) {
        if (!this.loaded) {
            return;
        }
        Iterator iterator = this.loadChildren.iterator();
        while (iterator.hasNext()) {
            ConfigurationStatus child = (ConfigurationStatus)iterator.next();
            if (!child.isLoaded()) continue;
            child.unloadInternal(unloadList, gc);
        }
        if (this.loaded) {
            this.started = false;
            this.userStarted = false;
            this.loaded = false;
            this.userLoaded = false;
            unloadList.add(this);
            if (gc) {
                iterator = this.loadParents.iterator();
                while (iterator.hasNext()) {
                    ConfigurationStatus parent = (ConfigurationStatus)iterator.next();
                    if (parent.isUserLoaded() || !unloadList.containsAll(parent.loadChildren)) continue;
                    parent.unloadInternal(unloadList, gc);
                }
            }
        }
    }

    public LinkedHashSet reload() {
        if (!this.loaded) {
            throw new IllegalStateException(this.configurationId + " is not loaded");
        }
        LinkedHashSet reloadStatuses = new LinkedHashSet();
        this.reloadInternal(reloadStatuses);
        LinkedHashSet<Artifact> reloadIds = new LinkedHashSet<Artifact>(reloadStatuses.size());
        Iterator iterator = reloadStatuses.iterator();
        while (iterator.hasNext()) {
            ConfigurationStatus configurationStatus = (ConfigurationStatus)iterator.next();
            reloadIds.add(configurationStatus.configurationId);
        }
        this.userLoaded = true;
        return reloadIds;
    }

    private void reloadInternal(LinkedHashSet reloadList) {
        if (!this.loaded) {
            return;
        }
        Iterator iterator = this.loadChildren.iterator();
        while (iterator.hasNext()) {
            ConfigurationStatus child = (ConfigurationStatus)iterator.next();
            if (!child.isLoaded()) continue;
            child.reloadInternal(reloadList);
        }
        reloadList.add(this);
    }

    public String toString() {
        String load = this.userLoaded ? "user-loaded" : (this.loaded ? "loaded" : "not-loaded");
        String start = this.userLoaded ? "user-started" : (this.loaded ? "started" : "not-started");
        return "[" + this.configurationId + " " + load + " " + start + "]";
    }
}

