/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.geronimo.kernel.config.ConfigurationStatus;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.repository.Artifact;

public class ConfigurationModel {
    private final Map configurations = new TreeMap();

    public void addConfiguation(Artifact configurationId, Set loadParentIds, Set startParentIds) throws NoSuchConfigException {
        Set startParents = this.getStatuses(startParentIds);
        LinkedHashSet loadParents = new LinkedHashSet(startParents);
        loadParents.addAll(this.getStatuses(loadParentIds));
        ConfigurationStatus configurationStatus = new ConfigurationStatus(configurationId, loadParents, startParents);
        this.configurations.put(configurationId, configurationStatus);
    }

    private Set getStatuses(Set configurationIds) throws NoSuchConfigException {
        LinkedHashSet<ConfigurationStatus> statuses = new LinkedHashSet<ConfigurationStatus>(configurationIds.size());
        Iterator iterator = configurationIds.iterator();
        while (iterator.hasNext()) {
            Artifact configurationId = (Artifact)iterator.next();
            ConfigurationStatus configurationStatus = (ConfigurationStatus)this.configurations.get(configurationId);
            if (configurationStatus == null) {
                throw new NoSuchConfigException(configurationId);
            }
            statuses.add(configurationStatus);
        }
        return statuses;
    }

    public void removeConfiguration(Artifact configurationId) throws NoSuchConfigException {
        ConfigurationStatus configurationStatus = (ConfigurationStatus)this.configurations.get(configurationId);
        if (configurationStatus == null) {
            throw new NoSuchConfigException(configurationId);
        }
        configurationStatus.destroy();
        this.configurations.remove(configurationId);
    }

    public boolean containsConfiguration(Artifact configurationId) {
        return this.configurations.containsKey(configurationId);
    }

    public void upgradeConfiguration(Artifact existingId, Artifact newId, Set newLoadParentIds, Set newStartParentIds) throws NoSuchConfigException {
        Set newStartParents = this.getStatuses(newStartParentIds);
        LinkedHashSet newLoadParents = new LinkedHashSet(newStartParents);
        newLoadParents.addAll(this.getStatuses(newLoadParentIds));
        ConfigurationStatus configurationStatus = (ConfigurationStatus)this.configurations.remove(existingId);
        if (configurationStatus == null) {
            throw new NoSuchConfigException(existingId);
        }
        this.configurations.put(newId, configurationStatus);
        configurationStatus.upgrade(newId, newLoadParents, newStartParents);
    }

    public boolean isLoaded(Artifact configurationId) {
        ConfigurationStatus configurationStatus = (ConfigurationStatus)this.configurations.get(configurationId);
        if (configurationStatus != null) {
            return configurationStatus.isLoaded();
        }
        return false;
    }

    public Artifact[] getLoaded(Artifact query) {
        ArrayList<Artifact> results = new ArrayList<Artifact>();
        Iterator it = this.configurations.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Artifact test = (Artifact)entry.getKey();
            ConfigurationStatus status = (ConfigurationStatus)entry.getValue();
            if (!query.matches(test) || !status.isLoaded()) continue;
            results.add(test);
        }
        return results.toArray(new Artifact[results.size()]);
    }

    public boolean isStarted(Artifact configurationId) {
        ConfigurationStatus configurationStatus = (ConfigurationStatus)this.configurations.get(configurationId);
        if (configurationStatus != null) {
            return configurationStatus.isStarted();
        }
        return false;
    }

    public Artifact[] getStarted(Artifact query) {
        ArrayList<Artifact> results = new ArrayList<Artifact>();
        Iterator it = this.configurations.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Artifact test = (Artifact)entry.getKey();
            ConfigurationStatus status = (ConfigurationStatus)entry.getValue();
            if (!query.matches(test) || !status.isStarted()) continue;
            results.add(test);
        }
        return results.toArray(new Artifact[results.size()]);
    }

    public LinkedHashSet load(Artifact configurationId) throws NoSuchConfigException {
        ConfigurationStatus configurationStatus = (ConfigurationStatus)this.configurations.get(configurationId);
        if (configurationStatus == null) {
            throw new NoSuchConfigException(configurationId);
        }
        return configurationStatus.load();
    }

    public LinkedHashSet start(Artifact configurationId) throws NoSuchConfigException {
        ConfigurationStatus configurationStatus = (ConfigurationStatus)this.configurations.get(configurationId);
        if (configurationStatus == null) {
            throw new NoSuchConfigException(configurationId);
        }
        return configurationStatus.start();
    }

    public LinkedHashSet stop(Artifact configurationId) throws NoSuchConfigException {
        return this.stop(configurationId, true);
    }

    public LinkedHashSet stop(Artifact configurationId, boolean gc) throws NoSuchConfigException {
        ConfigurationStatus configurationStatus = (ConfigurationStatus)this.configurations.get(configurationId);
        if (configurationStatus == null) {
            throw new NoSuchConfigException(configurationId);
        }
        return configurationStatus.stop(gc);
    }

    public LinkedHashSet restart(Artifact configurationId) throws NoSuchConfigException {
        ConfigurationStatus configurationStatus = (ConfigurationStatus)this.configurations.get(configurationId);
        if (configurationStatus == null) {
            throw new NoSuchConfigException(configurationId);
        }
        return configurationStatus.restart();
    }

    public LinkedHashSet unload(Artifact configurationId) throws NoSuchConfigException {
        return this.unload(configurationId, true);
    }

    public LinkedHashSet unload(Artifact configurationId, boolean gc) throws NoSuchConfigException {
        ConfigurationStatus configurationStatus = (ConfigurationStatus)this.configurations.get(configurationId);
        if (configurationStatus == null) {
            throw new NoSuchConfigException(configurationId);
        }
        return configurationStatus.unload(gc);
    }

    public LinkedHashSet reload(Artifact existingConfigurationId) throws NoSuchConfigException {
        ConfigurationStatus configurationStatus = (ConfigurationStatus)this.configurations.get(existingConfigurationId);
        if (configurationStatus == null) {
            return new LinkedHashSet();
        }
        return configurationStatus.reload();
    }

    public Set getLoaded() {
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        Iterator iterator = this.configurations.values().iterator();
        while (iterator.hasNext()) {
            ConfigurationStatus status = (ConfigurationStatus)iterator.next();
            if (!status.isLoaded()) continue;
            result.add(status.getConfigurationId());
        }
        return result;
    }

    public Set getStarted() {
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        Iterator iterator = this.configurations.values().iterator();
        while (iterator.hasNext()) {
            ConfigurationStatus status = (ConfigurationStatus)iterator.next();
            if (!status.isStarted()) continue;
            result.add(status.getConfigurationId());
        }
        return result;
    }

    public Set getUserLoaded() {
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        Iterator iterator = this.configurations.values().iterator();
        while (iterator.hasNext()) {
            ConfigurationStatus status = (ConfigurationStatus)iterator.next();
            if (!status.isUserLoaded()) continue;
            result.add(status.getConfigurationId());
        }
        return result;
    }

    public Set getUserStarted() {
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        Iterator iterator = this.configurations.values().iterator();
        while (iterator.hasNext()) {
            ConfigurationStatus status = (ConfigurationStatus)iterator.next();
            if (!status.isUserStarted()) continue;
            result.add(status.getConfigurationId());
        }
        return result;
    }
}

