/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.GBeanState;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Environment;

public class ConfigurationData
implements Serializable {
    private static final long serialVersionUID = 4324193220056650732L;
    private final long created = System.currentTimeMillis();
    private final ConfigurationModuleType moduleType;
    private final Environment environment;
    private final LinkedHashSet classPath = new LinkedHashSet();
    private final GBeanState gbeanState;
    private final Map childConfigurations = new LinkedHashMap();
    private final Set ownedConfigurations = new LinkedHashSet();
    private transient File configurationDir;
    private File inPlaceConfigurationDir;
    private boolean autoStart = true;
    private transient Naming naming;
    private transient ConfigurationStore configurationStore;

    public ConfigurationData(Artifact configId, Naming naming, GBeanState gbeanState) {
        this(new Environment(configId), naming, gbeanState);
    }

    public ConfigurationData(Environment environment, Naming naming, GBeanState gbeanState) {
        if (environment == null) {
            throw new NullPointerException("environment is null");
        }
        if (environment.getConfigId() == null) {
            throw new NullPointerException("environment.configId is null");
        }
        if (naming == null) {
            throw new NullPointerException("naming is null");
        }
        this.environment = environment;
        this.naming = naming;
        this.gbeanState = gbeanState;
        this.moduleType = ConfigurationModuleType.CAR;
    }

    public ConfigurationData(Artifact configId, Naming naming) {
        this(new Environment(configId), naming);
    }

    public ConfigurationData(Environment environment, Naming naming) {
        this(null, null, null, null, environment, null, null, naming);
    }

    public ConfigurationData(ConfigurationModuleType moduleType, LinkedHashSet classPath, List gbeans, Map childConfigurations, Environment environment, File configurationDir, File inPlaceConfigurationDir, Naming naming) {
        if (naming == null) {
            throw new NullPointerException("naming is null");
        }
        this.naming = naming;
        this.moduleType = moduleType != null ? moduleType : ConfigurationModuleType.CAR;
        if (classPath != null) {
            this.classPath.addAll(classPath);
        }
        this.gbeanState = ConfigurationUtil.newGBeanState(gbeans);
        if (childConfigurations != null) {
            this.childConfigurations.putAll(childConfigurations);
        }
        if (environment == null) {
            throw new NullPointerException("environment is null");
        }
        if (environment.getConfigId() == null) {
            throw new NullPointerException("environment.configId is null");
        }
        this.environment = environment;
        this.configurationDir = configurationDir;
        this.inPlaceConfigurationDir = inPlaceConfigurationDir;
    }

    public Artifact getId() {
        return this.environment.getConfigId();
    }

    public long getCreated() {
        return this.created;
    }

    public ConfigurationModuleType getModuleType() {
        return this.moduleType;
    }

    public List getClassPath() {
        return Collections.unmodifiableList(new ArrayList(this.classPath));
    }

    public List getGBeans(ClassLoader classLoader) throws InvalidConfigException {
        if (classLoader == null) {
            throw new NullPointerException("classLoader is null");
        }
        return this.gbeanState.getGBeans(classLoader);
    }

    public void addGBean(GBeanData gbeanData) {
        if (gbeanData == null) {
            throw new NullPointerException("gbeanData is null");
        }
        this.gbeanState.addGBean(gbeanData);
    }

    public GBeanData addGBean(String name, GBeanInfo gbeanInfo) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (gbeanInfo == null) {
            throw new NullPointerException("gbeanInfo is null");
        }
        return this.gbeanState.addGBean(name, gbeanInfo, this.naming, this.environment);
    }

    public GBeanState getGbeanState() {
        return this.gbeanState;
    }

    public Map getChildConfigurations() {
        return Collections.unmodifiableMap(this.childConfigurations);
    }

    public void addChildConfiguration(ConfigurationData configurationData) {
        if (configurationData == null) {
            throw new NullPointerException("configurationData is null");
        }
        this.childConfigurations.put(configurationData.getId(), configurationData);
    }

    public Set getOwnedConfigurations() {
        return Collections.unmodifiableSet(this.ownedConfigurations);
    }

    public void addOwnedConfigurations(Artifact id) {
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        if (!id.isResolved()) {
            throw new IllegalArgumentException("id is not resolved: " + id);
        }
        this.ownedConfigurations.add(id);
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public File getInPlaceConfigurationDir() {
        return this.inPlaceConfigurationDir;
    }

    public File getConfigurationDir() {
        return this.configurationDir;
    }

    public void setConfigurationDir(File configurationDir) {
        if (configurationDir == null) {
            throw new NullPointerException("configurationDir is null");
        }
        this.configurationDir = configurationDir;
    }

    public Naming getNaming() {
        return this.naming;
    }

    public void setNaming(Naming naming) {
        this.naming = naming;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public ConfigurationStore getConfigurationStore() {
        return this.configurationStore;
    }

    public void setConfigurationStore(ConfigurationStore configurationStore) {
        if (configurationStore == null) {
            throw new NullPointerException("configurationStore is null");
        }
        this.configurationStore = configurationStore;
    }
}

