/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;

public class ReferencePatterns
implements Serializable {
    private static final long serialVersionUID = 1888371271299507818L;
    private final Set patterns;
    private final AbstractName abstractName;

    public ReferencePatterns(Set patterns) {
        this.patterns = new LinkedHashSet();
        Iterator iterator = patterns.iterator();
        while (iterator.hasNext()) {
            Object pattern = iterator.next();
            if (pattern instanceof AbstractName) {
                AbstractName name = (AbstractName)pattern;
                this.patterns.add(new AbstractNameQuery(name));
                continue;
            }
            if (pattern instanceof AbstractNameQuery) {
                AbstractNameQuery nameQuery = (AbstractNameQuery)pattern;
                this.patterns.add(nameQuery);
                continue;
            }
            throw new IllegalArgumentException("Unknown pattern type: " + pattern);
        }
        this.abstractName = null;
    }

    public ReferencePatterns(AbstractNameQuery abstractNameQuery) {
        this.patterns = Collections.singleton(abstractNameQuery);
        this.abstractName = null;
    }

    public ReferencePatterns(AbstractName abstractName) {
        if (abstractName == null) {
            throw new IllegalArgumentException("parameter abstractName is null");
        }
        this.abstractName = abstractName;
        this.patterns = null;
    }

    public Set getPatterns() {
        if (this.patterns == null) {
            throw new IllegalStateException("This is resolved to: " + this.abstractName);
        }
        return this.patterns;
    }

    public AbstractName getAbstractName() {
        if (this.abstractName == null) {
            throw new IllegalStateException("This is not resolved with patterns: " + this.patterns);
        }
        return this.abstractName;
    }

    public boolean isResolved() {
        return this.abstractName != null;
    }

    public String toString() {
        if (this.abstractName != null) {
            return this.abstractName.toString();
        }
        return this.patterns.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof ReferencePatterns) {
            ReferencePatterns otherRefPat = (ReferencePatterns)other;
            if (this.abstractName != null) {
                return this.abstractName.equals(otherRefPat.abstractName);
            }
            return ((Object)this.patterns).equals(otherRefPat.patterns);
        }
        return false;
    }

    public int hashCode() {
        if (this.abstractName != null) {
            return this.abstractName.hashCode();
        }
        return ((Object)this.patterns).hashCode();
    }
}

