/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.management.ObjectName;
import org.apache.geronimo.kernel.Jsr77Naming;
import org.apache.geronimo.kernel.repository.Artifact;

public class AbstractName
implements Serializable {
    private static final long serialVersionUID = 3584199042821734754L;
    private final Artifact artifact;
    private final Map name;
    private final ObjectName objectName;
    private final URI uri;

    public AbstractName(Artifact artifact, Map name) {
        if (artifact == null) {
            throw new NullPointerException("artifact is null");
        }
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        this.artifact = artifact;
        this.name = name;
        this.objectName = Jsr77Naming.createObjectName(name);
        this.uri = AbstractName.createURI(artifact, name);
    }

    public AbstractName(Artifact artifact, Map name, ObjectName objectName) {
        if (artifact == null) {
            throw new NullPointerException("artifact is null");
        }
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        if (objectName == null) {
            throw new NullPointerException("objectName is null");
        }
        this.artifact = artifact;
        this.name = name;
        this.objectName = objectName;
        this.uri = AbstractName.createURI(artifact, name);
    }

    public AbstractName(URI uri) {
        String type;
        String version;
        String artifactId;
        if (uri == null) {
            throw new NullPointerException("uri is null");
        }
        String artifactString = uri.getPath();
        if (artifactString == null) {
            throw new IllegalArgumentException("uri does not contain a path part used for the artifact");
        }
        List artifactParts = AbstractName.split(artifactString, '/');
        if (artifactParts.size() != 4) {
            throw new IllegalArgumentException("uri path must be in the form [vendorId]/artifactId/[version]/[type] : " + artifactString);
        }
        String groupId = (String)artifactParts.get(0);
        if (groupId.length() == 0) {
            groupId = null;
        }
        if ((artifactId = (String)artifactParts.get(1)).length() == 0) {
            artifactId = null;
        }
        if ((version = (String)artifactParts.get(2)).length() == 0) {
            version = null;
        }
        if ((type = (String)artifactParts.get(3)).length() == 0) {
            type = null;
        }
        this.artifact = new Artifact(groupId, artifactId, version, type);
        this.name = new TreeMap();
        String nameString = uri.getQuery();
        if (nameString == null) {
            throw new IllegalArgumentException("uri does not contain a query part used for the name map");
        }
        List nameParts = AbstractName.split(nameString, ',');
        Iterator iterator = nameParts.iterator();
        while (iterator.hasNext()) {
            String namePart = (String)iterator.next();
            List keyValue = AbstractName.split(namePart, '=');
            if (keyValue.size() != 2) {
                throw new IllegalArgumentException("uri query string must be in the form ?key=value[,key=value]*] : " + nameString);
            }
            String key = (String)keyValue.get(0);
            String value = (String)keyValue.get(1);
            if (this.name.containsKey(key)) {
                throw new IllegalArgumentException("uri query string contains the key '" + key + "' twice : " + nameString);
            }
            this.name.put(key, value);
        }
        if (this.name.isEmpty()) {
            throw new IllegalArgumentException("name is empty: " + nameString);
        }
        this.uri = AbstractName.createURI(this.artifact, this.name);
        this.objectName = Jsr77Naming.createObjectName(this.name);
    }

    private static URI createURI(Artifact artifact, Map name) {
        StringBuffer queryString = new StringBuffer();
        TreeMap treeMap = new TreeMap(name);
        Iterator iterator = treeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            queryString.append(key).append('=').append(value);
            if (!iterator.hasNext()) continue;
            queryString.append(',');
        }
        try {
            return new URI(null, null, artifact.toString(), queryString.toString(), null);
        }
        catch (URISyntaxException e) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            illegalArgumentException.initCause(e);
            throw illegalArgumentException;
        }
    }

    private static List split(String source, char delim) {
        ArrayList<String> parts = new ArrayList<String>();
        int index = source.indexOf(delim);
        while (index >= 0) {
            String part = source.substring(0, index);
            source = source.substring(index + 1);
            parts.add(part);
            index = source.indexOf(delim);
        }
        parts.add(source);
        return parts;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public Map getName() {
        return Collections.unmodifiableMap(this.name);
    }

    public String getNameProperty(String key) {
        return (String)this.name.get(key);
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public URI toURI() {
        return this.uri;
    }

    public String toString() {
        return this.uri.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractName that = (AbstractName)o;
        if (this.artifact != null ? !this.artifact.equals(that.artifact) : that.artifact != null) {
            return false;
        }
        return !(this.name == null ? that.name != null : !((Object)this.name).equals(that.name));
    }

    public int hashCode() {
        int result = this.artifact != null ? this.artifact.hashCode() : 0;
        result = 29 * result + (this.name != null ? ((Object)this.name).hashCode() : 0);
        return result;
    }
}

