/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty8.security.auth;

import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.jaspi.JaspiMessageInfo;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;

public class GeronimoJaspiAuthenticator
implements Authenticator {
    private final ServerAuthConfig _authConfig;
    private final Map _authProperties;
    private final CallbackHandler _callbackHandler;
    private final Subject _serviceSubject;
    private final boolean _allowLazyAuthentication;
    private final IdentityService _identityService;
    private final DeferredAuthentication _deferred;

    public GeronimoJaspiAuthenticator(ServerAuthConfig authConfig, Map authProperties, CallbackHandler callbackHandler, Subject serviceSubject, boolean allowLazyAuthentication, IdentityService identityService) {
        if (callbackHandler == null) {
            throw new NullPointerException("No CallbackHandler");
        }
        if (authConfig == null) {
            throw new NullPointerException("No AuthConfig");
        }
        this._authConfig = authConfig;
        this._authProperties = authProperties;
        this._callbackHandler = callbackHandler;
        this._serviceSubject = serviceSubject;
        this._allowLazyAuthentication = allowLazyAuthentication;
        this._identityService = identityService;
        this._deferred = new DeferredAuthentication((Authenticator)this);
    }

    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
    }

    public String getAuthMethod() {
        return "JASPI";
    }

    public Authentication validateRequest(ServletRequest request, ServletResponse response, boolean mandatory) throws ServerAuthException {
        if (this._allowLazyAuthentication && !mandatory) {
            return this._deferred;
        }
        JaspiMessageInfo info = new JaspiMessageInfo(request, response, mandatory);
        request.setAttribute("org.eclipse.jetty.security.jaspi.info", (Object)info);
        return this.validateRequest(info);
    }

    public boolean secureResponse(ServletRequest req, ServletResponse res, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        JaspiMessageInfo info = (JaspiMessageInfo)req.getAttribute("org.eclipse.jetty.security.jaspi.info");
        if (info == null) {
            throw new NullPointerException("MeesageInfo from request missing: " + req);
        }
        return this.secureResponse(info, (Authentication)validatedUser);
    }

    public Authentication validateRequest(JaspiMessageInfo messageInfo) throws ServerAuthException {
        try {
            String authContextId = this._authConfig.getAuthContextID((MessageInfo)messageInfo);
            ServerAuthContext authContext = this._authConfig.getAuthContext(authContextId, this._serviceSubject, this._authProperties);
            Subject clientSubject = new Subject();
            AuthStatus authStatus = authContext.validateRequest((MessageInfo)messageInfo, clientSubject, this._serviceSubject);
            if (authStatus == AuthStatus.SEND_CONTINUE) {
                return Authentication.SEND_CONTINUE;
            }
            if (authStatus == AuthStatus.SEND_FAILURE) {
                return Authentication.SEND_FAILURE;
            }
            if (authStatus == AuthStatus.SUCCESS) {
                Set<UserIdentity> ids = clientSubject.getPrivateCredentials(UserIdentity.class);
                UserIdentity userIdentity = ids.size() > 0 ? ids.iterator().next() : this._identityService.newUserIdentity(clientSubject, null, null);
                return new UserAuthentication(this.getAuthMethod(), userIdentity);
            }
            if (authStatus == AuthStatus.SEND_SUCCESS) {
                return Authentication.SEND_SUCCESS;
            }
            throw new NullPointerException("No AuthStatus returned");
        }
        catch (AuthException e) {
            throw new ServerAuthException((Throwable)e);
        }
    }

    public boolean secureResponse(JaspiMessageInfo messageInfo, Authentication validatedUser) throws ServerAuthException {
        try {
            String authContextId = this._authConfig.getAuthContextID((MessageInfo)messageInfo);
            ServerAuthContext authContext = this._authConfig.getAuthContext(authContextId, this._serviceSubject, this._authProperties);
            AuthStatus status = authContext.secureResponse((MessageInfo)messageInfo, this._serviceSubject);
            return AuthStatus.SEND_SUCCESS.equals(status);
        }
        catch (AuthException e) {
            throw new ServerAuthException((Throwable)e);
        }
    }
}

