/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty7;

import java.util.Map;
import java.util.Set;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.jetty7.GeronimoServletHolder;
import org.apache.geronimo.jetty7.JettyServletRegistration;
import org.apache.geronimo.jetty7.ServletNameSource;
import org.apache.geronimo.management.Servlet;
import org.eclipse.jetty.servlet.ServletHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GBean(j2eeType="Servlet")
public class ServletHolderWrapper
implements ServletNameSource,
Servlet,
GBeanLifecycle {
    private final JettyServletRegistration servletRegistration;
    private final ServletHolder servletHolder;
    private final String objectName;

    public ServletHolderWrapper() {
        this.servletRegistration = null;
        this.servletHolder = null;
        this.objectName = null;
    }

    public ServletHolderWrapper(@ParamSpecial(type=SpecialAttributeType.objectName) String objectName, @ParamAttribute(name="servletName") String servletName, @ParamAttribute(name="servletClass") String servletClassName, @ParamAttribute(name="jspFile") String jspFile, @ParamAttribute(name="initParams") Map initParams, @ParamAttribute(name="loadOnStartup") Integer loadOnStartup, @ParamAttribute(name="servletMappings") Set<String> servletMappings, @ParamAttribute(name="runAsRole") String runAsRole, @ParamReference(name="JettyServletRegistration", namingType="WebModule") JettyServletRegistration context) throws Exception {
        this.servletRegistration = context;
        this.servletHolder = new GeronimoServletHolder(context == null ? null : context.getIntegrationContext(), this.servletRegistration);
        this.servletHolder.setName(servletName);
        this.servletHolder.setClassName(servletClassName);
        this.servletHolder.setRunAsRole(runAsRole);
        if (context != null) {
            this.servletHolder.setInitParameters(initParams);
            this.servletHolder.setForcedPath(jspFile);
            if (loadOnStartup != null) {
                this.servletHolder.setInitOrder(loadOnStartup.intValue());
            }
            context.registerServletHolder(this.servletHolder, servletName, servletMappings, objectName);
        }
        this.objectName = objectName;
    }

    @Override
    public String getServletName() {
        return this.servletHolder.getName();
    }

    public String getServletClassName() {
        return this.servletHolder.getClassName();
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return false;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return false;
    }

    public void doStart() throws Exception {
    }

    public void doStop() throws Exception {
        this.servletHolder.stop();
        if (this.servletRegistration != null) {
            this.servletRegistration.unregisterServletHolder(this.servletHolder, this.servletHolder.getName(), null, this.objectName);
        }
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

