/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty6;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.jacc.WebRoleRefPermission;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.jetty6.InternalJettyServletHolder;
import org.apache.geronimo.jetty6.JAASJettyPrincipal;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.realm.providers.CertificateCallbackHandler;
import org.apache.geronimo.security.realm.providers.PasswordCallbackHandler;
import org.mortbay.jetty.Request;

public class InternalJAASJettyRealm {
    private static Log log = LogFactory.getLog(InternalJAASJettyRealm.class);
    private final String securityRealmName;
    private final HashMap<String, Principal> userMap = new HashMap();
    private int count = 1;

    public InternalJAASJettyRealm(String geronimoRealmName) {
        this.securityRealmName = geronimoRealmName;
    }

    public String getSecurityRealmName() {
        return this.securityRealmName;
    }

    public Principal getPrincipal(String username) {
        return this.userMap.get(username);
    }

    public Principal authenticate(String username, Object credentials, Request request) {
        try {
            if (username != null && !username.equals("")) {
                PasswordCallbackHandler callbackHandler;
                char[] password;
                JAASJettyPrincipal userPrincipal = (JAASJettyPrincipal)this.userMap.get(username);
                if (userPrincipal != null) {
                    this.userMap.remove(username);
                }
                if (credentials instanceof char[]) {
                    password = (char[])credentials;
                    callbackHandler = new PasswordCallbackHandler(username, password);
                } else if (credentials instanceof String) {
                    password = ((String)credentials).toCharArray();
                    callbackHandler = new PasswordCallbackHandler(username, password);
                } else if (credentials instanceof X509Certificate[]) {
                    X509Certificate[] certs = (X509Certificate[])credentials;
                    if (certs.length < 1) {
                        throw new LoginException("no certificates supplied");
                    }
                    callbackHandler = new CertificateCallbackHandler(certs[0]);
                } else {
                    throw new LoginException("Cannot extract credentials from class: " + credentials.getClass().getName());
                }
                LoginContext loginContext = ContextManager.login((String)this.securityRealmName, (CallbackHandler)callbackHandler);
                callbackHandler.clear();
                Subject subject = ContextManager.getServerSideSubject((Subject)loginContext.getSubject());
                ContextManager.setCallers((Subject)subject, (Subject)subject);
                userPrincipal = new JAASJettyPrincipal(username);
                userPrincipal.setSubject(subject);
                this.userMap.put(username, userPrincipal);
                return userPrincipal;
            }
            log.debug((Object)"Login Failed - null userID");
            return null;
        }
        catch (LoginException e) {
            log.debug((Object)"Login Failed", (Throwable)e);
            return null;
        }
    }

    public void logout(Principal user) {
        JAASJettyPrincipal principal = (JAASJettyPrincipal)user;
        this.userMap.remove(principal.getName());
        ContextManager.unregisterSubject((Subject)principal.getSubject());
    }

    public boolean reauthenticate(Principal user) {
        Subject subject = ((JAASJettyPrincipal)user).getSubject();
        ContextManager.setCallers((Subject)subject, (Subject)subject);
        return this.userMap.get(user.getName()) != null;
    }

    public void disassociate(Principal user) {
    }

    public boolean isUserInRole(Principal user, String role) {
        if (user == null || role == null) {
            return false;
        }
        AccessControlContext acc = ContextManager.getCurrentContext();
        try {
            String servletName = InternalJettyServletHolder.getCurrentServletName();
            if (servletName == null || servletName.equals("jsp")) {
                servletName = "";
            }
            acc.checkPermission((Permission)new WebRoleRefPermission(servletName, role));
        }
        catch (AccessControlException e) {
            return false;
        }
        return true;
    }

    public Principal pushRole(Principal user, String role) {
        return user;
    }

    public Principal popRole(Principal user) {
        return user;
    }

    public void addUse() {
        ++this.count;
    }

    public int removeUse() {
        return this.count--;
    }
}

