/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty6;

import java.util.HashMap;
import java.util.Map;
import javax.management.j2ee.statistics.Stats;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.jetty6.InternalJAASJettyRealm;
import org.apache.geronimo.jetty6.JettyContainer;
import org.apache.geronimo.jetty6.JettyEJBWebServiceContext;
import org.apache.geronimo.jetty6.JettyServer;
import org.apache.geronimo.jetty6.JettyWebContainerStatsImpl;
import org.apache.geronimo.management.StatisticsProvider;
import org.apache.geronimo.management.geronimo.NetworkConnector;
import org.apache.geronimo.management.geronimo.WebManager;
import org.apache.geronimo.webservices.SoapHandler;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.AbstractHandlerContainer;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.handler.RequestLogHandler;

public class JettyContainerImpl
implements JettyContainer,
SoapHandler,
GBeanLifecycle,
StatisticsProvider {
    private final Server server;
    private final Map webServices = new HashMap();
    private final String objectName;
    private final WebManager manager;
    private JettyWebContainerStatsImpl stats;
    private final Map realms = new HashMap();
    private HandlerCollection handlerCollection = new HandlerCollection();
    private ContextHandlerCollection contextHandlerCollection = new ContextHandlerCollection();
    private DefaultHandler defaultHandler = new DefaultHandler();
    private RequestLogHandler requestLogHandler = new RequestLogHandler();
    public static final GBeanInfo GBEAN_INFO;

    public JettyContainerImpl(String objectName, WebManager manager) {
        this.objectName = objectName;
        this.server = new JettyServer();
        Handler[] handlers = new Handler[]{this.contextHandlerCollection, this.defaultHandler, this.requestLogHandler};
        this.handlerCollection.setHandlers(handlers);
        this.server.setHandler((Handler)this.handlerCollection);
        this.stats = new JettyWebContainerStatsImpl();
        this.manager = manager;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return true;
    }

    public boolean isEventProvider() {
        return true;
    }

    public NetworkConnector[] getConnectors() {
        return this.manager.getConnectorsForContainer((Object)this);
    }

    public NetworkConnector[] getConnectors(String protocol) {
        return this.manager.getConnectorsForContainer((Object)this, protocol);
    }

    public void resetStatistics() {
    }

    public void setCollectStatistics(boolean on) {
    }

    public boolean getCollectStatistics() {
        return false;
    }

    public long getCollectStatisticsStarted() {
        return 0L;
    }

    public void resetStats() {
    }

    public Stats getStats() {
        if (this.getCollectStatistics()) {
            this.stats.getRequestDurationImpl().setCount(this.stats.getTotalRequestCount().getCount());
            this.stats.getConnectionDurationImpl().setCount(this.stats.getTotalConnectionCount().getCount());
        }
        return this.stats;
    }

    public void addListener(Connector listener) {
        this.server.addConnector(listener);
    }

    public void removeListener(Connector listener) {
        this.server.removeConnector(listener);
    }

    public void addContext(AbstractHandlerContainer context) {
        this.contextHandlerCollection.addHandler((Handler)context);
    }

    public void removeContext(AbstractHandlerContainer context) {
        this.contextHandlerCollection.removeHandler((Handler)context);
    }

    public InternalJAASJettyRealm addRealm(String realmName) {
        InternalJAASJettyRealm realm = (InternalJAASJettyRealm)this.realms.get(realmName);
        if (realm == null) {
            realm = new InternalJAASJettyRealm(realmName);
            this.realms.put(realmName, realm);
        } else {
            realm.addUse();
        }
        return realm;
    }

    public void removeRealm(String realmName) {
        InternalJAASJettyRealm realm = (InternalJAASJettyRealm)this.realms.get(realmName);
        if (realm != null && realm.removeUse() == 0) {
            this.realms.remove(realmName);
        }
    }

    public void addWebService(String contextPath, String[] virtualHosts, WebServiceContainer webServiceContainer, String securityRealmName, String realmName, String transportGuarantee, String authMethod, ClassLoader classLoader) throws Exception {
        InternalJAASJettyRealm internalJAASJettyRealm = securityRealmName == null ? null : this.addRealm(securityRealmName);
        JettyEJBWebServiceContext webServiceContext = new JettyEJBWebServiceContext(contextPath, webServiceContainer, internalJAASJettyRealm, realmName, transportGuarantee, authMethod, classLoader);
        webServiceContext.setVirtualHosts(virtualHosts);
        this.addContext((AbstractHandlerContainer)webServiceContext);
        webServiceContext.start();
        this.webServices.put(contextPath, webServiceContext);
    }

    public void removeWebService(String contextPath) {
        JettyEJBWebServiceContext webServiceContext = (JettyEJBWebServiceContext)((Object)this.webServices.remove(contextPath));
        String securityRealmName = webServiceContext.getSecurityRealmName();
        if (securityRealmName != null) {
            this.removeRealm(securityRealmName);
        }
        try {
            this.removeContext((AbstractHandlerContainer)webServiceContext);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void setRequestLog(RequestLog log) {
        this.requestLogHandler.setRequestLog(log);
    }

    public RequestLog getRequestLog() {
        return this.requestLogHandler.getRequestLog();
    }

    public void doStart() throws Exception {
        this.server.start();
    }

    public void doStop() {
        try {
            this.server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doFail() {
        try {
            this.server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((String)"Jetty Web Container", JettyContainerImpl.class);
        infoBuilder.addAttribute("objectName", String.class, false);
        infoBuilder.addReference("WebManager", WebManager.class);
        infoBuilder.addInterface(SoapHandler.class);
        infoBuilder.addInterface(JettyContainer.class);
        infoBuilder.addInterface(StatisticsProvider.class);
        infoBuilder.setConstructor(new String[]{"objectName", "WebManager"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

