/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty.interceptor;

import org.apache.geronimo.jetty.interceptor.BeforeAfter;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;

public class ThreadClassloaderBeforeAfter
implements BeforeAfter {
    private final BeforeAfter next;
    private final int threadIndex;
    private final int classLoaderIndex;
    private final ClassLoader classLoader;

    public ThreadClassloaderBeforeAfter(BeforeAfter next, int threadIndex, int classLoaderIndex, ClassLoader classLoader) {
        this.next = next;
        this.threadIndex = threadIndex;
        this.classLoaderIndex = classLoaderIndex;
        this.classLoader = classLoader;
    }

    public void before(Object[] context, HttpRequest httpRequest, HttpResponse httpResponse) {
        Thread thread = Thread.currentThread();
        context[this.threadIndex] = thread;
        context[this.classLoaderIndex] = thread.getContextClassLoader();
        thread.setContextClassLoader(this.classLoader);
        if (this.next != null) {
            this.next.before(context, httpRequest, httpResponse);
        }
    }

    public void after(Object[] context, HttpRequest httpRequest, HttpResponse httpResponse) {
        if (this.next != null) {
            this.next.after(context, httpRequest, httpResponse);
        }
        ((Thread)context[this.threadIndex]).setContextClassLoader((ClassLoader)context[this.classLoaderIndex]);
    }
}

