/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws;

import java.lang.annotation.Annotation;
import javax.naming.NamingException;
import javax.xml.ws.WebServiceContext;
import org.apache.geronimo.jaxws.JNDIResolver;
import org.apache.geronimo.jaxws.annotations.AnnotationProcessor;
import org.apache.geronimo.jaxws.annotations.EJBAnnotationHandler;
import org.apache.geronimo.jaxws.annotations.InjectionException;
import org.apache.geronimo.jaxws.annotations.ResourceAnnotationHandler;
import org.apache.geronimo.jaxws.annotations.WebServiceRefAnnotationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSAnnotationProcessor
extends AnnotationProcessor {
    private JNDIResolver jndiResolver;
    private WebServiceContext context;

    public JAXWSAnnotationProcessor(JNDIResolver jndiResolver, WebServiceContext context) {
        this.jndiResolver = jndiResolver;
        this.context = context;
        this.registerHandler(new JAXWSResourceAnnotationHandler());
        this.registerHandler(new JAXWSEJBAnnotationHandler());
        this.registerHandler(new JAXWSWebServiceRefAnnotationHandler());
    }

    private Object lookupJNDI(String name, Class<?> type) throws InjectionException {
        try {
            return this.jndiResolver.resolve(name, type);
        }
        catch (NamingException e) {
            throw new InjectionException("JNDI injection failed for resource '" + name + "'", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JAXWSWebServiceRefAnnotationHandler
    extends WebServiceRefAnnotationHandler {
        private JAXWSWebServiceRefAnnotationHandler() {
        }

        @Override
        public Object getAnnotationValue(Annotation annotation, String name, Class<?> type) throws InjectionException {
            return JAXWSAnnotationProcessor.this.lookupJNDI(name, type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JAXWSEJBAnnotationHandler
    extends EJBAnnotationHandler {
        private JAXWSEJBAnnotationHandler() {
        }

        @Override
        public Object getAnnotationValue(Annotation annotation, String name, Class<?> type) throws InjectionException {
            return JAXWSAnnotationProcessor.this.lookupJNDI(name, type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JAXWSResourceAnnotationHandler
    extends ResourceAnnotationHandler {
        private JAXWSResourceAnnotationHandler() {
        }

        @Override
        public Object getAnnotationValue(Annotation annotation, String name, Class<?> type) throws InjectionException {
            if (WebServiceContext.class.isAssignableFrom(type)) {
                return type.cast(JAXWSAnnotationProcessor.this.context);
            }
            return JAXWSAnnotationProcessor.this.lookupJNDI(name, type);
        }
    }
}

