/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingType;
import javax.xml.ws.WebServiceProvider;

public class JAXWSUtils {
    private static final Map<String, String> BINDING_MAP = new HashMap<String, String>();

    private JAXWSUtils() {
    }

    public static QName getPortType(Class seiClass) {
        WebService webService = seiClass.getAnnotation(WebService.class);
        if (webService != null) {
            String localName = webService.name();
            if (localName == null || localName.length() == 0) {
                localName = seiClass.getName();
            }
            String namespace = webService.targetNamespace();
            return new QName(JAXWSUtils.getNamespace(seiClass, namespace), localName);
        }
        return null;
    }

    public static String getBindingURI(String token) {
        if (token == null) {
            return BINDING_MAP.get("##SOAP11_HTTP");
        }
        if (token.startsWith("##")) {
            String uri = BINDING_MAP.get(token);
            if (uri == null) {
                throw new IllegalArgumentException("Unsupported binding token: " + token);
            }
            return uri;
        }
        return token;
    }

    public static boolean isWebService(Class clazz) {
        return (clazz.isAnnotationPresent(WebService.class) || clazz.isAnnotationPresent(WebServiceProvider.class)) && JAXWSUtils.isProperWebService(clazz);
    }

    public static boolean isWebServiceProvider(Class clazz) {
        return clazz.isAnnotationPresent(WebServiceProvider.class) && JAXWSUtils.isProperWebService(clazz);
    }

    private static boolean isProperWebService(Class clazz) {
        int modifiers = clazz.getModifiers();
        return Modifier.isPublic(modifiers) && !Modifier.isFinal(modifiers) && !Modifier.isAbstract(modifiers);
    }

    public static String getServiceName(Class clazz) {
        return JAXWSUtils.getServiceQName(clazz).getLocalPart();
    }

    private static String getServiceName(Class clazz, String name) {
        if (name == null || name.trim().length() == 0) {
            return clazz.getSimpleName() + "Service";
        }
        return name.trim();
    }

    private static String getPortName(Class clazz, String name, String portName) {
        if (portName == null || portName.trim().length() == 0) {
            if (name == null || name.trim().length() == 0) {
                return clazz.getSimpleName() + "Port";
            }
            return name + "Port";
        }
        return portName.trim();
    }

    private static String getNamespace(Class clazz, String namespace) {
        if (namespace == null || namespace.trim().length() == 0) {
            Package pkg = clazz.getPackage();
            if (pkg == null) {
                return null;
            }
            return JAXWSUtils.getNamespace(pkg.getName());
        }
        return namespace.trim();
    }

    private static String getNamespace(String packageName) {
        String[] tokens;
        if (packageName == null || packageName.length() == 0) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(packageName, ".");
        if (tokenizer.countTokens() == 0) {
            tokens = new String[]{};
        } else {
            tokens = new String[tokenizer.countTokens()];
            for (int i = tokenizer.countTokens() - 1; i >= 0; --i) {
                tokens[i] = tokenizer.nextToken();
            }
        }
        StringBuffer namespace = new StringBuffer("http://");
        String dot = "";
        for (int i = 0; i < tokens.length; ++i) {
            if (i == 1) {
                dot = ".";
            }
            namespace.append(dot + tokens[i]);
        }
        namespace.append('/');
        return namespace.toString();
    }

    private static QName getServiceQName(Class clazz, String namespace, String name) {
        return new QName(JAXWSUtils.getNamespace(clazz, namespace), JAXWSUtils.getServiceName(clazz, name));
    }

    public static QName getServiceQName(Class clazz) {
        WebService webService = clazz.getAnnotation(WebService.class);
        if (webService == null) {
            WebServiceProvider webServiceProvider = clazz.getAnnotation(WebServiceProvider.class);
            if (webServiceProvider == null) {
                throw new IllegalArgumentException("The " + clazz.getName() + " is not annotated");
            }
            return JAXWSUtils.getServiceQName(clazz, webServiceProvider.targetNamespace(), webServiceProvider.serviceName());
        }
        return JAXWSUtils.getServiceQName(clazz, webService.targetNamespace(), webService.serviceName());
    }

    private static QName getPortQName(Class clazz, String namespace, String name, String portName) {
        return new QName(JAXWSUtils.getNamespace(clazz, namespace), JAXWSUtils.getPortName(clazz, name, portName));
    }

    public static QName getPortQName(Class clazz) {
        WebService webService = clazz.getAnnotation(WebService.class);
        if (webService == null) {
            WebServiceProvider webServiceProvider = clazz.getAnnotation(WebServiceProvider.class);
            if (webServiceProvider == null) {
                throw new IllegalArgumentException("The " + clazz.getName() + " is not annotated");
            }
            return JAXWSUtils.getPortQName(clazz, webServiceProvider.targetNamespace(), null, webServiceProvider.portName());
        }
        return JAXWSUtils.getPortQName(clazz, webService.targetNamespace(), webService.name(), webService.portName());
    }

    public static String getName(Class clazz) {
        WebService webService = clazz.getAnnotation(WebService.class);
        if (webService == null) {
            WebServiceProvider webServiceProvider = clazz.getAnnotation(WebServiceProvider.class);
            if (webServiceProvider == null) {
                throw new IllegalArgumentException("The " + clazz.getName() + " is not annotated");
            }
            return clazz.getSimpleName();
        }
        String sei = webService.endpointInterface();
        if (sei == null || sei.trim().length() == 0) {
            return JAXWSUtils.getName(clazz, webService.name());
        }
        try {
            Class<?> seiClass = clazz.getClassLoader().loadClass(sei.trim());
            return JAXWSUtils.getNameFromSEI(seiClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load SEI class: " + sei, e);
        }
    }

    private static String getNameFromSEI(Class seiClass) {
        WebService webService = seiClass.getAnnotation(WebService.class);
        if (webService == null) {
            throw new IllegalArgumentException("The " + seiClass.getName() + " is not annotated");
        }
        return JAXWSUtils.getName(seiClass, webService.name());
    }

    private static String getName(Class clazz, String name) {
        if (name == null || name.trim().length() == 0) {
            return clazz.getSimpleName();
        }
        return name.trim();
    }

    private static String getWsdlLocation(Class clazz) {
        WebService webService = clazz.getAnnotation(WebService.class);
        if (webService == null) {
            WebServiceProvider webServiceProvider = clazz.getAnnotation(WebServiceProvider.class);
            if (webServiceProvider == null) {
                return "";
            }
            return webServiceProvider.wsdlLocation().trim();
        }
        return webService.wsdlLocation().trim();
    }

    private static String getServiceInterface(Class clazz) {
        WebService webService = clazz.getAnnotation(WebService.class);
        if (webService == null) {
            return "";
        }
        if (webService.endpointInterface() == null || webService.endpointInterface().trim().equals("")) {
            return "";
        }
        return webService.endpointInterface().trim();
    }

    public static String getServiceWsdlLocation(Class clazz, ClassLoader loader) {
        String wsdlLocation = JAXWSUtils.getWsdlLocation(clazz);
        if (wsdlLocation != null && !wsdlLocation.equals("")) {
            return wsdlLocation;
        }
        String serviceInterfaceClassName = JAXWSUtils.getServiceInterface(clazz);
        if (serviceInterfaceClassName != null && !serviceInterfaceClassName.equals("")) {
            try {
                Class<?> serviceInterfaceClass = loader.loadClass(serviceInterfaceClassName);
                return JAXWSUtils.getWsdlLocation(serviceInterfaceClass);
            }
            catch (Exception e) {
                return "";
            }
        }
        return "";
    }

    public static boolean containsWsdlLocation(Class clazz, ClassLoader loader) {
        String wsdlLocSEIFromAnnotation = JAXWSUtils.getServiceWsdlLocation(clazz, loader);
        return wsdlLocSEIFromAnnotation != null && !wsdlLocSEIFromAnnotation.equals("");
    }

    public static String getBindingURIFromAnnot(Class clazz, ClassLoader loader) {
        BindingType bindingType = clazz.getAnnotation(BindingType.class);
        if (bindingType == null) {
            return "";
        }
        return bindingType.value();
    }

    static {
        BINDING_MAP.put("##SOAP11_HTTP", "http://schemas.xmlsoap.org/wsdl/soap/http");
        BINDING_MAP.put("##SOAP12_HTTP", "http://www.w3.org/2003/05/soap/bindings/HTTP/");
        BINDING_MAP.put("##SOAP11_HTTP_MTOM", "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
        BINDING_MAP.put("##SOAP12_HTTP_MTOM", "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
        BINDING_MAP.put("##XML_HTTP", "http://www.w3.org/2004/08/wsdl/http");
    }
}

