/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.builder;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.xml.ws.WebServiceContext;
import org.apache.geronimo.j2ee.annotation.Holder;
import org.apache.geronimo.j2ee.annotation.Injection;
import org.apache.geronimo.j2ee.annotation.ReferenceType;
import org.apache.xbean.finder.ClassFinder;

public class WebServiceContextAnnotationHelper {
    public static final String BINDING_WEBSERVICE_CONTEXR_JNDI_NAME = "comp/env/WebServiceContext";

    public static void addWebServiceContextInjections(Holder holder, Class<?> clazz) {
        ArrayList classes = new ArrayList();
        while (clazz != Object.class) {
            classes.add(clazz);
            clazz = clazz.getSuperclass();
        }
        WebServiceContextAnnotationHelper.addWebServiceContextInjections(holder, new ClassFinder(classes));
    }

    public static void addWebServiceContextInjections(Holder holder, ClassFinder finder) {
        List fields = finder.findAnnotatedFields(Resource.class);
        for (Field field : fields) {
            Resource resource = field.getAnnotation(Resource.class);
            Class<?> type = WebServiceContextAnnotationHelper.getInjectionType(resource.type(), null, field);
            if (WebServiceContext.class != type) continue;
            holder.addInjection(field.getDeclaringClass().getName(), new Injection(field.getDeclaringClass().getName(), WebServiceContextAnnotationHelper.getInjectionName(null, field), BINDING_WEBSERVICE_CONTEXR_JNDI_NAME, ReferenceType.RESOURCE_ENV));
        }
        List methods = finder.findAnnotatedMethods(Resource.class);
        for (Method method : methods) {
            Resource resource = method.getAnnotation(Resource.class);
            Class<?> type = WebServiceContextAnnotationHelper.getInjectionType(resource.type(), method, null);
            if (WebServiceContext.class != type) continue;
            holder.addInjection(method.getDeclaringClass().getName(), new Injection(method.getDeclaringClass().getName(), WebServiceContextAnnotationHelper.getInjectionName(method, null), BINDING_WEBSERVICE_CONTEXR_JNDI_NAME, ReferenceType.RESOURCE_ENV));
        }
    }

    private static Class<?> getInjectionType(Class<?> type, Method method, Field field) {
        if (type == null || Object.class == type) {
            if (field != null) {
                return field.getType();
            }
            if (method != null) {
                return method.getParameterTypes()[0];
            }
            throw new IllegalArgumentException("You must supply exactly one of Method, Field");
        }
        return type;
    }

    private static String getInjectionName(Method method, Field field) {
        if (method != null) {
            String injectionJavaType = method.getName().substring(3);
            StringBuilder stringBuilder = new StringBuilder(injectionJavaType);
            stringBuilder.setCharAt(0, Character.toLowerCase(stringBuilder.charAt(0)));
            return stringBuilder.toString();
        }
        if (field != null) {
            return field.getName();
        }
        throw new IllegalArgumentException("You must supply exactly one of Method, Field");
    }
}

