/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.builder;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.Deployable;
import org.apache.geronimo.deployment.DeployableBundle;
import org.apache.geronimo.deployment.DeployableJarFile;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.jaxws.PortInfo;
import org.apache.geronimo.jaxws.builder.AdvancedWARWebServiceFinder;
import org.apache.geronimo.jaxws.builder.SimpleWARWebServiceFinder;
import org.apache.geronimo.jaxws.builder.WebServiceFinder;
import org.apache.geronimo.kernel.classloader.TemporaryClassLoader;
import org.apache.geronimo.kernel.util.FileUtils;
import org.apache.geronimo.kernel.util.JarUtils;
import org.apache.geronimo.kernel.util.NestedJarFile;
import org.apache.geronimo.kernel.util.UnpackedJarFile;
import org.apache.xbean.finder.BundleAnnotationFinder;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xbean.osgi.bundle.util.BundleClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WARWebServiceFinder
implements WebServiceFinder {
    private static final Logger LOG = LoggerFactory.getLogger(WARWebServiceFinder.class);
    private static final WebServiceFinder webServiceFinder = WARWebServiceFinder.getWebServiceFinder();

    private static WebServiceFinder getWebServiceFinder() {
        boolean useSimpleFinder = Boolean.getBoolean("org.apache.geronimo.jaxws.builder.useSimpleFinder");
        WebServiceFinder webServiceFinder = useSimpleFinder ? new SimpleWARWebServiceFinder() : new AdvancedWARWebServiceFinder();
        return webServiceFinder;
    }

    @Override
    public Map<String, PortInfo> discoverWebServices(Module module, boolean isEJB, Map correctedPortLocations) throws DeploymentException {
        return webServiceFinder.discoverWebServices(module, isEJB, correctedPortLocations);
    }

    static List<Class> discoverWebServices(Module module, Bundle bundle, boolean isEJB) throws DeploymentException {
        Deployable deployable = module.getDeployable();
        if (deployable instanceof DeployableJarFile) {
            return WARWebServiceFinder.discoverWebServices(((DeployableJarFile)deployable).getJarFile(), isEJB, (ClassLoader)new BundleClassLoader(bundle));
        }
        if (deployable instanceof DeployableBundle) {
            return WARWebServiceFinder.discoverWebServices(((DeployableBundle)deployable).getBundle(), isEJB);
        }
        throw new DeploymentException("Unsupported deployable: " + deployable.getClass());
    }

    static List<Class> discoverWebServices(Bundle bundle, boolean isEJB) throws DeploymentException {
        LOG.debug("Discovering web service classes");
        ServiceReference sr = bundle.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = (PackageAdmin)bundle.getBundleContext().getService(sr);
        try {
            BundleAnnotationFinder classFinder = new BundleAnnotationFinder(packageAdmin, bundle);
            ArrayList<Class> classes = new ArrayList<Class>();
            classes.addAll(classFinder.findAnnotatedClasses(WebService.class));
            classes.addAll(classFinder.findAnnotatedClasses(WebServiceProvider.class));
            ArrayList<Class> arrayList = classes;
            return arrayList;
        }
        catch (Exception e) {
            throw new DeploymentException("Error scanning for web service annotations in bundle", (Throwable)e);
        }
        finally {
            bundle.getBundleContext().ungetService(sr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Class> discoverWebServices(JarFile moduleFile, boolean isEJB, ClassLoader parentClassLoader) throws DeploymentException {
        File baseDir;
        LOG.debug("Discovering web service classes");
        File tmpDir = null;
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (isEJB) {
            File jarFile = new File(moduleFile.getName());
            try {
                urlList.add(jarFile.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new DeploymentException((Throwable)e);
            }
        }
        if (moduleFile instanceof UnpackedJarFile) {
            baseDir = ((UnpackedJarFile)moduleFile).getBaseDir();
        } else if (moduleFile instanceof NestedJarFile && ((NestedJarFile)moduleFile).isUnpacked()) {
            baseDir = new File(moduleFile.getName());
        } else {
            try {
                tmpDir = FileUtils.createTempDir();
                JarFile module = new JarFile(moduleFile.getName());
                JarUtils.unzipToDirectory((ZipFile)module, (File)tmpDir);
            }
            catch (IOException e) {
                if (tmpDir != null) {
                    FileUtils.recursiveDelete((File)tmpDir);
                }
                throw new DeploymentException("Failed to expand the module archive", (Throwable)e);
            }
            baseDir = tmpDir;
        }
        Enumeration<JarEntry> jarEnum = moduleFile.entries();
        while (jarEnum.hasMoreElements()) {
            JarEntry entry = jarEnum.nextElement();
            String name = entry.getName();
            if (name.equals("WEB-INF/classes/")) {
                File classesDir = new File(baseDir, "WEB-INF/classes/");
                try {
                    urlList.add(0, classesDir.toURI().toURL());
                }
                catch (MalformedURLException e) {}
                continue;
            }
            if (!name.startsWith("WEB-INF/lib/") || !name.endsWith(".jar")) continue;
            File jarFile = new File(baseDir, name);
            try {
                urlList.add(jarFile.toURI().toURL());
            }
            catch (MalformedURLException e) {}
        }
        URL[] urls = urlList.toArray(new URL[urlList.size()]);
        try {
            TemporaryClassLoader tempClassLoader = new TemporaryClassLoader(urls, parentClassLoader);
            ArrayList<Class> classes = new ArrayList<Class>();
            for (URL url : urlList) {
                try {
                    ClassFinder classFinder = new ClassFinder((ClassLoader)tempClassLoader, Collections.singletonList(url));
                    classes.addAll(classFinder.findAnnotatedClasses(WebService.class));
                    classes.addAll(classFinder.findAnnotatedClasses(WebServiceProvider.class));
                }
                catch (Exception e) {
                    LOG.warn("Fail to search Web Service in jar [" + url + "]", (Throwable)e);
                }
            }
            ArrayList<Class> arrayList = classes;
            return arrayList;
        }
        finally {
            if (tmpDir != null) {
                FileUtils.recursiveDelete((File)tmpDir);
            }
        }
    }
}

