/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jaxws.builder;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.Deployable;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.j2ee.annotation.Holder;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.j2ee.deployment.WebServiceBuilder;
import org.apache.geronimo.jaxws.JAXWSUtils;
import org.apache.geronimo.jaxws.PortInfo;
import org.apache.geronimo.jaxws.annotations.AnnotationHolder;
import org.apache.geronimo.jaxws.builder.WebServiceContextAnnotationHelper;
import org.apache.geronimo.jaxws.builder.WebServiceFinder;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.repository.Environment;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JAXWSServiceBuilder
implements WebServiceBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(JAXWSServiceBuilder.class);
    protected final Environment defaultEnvironment;
    protected WebServiceFinder webServiceFinder;

    public JAXWSServiceBuilder(Environment defaultEnvironment) {
        this.defaultEnvironment = defaultEnvironment;
    }

    protected void setWebServiceFinder(WebServiceFinder finder) {
        this.webServiceFinder = finder;
    }

    protected String getKey() {
        return this.getClass().getName();
    }

    public void findWebServices(Module module, boolean isEJB, Map servletLocations, Environment environment, Map sharedContext) throws DeploymentException {
        Map<String, PortInfo> portMap = null;
        String path = isEJB ? "META-INF/webservices.xml" : "WEB-INF/webservices.xml";
        Deployable deployable = module.getDeployable();
        URL wsDDUrl = deployable.getResource(path);
        if (wsDDUrl != null) {
            InputStream in;
            try {
                in = wsDDUrl.openStream();
            }
            catch (IOException e) {
                throw new DeploymentException("Failed to parse " + path, (Throwable)e);
            }
            portMap = this.parseWebServiceDescriptor(in, wsDDUrl, deployable, isEJB, servletLocations);
        } else {
            portMap = this.discoverWebServices(module, isEJB, servletLocations);
        }
        if (portMap != null && !portMap.isEmpty()) {
            EnvironmentBuilder.mergeEnvironments((Environment)environment, (Environment)this.defaultEnvironment);
            sharedContext.put(this.getKey(), portMap);
        }
    }

    private Map<String, PortInfo> discoverWebServices(Module module, boolean isEJB, Map correctedPortLocations) throws DeploymentException {
        if (this.webServiceFinder == null) {
            throw new DeploymentException("WebServiceFinder not configured");
        }
        return this.webServiceFinder.discoverWebServices(module, isEJB, correctedPortLocations);
    }

    protected abstract Map<String, PortInfo> parseWebServiceDescriptor(InputStream var1, URL var2, Deployable var3, boolean var4, Map var5) throws DeploymentException;

    public boolean configurePOJO(GBeanData targetGBean, String servletName, Module module, String servletClassName, DeploymentContext context) throws DeploymentException {
        Map sharedContext = ((WebModule)module).getSharedContext();
        Map portInfoMap = (Map)sharedContext.get(this.getKey());
        if (portInfoMap == null) {
            return false;
        }
        PortInfo portInfo = (PortInfo)portInfoMap.get(servletName);
        if (portInfo == null) {
            return false;
        }
        Bundle bundle = context.getDeploymentBundle();
        Class<?> servletClass = this.loadClass(servletClassName, bundle);
        if (!JAXWSUtils.isWebService(servletClass)) {
            return false;
        }
        Map componentContext = null;
        Holder moduleHolder = null;
        try {
            GBeanData moduleGBean = context.getGBeanInstance(context.getModuleName());
            componentContext = (Map)moduleGBean.getAttribute("componentContext");
            moduleHolder = (Holder)moduleGBean.getAttribute("holder");
        }
        catch (GBeanNotFoundException e) {
            LOG.warn("ModuleGBean not found. JNDI resource injection will not work.");
        }
        AnnotationHolder serviceHolder = (AnnotationHolder)sharedContext.get(WebServiceContextAnnotationHelper.class.getName());
        if (serviceHolder == null) {
            serviceHolder = new AnnotationHolder(moduleHolder);
            sharedContext.put(WebServiceContextAnnotationHelper.class.getName(), serviceHolder);
        }
        WebServiceContextAnnotationHelper.addWebServiceContextInjections((Holder)serviceHolder, servletClass);
        String location = portInfo.getLocation();
        LOG.info("Configuring JAX-WS Web Service: " + servletName + " at " + location);
        AbstractName containerFactoryName = context.getNaming().createChildName(targetGBean.getAbstractName(), this.getContainerFactoryGBeanInfo().getName(), "GBean");
        GBeanData containerFactoryData = new GBeanData(containerFactoryName, this.getContainerFactoryGBeanInfo());
        containerFactoryData.setAttribute("portInfo", (Object)portInfo);
        containerFactoryData.setAttribute("endpointClassName", (Object)servletClassName);
        containerFactoryData.setAttribute("componentContext", (Object)componentContext);
        containerFactoryData.setAttribute("holder", (Object)serviceHolder);
        containerFactoryData.setAttribute("contextRoot", (Object)((WebModule)module).getContextRoot());
        try {
            context.addGBean(containerFactoryData);
        }
        catch (GBeanAlreadyExistsException e) {
            throw new DeploymentException("Could not add web service container factory gbean", (Throwable)e);
        }
        targetGBean.setReferencePattern("WebServiceContainerFactory", containerFactoryName);
        targetGBean.setAttribute("pojoClassName", (Object)"java.lang.Object");
        if (context instanceof EARContext) {
            containerFactoryData.setReferencePattern("TransactionManager", ((EARContext)context).getTransactionManagerName());
        }
        this.initialize(containerFactoryData, servletClass, portInfo, module);
        return true;
    }

    protected abstract GBeanInfo getContainerFactoryGBeanInfo();

    public boolean configureEJB(GBeanData targetGBean, String ejbName, Module module, Map sharedContext, Bundle bundle) throws DeploymentException {
        Map portInfoMap = (Map)sharedContext.get(this.getKey());
        if (portInfoMap == null) {
            return false;
        }
        PortInfo portInfo = (PortInfo)portInfoMap.get(ejbName);
        if (portInfo == null) {
            return false;
        }
        String beanClassName = (String)targetGBean.getAttribute("ejbClass");
        Class<?> beanClass = this.loadClass(beanClassName, bundle);
        if (!JAXWSUtils.isWebService(beanClass)) {
            return false;
        }
        String location = portInfo.getLocation();
        if (location == null) {
            throw new DeploymentException("Endpoint URI for EJB WebService is missing");
        }
        LOG.info("Configuring EJB JAX-WS Web Service: " + ejbName + " at " + location);
        targetGBean.setAttribute("portInfo", (Object)portInfo);
        this.initialize(targetGBean, beanClass, portInfo, module);
        return true;
    }

    protected void initialize(GBeanData targetGBean, Class wsClass, PortInfo info, Module module) throws DeploymentException {
    }

    Class<?> loadClass(String className, Bundle bundle) throws DeploymentException {
        try {
            return bundle.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            throw new DeploymentException("Unable to load Web Service class: " + className, (Throwable)ex);
        }
    }

    protected boolean isWsdlSet(PortInfo portInfo, Class serviceClass) {
        return portInfo.getWsdlFile() != null && !portInfo.getWsdlFile().trim().equals("") || JAXWSUtils.containsWsdlLocation((Class)serviceClass, (ClassLoader)serviceClass.getClassLoader());
    }

    protected boolean isHTTPBinding(PortInfo portInfo, Class serviceClass) {
        String bindingURI = "";
        if (portInfo.getProtocolBinding() != null) {
            bindingURI = JAXWSUtils.getBindingURI((String)portInfo.getProtocolBinding());
        }
        String bindingURIFromAnnot = JAXWSUtils.getBindingURIFromAnnot((Class)serviceClass, (ClassLoader)serviceClass.getClassLoader());
        if (bindingURI != null && !bindingURI.trim().equals("")) {
            return bindingURI.equals("http://www.w3.org/2004/08/wsdl/http");
        }
        if (bindingURIFromAnnot != null && !bindingURIFromAnnot.trim().equals("")) {
            return bindingURIFromAnnot.equals("http://www.w3.org/2004/08/wsdl/http");
        }
        return false;
    }
}

