/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jasper.internal;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import org.apache.geronimo.jasper.TldProvider;
import org.apache.geronimo.jasper.TldRegistry;
import org.apache.geronimo.system.configuration.DependencyManager;
import org.apache.xbean.osgi.bundle.util.BundleResourceFinder;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TldRegistryImpl
implements TldRegistry,
BundleTrackerCustomizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TldRegistryImpl.class);
    private Map<Bundle, Collection<TldProvider.TldEntry>> map = new ConcurrentHashMap<Bundle, Collection<TldProvider.TldEntry>>();
    private final BundleContext bundleContext;

    public TldRegistryImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public Collection<TldProvider.TldEntry> getTls() {
        ArrayList<TldProvider.TldEntry> allTlds = new ArrayList<TldProvider.TldEntry>();
        for (Collection<TldProvider.TldEntry> tlds : this.map.values()) {
            allTlds.addAll(tlds);
        }
        return allTlds;
    }

    @Override
    public Collection<TldProvider.TldEntry> getTlds(Bundle bundle) {
        Collection<TldProvider.TldEntry> tlds = this.map.get(bundle);
        return tlds == null ? Collections.emptyList() : tlds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Bundle> getDependentBundles(Bundle bundle) {
        String contextPath;
        HashSet<Bundle> dependentBundles = new HashSet<Bundle>();
        ServiceReference serviceReference = this.bundleContext.getServiceReference(DependencyManager.class.getName());
        if (serviceReference != null) {
            DependencyManager dependencyManager = (DependencyManager)this.bundleContext.getService(serviceReference);
            try {
                dependentBundles.addAll(dependencyManager.getFullDependentBundles(Long.valueOf(bundle.getBundleId())));
            }
            finally {
                this.bundleContext.ungetService(serviceReference);
            }
        }
        if ((contextPath = (String)bundle.getHeaders().get("Web-ContextPath")) != null) {
            LinkedHashSet wiredBundles = BundleUtils.getWiredBundles((Bundle)bundle);
            dependentBundles.addAll(wiredBundles);
        }
        return dependentBundles;
    }

    @Override
    public Collection<TldProvider.TldEntry> getDependentTlds(Bundle bundle) {
        ArrayList<TldProvider.TldEntry> allTlds = new ArrayList<TldProvider.TldEntry>();
        Set<Bundle> dependentBundles = this.getDependentBundles(bundle);
        for (Bundle dependentBundle : dependentBundles) {
            Collection<TldProvider.TldEntry> tlds = this.map.get(dependentBundle);
            if (tlds == null) continue;
            allTlds.addAll(tlds);
        }
        return allTlds;
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        Collection<TldProvider.TldEntry> tlds = this.scanBundle(bundle);
        this.map.put(bundle, tlds);
        return bundle;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        this.map.remove(bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<TldProvider.TldEntry> scanBundle(Bundle bundle) {
        ServiceReference reference = this.bundleContext.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = (PackageAdmin)this.bundleContext.getService(reference);
        try {
            BundleResourceFinder resourceFinder = new BundleResourceFinder(packageAdmin, bundle, "META-INF/", ".tld");
            TldResourceFinderCallback callback = new TldResourceFinderCallback();
            resourceFinder.find((BundleResourceFinder.ResourceFinderCallback)callback);
            Collection<TldProvider.TldEntry> collection = callback.getTlds();
            return collection;
        }
        catch (Exception e) {
            LOGGER.warn("Error scanning bundle for JSP tag libraries", (Throwable)e);
            List<TldProvider.TldEntry> list = Collections.emptyList();
            return list;
        }
        finally {
            this.bundleContext.ungetService(reference);
        }
    }

    private static class TldResourceFinderCallback
    implements BundleResourceFinder.ResourceFinderCallback,
    TldProvider {
        private final List<TldProvider.TldEntry> tlds = new ArrayList<TldProvider.TldEntry>();

        private TldResourceFinderCallback() {
        }

        @Override
        public Collection<TldProvider.TldEntry> getTlds() {
            return this.tlds;
        }

        public boolean foundInDirectory(Bundle bundle, String basePath, URL url) throws Exception {
            LOGGER.debug("Found {} TLD in bundle {}", (Object)url, (Object)bundle);
            this.tlds.add(new TldProvider.TldEntry(bundle, url));
            return true;
        }

        public boolean foundInJar(Bundle bundle, String jarName, ZipEntry entry, InputStream in) throws Exception {
            URL jarURL = bundle.getEntry(jarName);
            URL url = new URL("jar:" + jarURL.toString() + "!/" + entry.getName());
            LOGGER.debug("Found {} TLD in bundle {}", (Object)url, (Object)bundle);
            this.tlds.add(new TldProvider.TldEntry(bundle, url, jarURL));
            return false;
        }
    }
}

