/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jasper;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.jasper.TldProvider;
import org.apache.xbean.osgi.bundle.util.BundleResourceFinder;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
public class TldRegistration
implements GBeanLifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(TldRegistration.class);
    private Bundle bundle;
    private String packageNameList;

    public TldRegistration(@ParamSpecial(type=SpecialAttributeType.bundle) Bundle bundle, @ParamAttribute(name="packageNameList") String packageNameList) throws Exception {
        this.bundle = bundle;
        this.packageNameList = packageNameList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() throws Exception {
        ServiceReference reference = this.bundle.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = (PackageAdmin)this.bundle.getBundleContext().getService(reference);
        try {
            this.registerTlds(packageAdmin);
        }
        finally {
            this.bundle.getBundleContext().ungetService(reference);
        }
    }

    private void registerTlds(PackageAdmin packageAdmin) throws Exception {
        String[] packageNames;
        for (String packageName : packageNames = this.packageNameList.split(",")) {
            ExportedPackage exportedPackage = packageAdmin.getExportedPackage(packageName.trim());
            if (exportedPackage == null) {
                LOGGER.warn("Package {} is not currently exported by any bundle", (Object)packageName);
                continue;
            }
            Bundle exportingBundle = exportedPackage.getExportingBundle();
            BundleResourceFinder resourceFinder = new BundleResourceFinder(packageAdmin, exportingBundle, "META-INF/", ".tld");
            TldResourceFinderCallback callback = new TldResourceFinderCallback();
            resourceFinder.find((BundleResourceFinder.ResourceFinderCallback)callback);
            if (callback.getTlds().isEmpty()) continue;
            exportingBundle.getBundleContext().registerService(TldProvider.class.getName(), (Object)callback, null);
        }
    }

    public void doFail() {
    }

    public void doStop() throws Exception {
    }

    private class TldResourceFinderCallback
    implements BundleResourceFinder.ResourceFinderCallback,
    TldProvider {
        private List<TldProvider.TldEntry> tlds = new ArrayList<TldProvider.TldEntry>();

        private TldResourceFinderCallback() {
        }

        @Override
        public Collection<TldProvider.TldEntry> getTlds() {
            return this.tlds;
        }

        public void foundInDirectory(Bundle bundle, String basePath, URL url) throws Exception {
            LOGGER.debug("Found {} TLD in bundle {}", (Object)url, (Object)bundle);
            this.tlds.add(new TldProvider.TldEntry(bundle, url));
        }

        public void foundInJar(Bundle bundle, String jarName, ZipEntry entry, InputStream in) throws Exception {
            URL jarURL = bundle.getEntry(jarName);
            URL url = new URL("jar:" + jarURL.toString() + "!/" + entry.getName());
            LOGGER.debug("Found {} TLD in bundle {}", (Object)url, (Object)bundle);
            this.tlds.add(new TldProvider.TldEntry(bundle, url, jarURL));
        }
    }
}

