/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jasper.deployment;

import java.io.Closeable;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.Deployable;
import org.apache.geronimo.deployment.DeployableBundle;
import org.apache.geronimo.deployment.DeployableJarFile;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.j2ee.annotation.Holder;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilderExtension;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.jasper.JasperServletContextCustomizer;
import org.apache.geronimo.jasper.TldProvider;
import org.apache.geronimo.jasper.TldRegistry;
import org.apache.geronimo.jasper.deployment.BundleTldScanner;
import org.apache.geronimo.jasper.deployment.JarFileTldScanner;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.geronimo.web.info.ServletInfo;
import org.apache.geronimo.web.info.WebAppInfo;
import org.apache.geronimo.web25.deployment.AbstractWebModuleBuilder;
import org.apache.geronimo.web25.deployment.JspServletInfoProvider;
import org.apache.geronimo.web25.deployment.WebAppInfoBuilder;
import org.apache.openejb.jee.JaxbJavaee;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.JspConfig;
import org.apache.openejb.jee.JspPropertyGroup;
import org.apache.openejb.jee.Listener;
import org.apache.openejb.jee.Tag;
import org.apache.openejb.jee.Taglib;
import org.apache.openejb.jee.TldTaglib;
import org.apache.openejb.jee.WebApp;
import org.apache.xbean.finder.AbstractFinder;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xmlbeans.XmlObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean(j2eeType="ModuleBuilder")
public class JspModuleBuilderExtension
implements ModuleBuilderExtension,
JspServletInfoProvider {
    private static final Logger log = LoggerFactory.getLogger(JspModuleBuilderExtension.class);
    private final Environment defaultEnvironment;
    private final NamingBuilder namingBuilders;
    private final Set<String> excludedListenerNames = new HashSet<String>();
    private final ServletInfo defaultJspServletInfo;

    public JspModuleBuilderExtension(@ParamAttribute(name="defaultEnvironment") Environment defaultEnvironment, @ParamAttribute(name="excludedListenerNames") Collection<String> excludedListenerNames, @ParamAttribute(name="defaultJspServlet") WebAppInfo defaultJspServlet, @ParamReference(name="NamingBuilders", namingType="ModuleBuilder") NamingBuilder namingBuilders) {
        this.defaultEnvironment = defaultEnvironment;
        this.namingBuilders = namingBuilders;
        if (excludedListenerNames != null) {
            this.excludedListenerNames.addAll(excludedListenerNames);
        }
        if (defaultJspServlet == null || defaultJspServlet.servlets.size() != 1) {
            throw new IllegalArgumentException("Must supply exactly one default jsp servlet");
        }
        this.defaultJspServletInfo = (ServletInfo)defaultJspServlet.servlets.get(0);
    }

    public void createModule(Module module, Bundle bundle, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
    }

    public void createModule(Module module, Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment environment, Object moduleContextInfo, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
    }

    public void installModule(JarFile earFile, EARContext earContext, Module module, Collection configurationStores, ConfigurationStore targetConfigurationStore, Collection repository) throws DeploymentException {
    }

    public void initContext(EARContext earContext, Module module, Bundle bundle) throws DeploymentException {
    }

    public void addGBeans(EARContext earContext, Module module, Bundle bundle, Collection repository) throws DeploymentException {
        WebAppInfoBuilder webAppInfoBuilder;
        if (!(module instanceof WebModule)) {
            return;
        }
        EnvironmentBuilder.mergeEnvironments((Environment)module.getEnvironment(), (Environment)this.defaultEnvironment);
        WebModule webModule = (WebModule)module;
        WebApp webApp = (WebApp)webModule.getSpecDD();
        EARContext moduleContext = module.getEarContext();
        Map sharedContext = module.getSharedContext();
        GBeanData webAppData = (GBeanData)sharedContext.get("WEB_APP_DATA");
        AbstractName moduleName = module.getModuleName();
        HashMap<EARContext.Key, Object> buildingContext = new HashMap<EARContext.Key, Object>();
        buildingContext.put(NamingBuilder.GBEAN_NAME_KEY, moduleName);
        Holder holder = (Holder)NamingBuilder.INJECTION_KEY.get(sharedContext);
        buildingContext.put(NamingBuilder.INJECTION_KEY, holder);
        XmlObject jettyWebApp = (XmlObject)webModule.getVendorDD();
        HashSet<String> listenerNames = new HashSet<String>();
        Map<String, Bundle> tldLocationBundleMap = this.getTldFiles(webApp, webModule);
        LinkedHashSet<Class<?>> classes = this.getListenerClasses(webApp, webModule, tldLocationBundleMap, listenerNames);
        AbstractFinder originalClassFinder = webModule.getClassFinder();
        ClassFinder classFinder = new ClassFinder(new ArrayList(classes));
        webModule.setClassFinder((AbstractFinder)classFinder);
        this.namingBuilders.buildNaming((JndiConsumer)webApp, jettyWebApp, (Module)webModule, buildingContext);
        webModule.setClassFinder(originalClassFinder);
        GBeanInfo webAppGBeanInfo = webAppData.getGBeanInfo();
        if (webAppGBeanInfo.getReference("ContextCustomizer") != null) {
            AbstractName jspLifecycleName = moduleContext.getNaming().createChildName(moduleName, "jspLifecycleProvider", "GBean");
            GBeanData gbeanData = new GBeanData(jspLifecycleName, JasperServletContextCustomizer.class);
            gbeanData.setAttribute("holder", (Object)holder);
            try {
                moduleContext.addGBean(gbeanData);
            }
            catch (GBeanAlreadyExistsException e) {
                throw new DeploymentException("Duplicate jspLifecycleProvider", (Throwable)e);
            }
            webAppData.setReferencePattern("ContextCustomizer", jspLifecycleName);
        }
        if ((webAppInfoBuilder = (WebAppInfoBuilder)sharedContext.get("WEB_APP_INFO")) != null) {
            WebAppInfo webAppInfo = webAppInfoBuilder.getWebAppInfo();
            webAppInfo.listeners.addAll(listenerNames);
            ServletInfo jspServlet = webAppInfoBuilder.copy(this.defaultJspServletInfo);
            List jspConfigs = webApp.getJspConfig();
            ArrayList jspMappings = new ArrayList();
            for (JspConfig jspConfig : jspConfigs) {
                for (JspPropertyGroup propertyGroup : jspConfig.getJspPropertyGroup()) {
                    WebAppInfoBuilder.normalizeUrlPatterns((Collection)propertyGroup.getUrlPattern(), jspMappings);
                }
            }
            jspServlet.servletMappings.addAll(jspMappings);
            for (ServletInfo servletInfo : webAppInfo.servlets) {
                servletInfo.servletMappings.removeAll(jspMappings);
            }
            webAppInfo.servlets.add(jspServlet);
        } else {
            Object value;
            GBeanData jspServletData = (GBeanData)AbstractWebModuleBuilder.DEFAULT_JSP_SERVLET_KEY.get(sharedContext);
            if (jspServletData != null) {
                try {
                    moduleContext.addGBean(jspServletData);
                }
                catch (GBeanAlreadyExistsException e) {
                    throw new DeploymentException("jsp servlet already present", (Throwable)e);
                }
            }
            if ((value = webAppData.getAttribute("listenerClassNames")) instanceof Collection) {
                ((Collection)value).addAll(listenerNames);
            }
        }
    }

    public ServletInfo getJspServletInfo() {
        return this.defaultJspServletInfo;
    }

    private Map<String, Bundle> getTldFiles(WebApp webApp, WebModule webModule) throws DeploymentException {
        if (log.isDebugEnabled()) {
            log.debug("getTldFiles( " + webApp.toString() + "," + webModule.getName() + " ): Entry");
        }
        LinkedHashMap<String, Bundle> tldLocationBundleMap = new LinkedHashMap<String, Bundle>();
        Bundle webBundle = webModule.getEarContext().getDeploymentBundle();
        List jspConfigs = webApp.getJspConfig();
        for (JspConfig jspConfig : jspConfigs) {
            List taglibs = jspConfig.getTaglib();
            for (Taglib taglib : taglibs) {
                String uri = taglib.getTaglibUri().trim();
                String location = taglib.getTaglibLocation().trim();
                if (location.equals("")) continue;
                if (location.startsWith("/")) {
                    location = location.substring(1);
                }
                try {
                    URL targetUrl = webModule.getEarContext().getTargetURL(webModule.resolve(this.createURI(location)));
                    if (targetUrl == null) continue;
                    tldLocationBundleMap.put(targetUrl.toString(), webBundle);
                }
                catch (URISyntaxException use) {
                    throw new DeploymentException("Could not locate TLD file specified in <taglib>: URI: " + uri + " Location: " + location + " " + use.getMessage(), (Throwable)use);
                }
            }
        }
        for (URL tldURL : this.scanModule(webModule)) {
            tldLocationBundleMap.put(tldURL.toString(), webBundle);
        }
        tldLocationBundleMap.putAll(this.scanGlobalTlds(webModule.getEarContext().getDeploymentBundle()));
        if (log.isDebugEnabled()) {
            log.debug("getTldFiles() Exit: URL[" + tldLocationBundleMap.size() + "]: " + ((Object)tldLocationBundleMap).toString());
        }
        return tldLocationBundleMap;
    }

    private List<URL> scanModule(WebModule webModule) throws DeploymentException {
        Deployable deployable = webModule.getDeployable();
        if (deployable instanceof DeployableJarFile) {
            JarFileTldScanner scanner = new JarFileTldScanner();
            return scanner.scanModule(webModule);
        }
        if (deployable instanceof DeployableBundle) {
            BundleTldScanner scanner = new BundleTldScanner();
            return scanner.scanModule(webModule);
        }
        return Collections.emptyList();
    }

    private Map<String, Bundle> scanGlobalTlds(Bundle bundle) throws DeploymentException {
        BundleContext bundleContext = bundle.getBundleContext();
        ServiceReference reference = bundleContext.getServiceReference(TldRegistry.class.getName());
        HashMap<String, Bundle> tldLocationBundleMap = new HashMap<String, Bundle>();
        if (reference != null) {
            TldRegistry tldRegistry = (TldRegistry)bundleContext.getService(reference);
            for (TldProvider.TldEntry entry : tldRegistry.getDependentTlds(bundle)) {
                URL url = entry.getURL();
                tldLocationBundleMap.put(url.toString(), entry.getBundle());
            }
            bundleContext.ungetService(reference);
        }
        return tldLocationBundleMap;
    }

    private LinkedHashSet<Class<?>> getListenerClasses(WebApp webApp, WebModule webModule, Map<String, Bundle> tldLocationBundleMap, Set<String> listenerNames) throws DeploymentException {
        if (log.isDebugEnabled()) {
            log.debug("getListenerClasses( " + webApp.toString() + "," + '\n' + webModule.getName() + " ): Entry");
        }
        LinkedHashSet classes = new LinkedHashSet();
        try {
            for (Map.Entry<String, Bundle> entry : tldLocationBundleMap.entrySet()) {
                this.parseTldFile(new URL(entry.getKey()), entry.getValue(), classes, listenerNames);
            }
        }
        catch (MalformedURLException e) {
            throw new DeploymentException("Fail to parse the tld files", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("getListenerClasses() Exit: Classes[" + classes.size() + "]: " + classes.toString());
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseTldFile(URL url, Bundle bundle, LinkedHashSet<Class<?>> classes, Set<String> listenerNames) throws DeploymentException {
        if (log.isDebugEnabled()) {
            log.debug("parseTLDFile( " + url.toString() + " ): Entry");
        }
        try {
            Class clas;
            String className;
            TldTaglib tl;
            InputStream in = null;
            try {
                in = url.openStream();
                tl = (TldTaglib)JaxbJavaee.unmarshalTaglib(TldTaglib.class, (InputStream)in);
            }
            finally {
                IOUtils.close((Closeable)in);
            }
            for (Listener listener : tl.getListener()) {
                className = listener.getListenerClass();
                if (this.excludedListenerNames.contains(className)) continue;
                try {
                    for (clas = bundle.loadClass(className); clas != null; clas = clas.getSuperclass()) {
                        classes.add(clas);
                    }
                    listenerNames.add(className);
                }
                catch (ClassNotFoundException e) {
                    log.warn("JspModuleBuilderExtension: Could not load listener class: " + className + " mentioned in TLD file at " + url.toString());
                }
            }
            for (Tag tag : tl.getTag()) {
                className = tag.getTagClass();
                try {
                    for (clas = bundle.loadClass(className); clas != null; clas = clas.getSuperclass()) {
                        classes.add(clas);
                    }
                }
                catch (ClassNotFoundException e) {
                    log.warn("JspModuleBuilderExtension: Could not load tag class: " + className + " mentioned in TLD file at " + url.toString());
                }
            }
        }
        catch (Exception ioe) {
            throw new DeploymentException("Could not find TLD file at " + url.toString(), (Throwable)ioe);
        }
        if (log.isDebugEnabled()) {
            log.debug("parseTLDFile(): Exit");
        }
    }

    private URI createURI(String path) throws URISyntaxException {
        path = path.replaceAll(" ", "%20");
        return new URI(path);
    }
}

