/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceContexts;
import javax.persistence.PersistenceProperty;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotationHelper;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.PersistenceContextRef;
import org.apache.openejb.jee.Property;
import org.apache.xbean.finder.AbstractFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PersistenceContextAnnotationHelper
extends AnnotationHelper {
    private static final Logger log = LoggerFactory.getLogger(PersistenceContextAnnotationHelper.class);

    private PersistenceContextAnnotationHelper() {
    }

    public static void processAnnotations(JndiConsumer annotatedApp, AbstractFinder classFinder) throws DeploymentException {
        if (annotatedApp != null) {
            if (classFinder.isAnnotationPresent(PersistenceContexts.class)) {
                PersistenceContextAnnotationHelper.processPersistenceContexts(annotatedApp, classFinder);
            }
            if (classFinder.isAnnotationPresent(PersistenceContext.class)) {
                PersistenceContextAnnotationHelper.processPersistenceContext(annotatedApp, classFinder);
            }
        }
    }

    private static void processPersistenceContext(JndiConsumer annotatedApp, AbstractFinder classFinder) throws DeploymentException {
        PersistenceContext persistenceContext;
        log.debug("processPersistenceContext(): Entry: AnnotatedApp: " + annotatedApp.toString());
        List classeswithPersistenceContext = classFinder.findAnnotatedClasses(PersistenceContext.class);
        List methodswithPersistenceContext = classFinder.findAnnotatedMethods(PersistenceContext.class);
        List fieldswithPersistenceContext = classFinder.findAnnotatedFields(PersistenceContext.class);
        for (Class cls : classeswithPersistenceContext) {
            persistenceContext = cls.getAnnotation(PersistenceContext.class);
            if (persistenceContext == null) continue;
            PersistenceContextAnnotationHelper.addPersistenceContext(annotatedApp, persistenceContext, cls, null, null);
        }
        for (Method method : methodswithPersistenceContext) {
            persistenceContext = method.getAnnotation(PersistenceContext.class);
            if (persistenceContext == null) continue;
            PersistenceContextAnnotationHelper.addPersistenceContext(annotatedApp, persistenceContext, null, method, null);
        }
        for (Field field : fieldswithPersistenceContext) {
            persistenceContext = field.getAnnotation(PersistenceContext.class);
            if (persistenceContext == null) continue;
            PersistenceContextAnnotationHelper.addPersistenceContext(annotatedApp, persistenceContext, null, null, field);
        }
        log.debug("processPersistenceContext(): Exit: AnnotatedApp: " + annotatedApp.toString());
    }

    private static void processPersistenceContexts(JndiConsumer annotatedApp, AbstractFinder classFinder) throws DeploymentException {
        log.debug("processPersistenceContexts(): Entry");
        List classeswithPersistenceContexts = classFinder.findAnnotatedClasses(PersistenceContexts.class);
        ArrayList<PersistenceContext> persistenceContextList = new ArrayList<PersistenceContext>();
        for (Class cls : classeswithPersistenceContexts) {
            PersistenceContexts persistenceContexts = cls.getAnnotation(PersistenceContexts.class);
            if (persistenceContexts != null) {
                persistenceContextList.addAll(Arrays.asList(persistenceContexts.value()));
            }
            for (PersistenceContext persistenceContext : persistenceContextList) {
                PersistenceContextAnnotationHelper.addPersistenceContext(annotatedApp, persistenceContext, cls, null, null);
            }
            persistenceContextList.clear();
        }
        log.debug("processPersistenceContexts(): Exit");
    }

    private static void addPersistenceContext(JndiConsumer annotatedApp, PersistenceContext annotation, Class cls, Method method, Field field) {
        PersistenceProperty[] properties;
        log.debug("addPersistenceContext( [annotatedApp] " + annotatedApp.toString() + "," + '\n' + "[annotation] " + annotation.toString() + "," + '\n' + "[cls] " + (cls != null ? cls.getName() : null) + "," + '\n' + "[method] " + (method != null ? method.getName() : null) + "," + '\n' + "[field] " + (field != null ? field.getName() : null) + " ): Entry");
        String persistenceContextRefName = PersistenceContextAnnotationHelper.getName(annotation.name(), method, field);
        log.debug("addPersistenceContext(): PersistenceContextRefName: " + persistenceContextRefName);
        Collection persistenceContextRefs = annotatedApp.getPersistenceContextRef();
        for (PersistenceContextRef persistenceContextRef : persistenceContextRefs) {
            Set targets;
            if (!persistenceContextRef.getPersistenceContextRefName().trim().equals(persistenceContextRefName)) continue;
            if (!(method == null && field == null || PersistenceContextAnnotationHelper.hasTarget(method, field, targets = persistenceContextRef.getInjectionTarget()))) {
                persistenceContextRef.getInjectionTarget().add(PersistenceContextAnnotationHelper.configureInjectionTarget(method, field));
            }
            return;
        }
        PersistenceContextRef persistenceContextRef = new PersistenceContextRef();
        persistenceContextRef.setPersistenceContextRefName(persistenceContextRefName);
        String unitNameAnnotation = annotation.unitName();
        if (!unitNameAnnotation.isEmpty()) {
            persistenceContextRef.setPersistenceUnitName(unitNameAnnotation);
        }
        if (annotation.type() == PersistenceContextType.TRANSACTION) {
            persistenceContextRef.setPersistenceContextType(org.apache.openejb.jee.PersistenceContextType.TRANSACTION);
        } else if (annotation.type() == PersistenceContextType.EXTENDED) {
            persistenceContextRef.setPersistenceContextType(org.apache.openejb.jee.PersistenceContextType.EXTENDED);
        }
        for (PersistenceProperty property : properties = annotation.properties()) {
            Property prop = new Property();
            prop.setName(property.name());
            prop.setValue(property.value());
            persistenceContextRef.getPersistenceProperty().add(prop);
        }
        if (method != null || field != null) {
            persistenceContextRef.getInjectionTarget().add(PersistenceContextAnnotationHelper.configureInjectionTarget(method, field));
        }
        annotatedApp.getPersistenceContextRef().add(persistenceContextRef);
    }
}

