/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBs;
import javax.ejb.Local;
import javax.ejb.Remote;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotationHelper;
import org.apache.openejb.jee.EjbLocalRef;
import org.apache.openejb.jee.EjbRef;
import org.apache.openejb.jee.EjbReference;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.Text;
import org.apache.xbean.finder.AbstractFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EJBAnnotationHelper
extends AnnotationHelper {
    private static final Logger log = LoggerFactory.getLogger(EJBAnnotationHelper.class);

    private EJBAnnotationHelper() {
    }

    public static boolean annotationsPresent(AbstractFinder classFinder) {
        if (classFinder.isAnnotationPresent(EJB.class)) {
            return true;
        }
        return classFinder.isAnnotationPresent(EJBs.class);
    }

    public static void processAnnotations(JndiConsumer annotatedApp, AbstractFinder classFinder) throws Exception {
        if (annotatedApp != null) {
            EJBAnnotationHelper.processEJBs(annotatedApp, classFinder);
            EJBAnnotationHelper.processEJB(annotatedApp, classFinder);
        }
    }

    private static void processEJB(JndiConsumer annotatedApp, AbstractFinder classFinder) throws Exception {
        EJB ejb;
        log.debug("processEJB(): Entry: AnnotatedApp: " + annotatedApp.toString());
        List classesWithEJB = classFinder.findAnnotatedClasses(EJB.class);
        List methodsWithEJB = classFinder.findAnnotatedMethods(EJB.class);
        List fieldsWithEJB = classFinder.findAnnotatedFields(EJB.class);
        for (Class cls : classesWithEJB) {
            ejb = cls.getAnnotation(EJB.class);
            if (ejb == null) continue;
            EJBAnnotationHelper.addEJB(annotatedApp, ejb, cls, null, null);
        }
        for (Method method : methodsWithEJB) {
            ejb = method.getAnnotation(EJB.class);
            if (ejb == null) continue;
            EJBAnnotationHelper.addEJB(annotatedApp, ejb, null, method, null);
        }
        for (Field field : fieldsWithEJB) {
            ejb = field.getAnnotation(EJB.class);
            if (ejb == null) continue;
            EJBAnnotationHelper.addEJB(annotatedApp, ejb, null, null, field);
        }
        log.debug("processEJB(): Exit: AnnotatedApp: " + annotatedApp.toString());
    }

    private static void processEJBs(JndiConsumer annotatedApp, AbstractFinder classFinder) throws Exception {
        log.debug("processEJBs(): Entry");
        List classesWithEJBs = classFinder.findAnnotatedClasses(EJBs.class);
        ArrayList<EJB> ejbList = new ArrayList<EJB>();
        for (Class cls : classesWithEJBs) {
            EJBs ejbs = cls.getAnnotation(EJBs.class);
            if (ejbs != null) {
                ejbList.addAll(Arrays.asList(ejbs.value()));
            }
            for (EJB ejb : ejbList) {
                EJBAnnotationHelper.addEJB(annotatedApp, ejb, cls, null, null);
            }
            ejbList.clear();
        }
        log.debug("processEJBs(): Exit");
    }

    private static void addEJB(JndiConsumer annotatedApp, EJB annotation, Class cls, Method method, Field field) {
        String remoteRefName;
        String mappdedNameAnnotation;
        log.debug("addEJB( [annotatedApp] " + annotatedApp.toString() + "," + '\n' + "[annotation] " + annotation.toString() + "," + '\n' + "[cls] " + (cls != null ? cls.getName() : null) + "," + '\n' + "[method] " + (method != null ? method.getName() : null) + "," + '\n' + "[field] " + (field != null ? field.getName() : null) + " ): Entry");
        boolean localFlag = false;
        boolean remoteFlag = false;
        Class<Object> interfce = annotation.beanInterface();
        if (interfce.equals(Object.class)) {
            interfce = method != null ? method.getParameterTypes()[0] : (field != null ? field.getType() : null);
        }
        log.debug("addEJB(): interfce: " + interfce);
        if (interfce != null && !interfce.equals(Object.class)) {
            if (EJBHome.class.isAssignableFrom(interfce)) {
                for (Method m : interfce.getMethods()) {
                    if (!m.getName().startsWith("create")) continue;
                    interfce = m.getReturnType();
                    break;
                }
                remoteFlag = true;
            } else if (EJBLocalHome.class.isAssignableFrom(interfce)) {
                for (Method m : interfce.getMethods()) {
                    if (!m.getName().startsWith("create")) continue;
                    interfce = m.getReturnType();
                    break;
                }
                localFlag = true;
            } else if (interfce.getAnnotation(Local.class) != null) {
                localFlag = true;
            } else if (interfce.getAnnotation(Remote.class) != null) {
                remoteFlag = true;
            }
        }
        log.debug("addEJB(): localFlag: " + localFlag);
        log.debug("addEJB(): remoteFlag: " + remoteFlag);
        if (localFlag) {
            Set targets;
            log.debug("addEJB(): <ejb-local-ref> found");
            String localRefName = EJBAnnotationHelper.getName(annotation.name(), method, field);
            EjbLocalRef ejbLocalRef = (EjbLocalRef)annotatedApp.getEjbLocalRefMap().get(EJBAnnotationHelper.getJndiName(localRefName));
            if (ejbLocalRef == null) {
                try {
                    String descriptionAnnotation;
                    String lookupName;
                    String beanName;
                    String localAnnotation;
                    log.debug("addEJB(): Does not exist in DD: " + localRefName);
                    ejbLocalRef = new EjbLocalRef();
                    ejbLocalRef.setEjbRefName(localRefName);
                    if (interfce != null && !(localAnnotation = interfce.getName()).isEmpty()) {
                        ejbLocalRef.setLocal(localAnnotation);
                    }
                    if (!(beanName = annotation.beanName()).isEmpty()) {
                        ejbLocalRef.setEjbLink(beanName);
                    }
                    if (!(mappdedNameAnnotation = annotation.mappedName()).isEmpty()) {
                        ejbLocalRef.setMappedName(mappdedNameAnnotation);
                    }
                    if (!(lookupName = annotation.lookup()).isEmpty()) {
                        ejbLocalRef.setLookupName(lookupName);
                    }
                    if (!(descriptionAnnotation = annotation.description()).isEmpty()) {
                        ejbLocalRef.setDescriptions(new Text[]{new Text(null, descriptionAnnotation)});
                    }
                    ejbLocalRef.setRefType(EjbReference.Type.LOCAL);
                    annotatedApp.getEjbLocalRef().add(ejbLocalRef);
                }
                catch (Exception e) {
                    log.debug("EJBAnnotationHelper: Exception caught while processing <ejb-local-ref>", (Throwable)e);
                }
            }
            if (!(method == null && field == null || EJBAnnotationHelper.hasTarget(method, field, targets = ejbLocalRef.getInjectionTarget()))) {
                ejbLocalRef.getInjectionTarget().add(EJBAnnotationHelper.configureInjectionTarget(method, field));
            }
        } else if (remoteFlag) {
            Set targets;
            log.debug("addEJB(): <ejb-ref> found");
            remoteRefName = EJBAnnotationHelper.getName(annotation.name(), method, field);
            EjbRef ejbRef = (EjbRef)annotatedApp.getEjbRefMap().get(EJBAnnotationHelper.getJndiName(remoteRefName));
            if (ejbRef == null) {
                try {
                    String descriptionAnnotation;
                    String lookupName;
                    String beanName;
                    String remoteAnnotation;
                    log.debug("addEJB(): Does not exist in DD: " + remoteRefName);
                    ejbRef = new EjbRef();
                    ejbRef.setEjbRefName(remoteRefName);
                    if (interfce != null && !(remoteAnnotation = interfce.getName()).isEmpty()) {
                        ejbRef.setRemote(remoteAnnotation);
                    }
                    if (!(beanName = annotation.beanName()).isEmpty()) {
                        ejbRef.setEjbLink(beanName);
                    }
                    if (!(mappdedNameAnnotation = annotation.mappedName()).isEmpty()) {
                        ejbRef.setMappedName(mappdedNameAnnotation);
                    }
                    if (!(lookupName = annotation.lookup()).isEmpty()) {
                        ejbRef.setLookupName(lookupName);
                    }
                    if (!(descriptionAnnotation = annotation.description()).isEmpty()) {
                        ejbRef.setDescriptions(new Text[]{new Text(null, descriptionAnnotation)});
                    }
                    ejbRef.setRefType(EjbReference.Type.REMOTE);
                    annotatedApp.getEjbRef().add(ejbRef);
                }
                catch (Exception e) {
                    log.debug("EJBAnnotationHelper: Exception caught while processing <ejb-ref>", (Throwable)e);
                }
            }
            if (!(method == null && field == null || EJBAnnotationHelper.hasTarget(method, field, targets = ejbRef.getInjectionTarget()))) {
                ejbRef.getInjectionTarget().add(EJBAnnotationHelper.configureInjectionTarget(method, field));
            }
        } else {
            Set targets;
            log.debug("addEJB(): <UNKNOWN> found");
            remoteRefName = EJBAnnotationHelper.getName(annotation.name(), method, field);
            EjbRef ejbRef = (EjbRef)annotatedApp.getEjbRefMap().get(EJBAnnotationHelper.getJndiName(remoteRefName));
            if (ejbRef == null) {
                try {
                    String descriptionAnnotation;
                    String lookupName;
                    String beanName;
                    String remoteAnnotation;
                    log.debug("addEJB(): Does not exist in DD: " + remoteRefName);
                    ejbRef = new EjbRef();
                    ejbRef.setEjbRefName(remoteRefName);
                    if (interfce != null && !(remoteAnnotation = interfce.getName()).isEmpty()) {
                        ejbRef.setRemote(remoteAnnotation);
                    }
                    if (!(beanName = annotation.beanName()).isEmpty()) {
                        ejbRef.setEjbLink(beanName);
                    }
                    if (!(mappdedNameAnnotation = annotation.mappedName()).isEmpty()) {
                        ejbRef.setMappedName(mappdedNameAnnotation);
                    }
                    if (!(lookupName = annotation.lookup()).isEmpty()) {
                        ejbRef.setLookupName(lookupName);
                    }
                    if (!(descriptionAnnotation = annotation.description()).isEmpty()) {
                        ejbRef.setDescriptions(new Text[]{new Text(null, descriptionAnnotation)});
                    }
                    ejbRef.setRefType(EjbReference.Type.UNKNOWN);
                    annotatedApp.getEjbRef().add(ejbRef);
                }
                catch (Exception e) {
                    log.debug("EJBAnnotationHelper: Exception caught while processing <UNKNOWN>", (Throwable)e);
                }
            }
            if (!(method == null && field == null || EJBAnnotationHelper.hasTarget(method, field, targets = ejbRef.getInjectionTarget()))) {
                ejbRef.getInjectionTarget().add(EJBAnnotationHelper.configureInjectionTarget(method, field));
            }
        }
        log.debug("addEJB(): Exit");
    }
}

