/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jws.HandlerChain;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.WebServiceRefs;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotatedApp;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotationHelper;
import org.apache.geronimo.j2ee.deployment.annotation.HandlerChainAnnotationHelper;
import org.apache.geronimo.xbeans.javaee.FullyQualifiedClassType;
import org.apache.geronimo.xbeans.javaee.JndiNameType;
import org.apache.geronimo.xbeans.javaee.ServiceRefType;
import org.apache.geronimo.xbeans.javaee.XsdAnyURIType;
import org.apache.geronimo.xbeans.javaee.XsdStringType;
import org.apache.xbean.finder.ClassFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebServiceRefAnnotationHelper
extends AnnotationHelper {
    private static final Logger log = LoggerFactory.getLogger(WebServiceRefAnnotationHelper.class);

    private WebServiceRefAnnotationHelper() {
    }

    public static void processAnnotations(AnnotatedApp annotatedApp, ClassFinder classFinder) throws DeploymentException {
        if (annotatedApp != null) {
            if (classFinder.isAnnotationPresent(WebServiceRefs.class)) {
                WebServiceRefAnnotationHelper.processWebServiceRefs(annotatedApp, classFinder);
            }
            if (classFinder.isAnnotationPresent(WebServiceRef.class)) {
                WebServiceRefAnnotationHelper.processWebServiceRef(annotatedApp, classFinder);
            }
        }
    }

    private static void processWebServiceRef(AnnotatedApp annotatedApp, ClassFinder classFinder) throws DeploymentException {
        WebServiceRef webServiceRef;
        log.debug("processWebServiceRef(): Entry: AnnotatedApp: " + ((Object)annotatedApp).toString());
        List classeswithWebServiceRef = classFinder.findAnnotatedClasses(WebServiceRef.class);
        List methodswithWebServiceRef = classFinder.findAnnotatedMethods(WebServiceRef.class);
        List fieldswithWebServiceRef = classFinder.findAnnotatedFields(WebServiceRef.class);
        for (Class cls : classeswithWebServiceRef) {
            webServiceRef = cls.getAnnotation(WebServiceRef.class);
            if (webServiceRef == null) continue;
            WebServiceRefAnnotationHelper.addWebServiceRef(annotatedApp, webServiceRef, cls, null, null);
        }
        for (Method method : methodswithWebServiceRef) {
            webServiceRef = method.getAnnotation(WebServiceRef.class);
            if (webServiceRef == null) continue;
            WebServiceRefAnnotationHelper.addWebServiceRef(annotatedApp, webServiceRef, null, method, null);
        }
        for (Field field : fieldswithWebServiceRef) {
            webServiceRef = field.getAnnotation(WebServiceRef.class);
            if (webServiceRef == null) continue;
            WebServiceRefAnnotationHelper.addWebServiceRef(annotatedApp, webServiceRef, null, null, field);
        }
        WebServiceRefAnnotationHelper.validateDD(annotatedApp);
        log.debug("processWebServiceRef(): Exit: AnnotatedApp: " + ((Object)annotatedApp).toString());
    }

    private static void processWebServiceRefs(AnnotatedApp annotatedApp, ClassFinder classFinder) throws DeploymentException {
        log.debug("processWebServiceRefs(): Entry");
        List classeswithWebServiceRefs = classFinder.findAnnotatedClasses(WebServiceRefs.class);
        ArrayList<WebServiceRef> webServiceRefList = new ArrayList<WebServiceRef>();
        for (Class cls : classeswithWebServiceRefs) {
            WebServiceRefs webServiceRefs = cls.getAnnotation(WebServiceRefs.class);
            if (webServiceRefs != null) {
                webServiceRefList.addAll(Arrays.asList(webServiceRefs.value()));
            }
            for (WebServiceRef webServiceRef : webServiceRefList) {
                WebServiceRefAnnotationHelper.addWebServiceRef(annotatedApp, webServiceRef, cls, null, null);
            }
            webServiceRefList.clear();
        }
        log.debug("processWebServiceRefs(): Exit");
    }

    private static void addWebServiceRef(AnnotatedApp annotatedApp, WebServiceRef annotation, Class cls, Method method, Field field) {
        ServiceRefType[] serviceRefs;
        log.debug("addWebServiceRef( [annotatedApp] " + ((Object)annotatedApp).toString() + "," + '\n' + "[annotation] " + annotation.toString() + "," + '\n' + "[cls] " + (cls != null ? cls.getName() : null) + "," + '\n' + "[method] " + (method != null ? method.getName() : null) + "," + '\n' + "[field] " + (field != null ? field.getName() : null) + " ): Entry");
        String webServiceRefName = WebServiceRefAnnotationHelper.getName(annotation.name(), method, field);
        log.debug("addWebServiceRef(): webServiceRefName: " + webServiceRefName);
        Class<?> webServiceRefType = annotation.type();
        Class webServiceRefValue = annotation.value();
        if (webServiceRefType == null || webServiceRefType.equals(Object.class)) {
            if (method != null) {
                webServiceRefType = method.getParameterTypes()[0];
            } else if (field != null) {
                webServiceRefType = field.getType();
            }
        }
        log.debug("addWebServiceRef(): webServiceRefType: " + webServiceRefType);
        log.debug("addWebServiceRef(): webServiceRefValue: " + webServiceRefValue);
        ServiceRefType serviceRef = null;
        for (ServiceRefType currServiceRef : serviceRefs = annotatedApp.getServiceRefArray()) {
            if (!currServiceRef.getServiceRefName().getStringValue().trim().equals(webServiceRefName)) continue;
            serviceRef = currServiceRef;
            break;
        }
        if (serviceRef == null) {
            serviceRef = annotatedApp.addNewServiceRef();
            JndiNameType serviceRefName = serviceRef.addNewServiceRefName();
            serviceRefName.setStringValue(webServiceRefName);
            serviceRef.setServiceRefName(serviceRefName);
            if (!webServiceRefValue.equals(Object.class)) {
                FullyQualifiedClassType qualifiedClass = serviceRef.addNewServiceInterface();
                qualifiedClass.setStringValue(webServiceRefValue.getName());
                serviceRef.setServiceInterface(qualifiedClass);
            } else {
                FullyQualifiedClassType qualifiedClass = serviceRef.addNewServiceInterface();
                qualifiedClass.setStringValue(webServiceRefType.getName());
                serviceRef.setServiceInterface(qualifiedClass);
            }
        }
        if (!serviceRef.isSetServiceRefType() && !webServiceRefType.equals(Object.class)) {
            FullyQualifiedClassType qualifiedClass = serviceRef.addNewServiceRefType();
            qualifiedClass.setStringValue(webServiceRefType.getName());
            serviceRef.setServiceRefType(qualifiedClass);
        }
        if (!serviceRef.isSetMappedName() && annotation.mappedName().trim().length() > 0) {
            XsdStringType mappedName = serviceRef.addNewMappedName();
            mappedName.setStringValue(annotation.mappedName().trim());
            serviceRef.setMappedName(mappedName);
        }
        if (!serviceRef.isSetWsdlFile()) {
            String wsdlLocation = annotation.wsdlLocation();
            if (wsdlLocation == null || wsdlLocation.trim().length() == 0) {
                WebServiceClient wsClient = null;
                wsClient = Object.class.equals((Object)webServiceRefValue) ? webServiceRefType.getAnnotation(WebServiceClient.class) : webServiceRefValue.getAnnotation(WebServiceClient.class);
                wsdlLocation = wsClient == null ? null : wsClient.wsdlLocation();
            }
            if (wsdlLocation != null && wsdlLocation.trim().length() > 0) {
                XsdAnyURIType wsdlFile = serviceRef.addNewWsdlFile();
                wsdlFile.setStringValue(wsdlLocation);
                serviceRef.setWsdlFile(wsdlFile);
            }
        }
        if (!serviceRef.isSetHandlerChains()) {
            HandlerChain handlerChain = null;
            Class annotatedClass = null;
            if (method != null) {
                handlerChain = method.getAnnotation(HandlerChain.class);
                annotatedClass = method.getDeclaringClass();
            } else if (field != null) {
                handlerChain = field.getAnnotation(HandlerChain.class);
                annotatedClass = field.getDeclaringClass();
            }
            if (handlerChain == null) {
                if (Object.class.equals((Object)webServiceRefValue)) {
                    handlerChain = webServiceRefType.getAnnotation(HandlerChain.class);
                    annotatedClass = webServiceRefType;
                } else {
                    handlerChain = webServiceRefValue.getAnnotation(HandlerChain.class);
                    annotatedClass = webServiceRefValue;
                }
            }
            if (handlerChain != null) {
                HandlerChainAnnotationHelper.insertHandlers(serviceRef, handlerChain, annotatedClass);
            }
        }
        if (method != null || field != null) {
            WebServiceRefAnnotationHelper.configureInjectionTarget(serviceRef.addNewInjectionTarget(), method, field);
        }
    }
}

