/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment.annotation;

import java.util.List;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.servlet.Servlet;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotatedWebApp;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotationHelper;
import org.apache.geronimo.xbeans.javaee.RoleNameType;
import org.apache.geronimo.xbeans.javaee.RunAsType;
import org.apache.geronimo.xbeans.javaee.SecurityRoleType;
import org.apache.geronimo.xbeans.javaee.ServletType;
import org.apache.geronimo.xbeans.javaee.WebAppType;
import org.apache.xbean.finder.ClassFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecurityAnnotationHelper
extends AnnotationHelper {
    private static final Logger log = LoggerFactory.getLogger(SecurityAnnotationHelper.class);

    private SecurityAnnotationHelper() {
    }

    public static void processAnnotations(WebAppType webApp, ClassFinder classFinder) throws DeploymentException {
        if (webApp != null && classFinder != null) {
            if (classFinder.isAnnotationPresent(DeclareRoles.class)) {
                SecurityAnnotationHelper.processDeclareRoles(webApp, classFinder);
            }
            if (classFinder.isAnnotationPresent(RunAs.class)) {
                SecurityAnnotationHelper.processRunAs(webApp, classFinder);
            }
        }
    }

    private static void processDeclareRoles(WebAppType webApp, ClassFinder classFinder) throws DeploymentException {
        log.debug("processDeclareRoles(): Entry: webApp: " + webApp.toString());
        List classesWithDeclareRoles = classFinder.findAnnotatedClasses(DeclareRoles.class);
        for (Class cls : classesWithDeclareRoles) {
            DeclareRoles declareRoles = cls.getAnnotation(DeclareRoles.class);
            if (declareRoles == null || !Servlet.class.isAssignableFrom(cls)) continue;
            SecurityAnnotationHelper.addDeclareRoles(webApp, declareRoles, cls);
        }
        SecurityAnnotationHelper.validateDD(new AnnotatedWebApp(webApp));
        log.debug("processDeclareRoles(): Exit: webApp: " + webApp.toString());
    }

    private static void processRunAs(WebAppType webApp, ClassFinder classFinder) throws DeploymentException {
        log.debug("processRunAs(): Entry: webApp: " + webApp.toString());
        List classesWithRunAs = classFinder.findAnnotatedClasses(RunAs.class);
        for (Class cls : classesWithRunAs) {
            RunAs runAs = cls.getAnnotation(RunAs.class);
            if (runAs == null || !Servlet.class.isAssignableFrom(cls)) continue;
            SecurityAnnotationHelper.addRunAs(webApp, runAs, cls);
        }
        SecurityAnnotationHelper.validateDD(new AnnotatedWebApp(webApp));
        log.debug("processRunAs(): Exit: webApp: " + webApp.toString());
    }

    private static void addDeclareRoles(WebAppType webApp, DeclareRoles annotation, Class cls) {
        String[] annotationRoleNames;
        log.debug("addDeclareRoles( [webApp] " + webApp.toString() + "," + '\n' + "[annotation] " + annotation.toString() + "," + '\n' + "[cls] " + (cls != null ? cls.getName() : null) + "): Entry");
        SecurityRoleType[] securityRoles = webApp.getSecurityRoleArray();
        for (String annotationRoleName : annotationRoleNames = annotation.value()) {
            if (annotationRoleName.equals("")) continue;
            boolean exists = false;
            for (SecurityRoleType securityRole : securityRoles) {
                if (!securityRole.getRoleName().getStringValue().trim().equals(annotationRoleName)) continue;
                exists = true;
                break;
            }
            if (exists) {
                log.debug("addDeclareRoles: <security-role> entry found: " + annotationRoleName);
                continue;
            }
            log.debug("addDeclareRoles: <security-role> entry NOT found: " + annotationRoleName);
            SecurityRoleType securityRole = webApp.addNewSecurityRole();
            RoleNameType roleName = securityRole.addNewRoleName();
            roleName.setStringValue(annotationRoleName);
        }
        log.debug("addDeclareRoles(): Exit");
    }

    private static void addRunAs(WebAppType webApp, RunAs annotation, Class cls) {
        log.debug("addRunAs( [webApp] " + webApp.toString() + "," + '\n' + "[annotation] " + annotation.toString() + "," + '\n' + "[cls] " + (cls != null ? cls.getName() : null) + "): Entry");
        String annotationRunAs = annotation.value();
        if (!annotationRunAs.equals("")) {
            ServletType[] servlets = webApp.getServletArray();
            boolean exists = false;
            for (ServletType servlet : servlets) {
                if (!servlet.getServletClass().getStringValue().trim().equals(cls.getName())) continue;
                if (!servlet.isSetRunAs()) {
                    RunAsType runAsType = servlet.addNewRunAs();
                    RoleNameType roleName = runAsType.addNewRoleName();
                    roleName.setStringValue(annotationRunAs);
                }
                exists = true;
                break;
            }
            if (!exists) {
                log.warn("RunAs servlet not found in webApp: " + cls.getName());
            }
        }
        log.debug("addRunAs(): Exit");
    }
}

