/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotatedApp;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xmlbeans.XmlObject;

public abstract class Module {
    private final boolean standAlone;
    private final AbstractName moduleName;
    private final String name;
    private final Environment environment;
    private final URI moduleURI;
    private final JarFile moduleFile;
    private final String targetPath;
    private final URI targetPathURI;
    private final XmlObject vendorDD;
    private final String namespace;
    private EARContext earContext;
    private EARContext rootEarContext;
    private XmlObject specDD;
    private String originalSpecDD;
    private AnnotatedApp annotatedApp;
    private ClassFinder classFinder;
    protected final Map sharedContext = new HashMap();

    protected Module(boolean standAlone, AbstractName moduleName, Environment environment, JarFile moduleFile, String targetPath, XmlObject specDD, XmlObject vendorDD, String originalSpecDD, String namespace, AnnotatedApp annotatedApp) {
        assert (targetPath != null) : "targetPath is null";
        assert (moduleName != null) : "moduleName is null";
        this.standAlone = standAlone;
        this.moduleName = moduleName;
        this.environment = environment;
        this.moduleFile = moduleFile;
        this.targetPath = targetPath;
        this.specDD = specDD;
        this.vendorDD = vendorDD;
        this.originalSpecDD = originalSpecDD;
        this.namespace = namespace;
        if (standAlone) {
            this.name = environment.getConfigId().toString();
            this.moduleURI = URI.create("");
        } else {
            this.name = targetPath;
            this.moduleURI = URI.create(targetPath);
        }
        this.targetPathURI = URI.create(targetPath + "/");
        this.annotatedApp = annotatedApp;
    }

    public abstract ConfigurationModuleType getType();

    public String getName() {
        return this.name;
    }

    public boolean isStandAlone() {
        return this.standAlone;
    }

    public AbstractName getModuleName() {
        return this.moduleName;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public URI getModuleURI() {
        return this.moduleURI;
    }

    public JarFile getModuleFile() {
        return this.moduleFile;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public URI getTargetPathURI() {
        return this.targetPathURI;
    }

    public XmlObject getSpecDD() {
        return this.specDD;
    }

    public XmlObject getVendorDD() {
        return this.vendorDD;
    }

    public String getOriginalSpecDD() {
        return this.originalSpecDD;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Module) {
            Module module = (Module)obj;
            return this.name.equals(module.name);
        }
        return false;
    }

    public void close() {
        DeploymentUtil.close((JarFile)this.moduleFile);
    }

    public EARContext getEarContext() {
        return this.earContext;
    }

    public void setEarContext(EARContext earContext) {
        this.earContext = earContext;
    }

    public EARContext getRootEarContext() {
        return this.rootEarContext;
    }

    public void setRootEarContext(EARContext rootEarContext) {
        this.rootEarContext = rootEarContext;
    }

    public Map getSharedContext() {
        return this.sharedContext;
    }

    public void setSpecDD(XmlObject specDD) {
        this.specDD = specDD;
    }

    public void setOriginalSpecDD(String originalSpecDD) {
        this.originalSpecDD = originalSpecDD;
    }

    public AnnotatedApp getAnnotatedApp() {
        return this.annotatedApp;
    }

    public void setAnnotatedApp(AnnotatedApp annotatedApp) {
        this.annotatedApp = annotatedApp;
    }

    public ClassFinder getClassFinder() {
        return this.classFinder;
    }

    public void setClassFinder(ClassFinder classFinder) {
        this.classFinder = classFinder;
    }

    public Artifact[] getConfigId() {
        if (this.earContext == null) {
            throw new NullPointerException("No ear context set");
        }
        if (this.rootEarContext == null || this.rootEarContext == this.earContext || this.rootEarContext.getConfigID().equals((Object)this.earContext.getConfigID())) {
            return new Artifact[]{this.earContext.getConfigID()};
        }
        return new Artifact[]{this.rootEarContext.getConfigID(), this.earContext.getConfigID()};
    }

    public String getRelativePath(String path) {
        return path;
    }
}

