/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.ClassPathList;
import org.apache.geronimo.deployment.ConfigurationBuilder;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.ModuleList;
import org.apache.geronimo.deployment.NamespaceDrivenBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilderCollection;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.service.GBeanBuilder;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.deployment.util.NestedJarFile;
import org.apache.geronimo.deployment.xbeans.ArtifactType;
import org.apache.geronimo.deployment.xbeans.EnvironmentType;
import org.apache.geronimo.deployment.xbeans.PatternType;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.gbean.SingleElementCollection;
import org.apache.geronimo.j2ee.ApplicationInfo;
import org.apache.geronimo.j2ee.deployment.ActivationSpecInfoLocator;
import org.apache.geronimo.j2ee.deployment.AppClientModule;
import org.apache.geronimo.j2ee.deployment.ConnectorModule;
import org.apache.geronimo.j2ee.deployment.CorbaGBeanNameSource;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.EJBModule;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.j2ee.deployment.ModuleBuilderExtension;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.j2ee.management.impl.J2EEApplicationImpl;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationAlreadyExistsException;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.SimpleConfigurationManager;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.management.J2EEResource;
import org.apache.geronimo.management.J2EEServer;
import org.apache.geronimo.management.geronimo.ResourceAdapterModule;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerApplicationDocument;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerApplicationType;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerExtModuleType;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerModuleType;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerSecurityDocument;
import org.apache.geronimo.xbeans.javaee.ApplicationDocument;
import org.apache.geronimo.xbeans.javaee.ApplicationType;
import org.apache.geronimo.xbeans.javaee.ModuleType;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EARConfigBuilder
implements ConfigurationBuilder,
CorbaGBeanNameSource {
    private static final Log log = LogFactory.getLog(EARConfigBuilder.class);
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final QName APPLICATION_QNAME = GerApplicationDocument.type.getDocumentElementName();
    private final ConfigurationManager configurationManager;
    private final Collection<Repository> repositories;
    private final SingleElementCollection ejbConfigBuilder;
    private final SingleElementCollection webConfigBuilder;
    private final SingleElementCollection connectorConfigBuilder;
    private final SingleElementCollection appClientConfigBuilder;
    private final SingleElementCollection resourceReferenceBuilder;
    private final NamespaceDrivenBuilderCollection securityBuilders;
    private final NamespaceDrivenBuilderCollection serviceBuilders;
    private final Collection<ModuleBuilderExtension> persistenceUnitBuilders;
    private final Environment defaultEnvironment;
    private final AbstractNameQuery serverName;
    private final AbstractNameQuery transactionManagerObjectName;
    private final AbstractNameQuery connectionTrackerObjectName;
    private final AbstractNameQuery transactionalTimerObjectName;
    private final AbstractNameQuery nonTransactionalTimerObjectName;
    private final AbstractNameQuery corbaGBeanObjectName;
    private final Naming naming;
    private final Collection<ArtifactResolver> artifactResolvers;
    public static final GBeanInfo GBEAN_INFO;

    public EARConfigBuilder(Environment defaultEnvironment, AbstractNameQuery transactionManagerAbstractName, AbstractNameQuery connectionTrackerAbstractName, AbstractNameQuery transactionalTimerAbstractName, AbstractNameQuery nonTransactionalTimerAbstractName, AbstractNameQuery corbaGBeanAbstractName, AbstractNameQuery serverName, Collection<Repository> repositories, Collection ejbConfigBuilder, Collection webConfigBuilder, Collection connectorConfigBuilder, Collection resourceReferenceBuilder, Collection appClientConfigBuilder, Collection securityBuilders, Collection serviceBuilders, Collection<ModuleBuilderExtension> persistenceUnitBuilders, Collection<ArtifactResolver> artifactResolvers, Kernel kernel) {
        this(defaultEnvironment, transactionManagerAbstractName, connectionTrackerAbstractName, transactionalTimerAbstractName, nonTransactionalTimerAbstractName, corbaGBeanAbstractName, serverName, ConfigurationUtil.getConfigurationManager((Kernel)kernel), repositories, new SingleElementCollection(ejbConfigBuilder), new SingleElementCollection(webConfigBuilder), new SingleElementCollection(connectorConfigBuilder), new SingleElementCollection(resourceReferenceBuilder), new SingleElementCollection(appClientConfigBuilder), securityBuilders, serviceBuilders, persistenceUnitBuilders, kernel.getNaming(), artifactResolvers);
    }

    public EARConfigBuilder(Environment defaultEnvironment, AbstractNameQuery transactionManagerAbstractName, AbstractNameQuery connectionTrackerAbstractName, AbstractNameQuery transactionalTimerAbstractName, AbstractNameQuery nonTransactionalTimerAbstractName, AbstractNameQuery corbaGBeanAbstractName, AbstractNameQuery serverName, Collection<Repository> repositories, ModuleBuilder ejbConfigBuilder, ModuleBuilder webConfigBuilder, ModuleBuilder connectorConfigBuilder, ActivationSpecInfoLocator activationSpecInfoLocator, ModuleBuilder appClientConfigBuilder, NamespaceDrivenBuilder securityBuilder, NamespaceDrivenBuilder serviceBuilder, ModuleBuilderExtension persistenceUnitBuilder, Naming naming, Collection<ArtifactResolver> artifactResolvers) {
        this(defaultEnvironment, transactionManagerAbstractName, connectionTrackerAbstractName, transactionalTimerAbstractName, nonTransactionalTimerAbstractName, corbaGBeanAbstractName, serverName, null, repositories, new SingleElementCollection((Object)ejbConfigBuilder), new SingleElementCollection((Object)webConfigBuilder), new SingleElementCollection((Object)connectorConfigBuilder), new SingleElementCollection((Object)activationSpecInfoLocator), new SingleElementCollection((Object)appClientConfigBuilder), securityBuilder == null ? Collections.EMPTY_SET : Collections.singleton(securityBuilder), serviceBuilder == null ? Collections.EMPTY_SET : Collections.singleton(serviceBuilder), persistenceUnitBuilder == null ? Collections.EMPTY_SET : Collections.singleton(persistenceUnitBuilder), naming, artifactResolvers);
    }

    private EARConfigBuilder(Environment defaultEnvironment, AbstractNameQuery transactionManagerAbstractName, AbstractNameQuery connectionTrackerAbstractName, AbstractNameQuery transactionalTimerAbstractName, AbstractNameQuery nonTransactionalTimerAbstractName, AbstractNameQuery corbaGBeanAbstractName, AbstractNameQuery serverName, ConfigurationManager configurationManager, Collection<Repository> repositories, SingleElementCollection ejbConfigBuilder, SingleElementCollection webConfigBuilder, SingleElementCollection connectorConfigBuilder, SingleElementCollection resourceReferenceBuilder, SingleElementCollection appClientConfigBuilder, Collection securityBuilders, Collection serviceBuilders, Collection<ModuleBuilderExtension> persistenceUnitBuilders, Naming naming, Collection<ArtifactResolver> artifactResolvers) {
        this.configurationManager = configurationManager;
        this.repositories = repositories;
        this.defaultEnvironment = defaultEnvironment;
        this.ejbConfigBuilder = ejbConfigBuilder;
        this.resourceReferenceBuilder = resourceReferenceBuilder;
        this.webConfigBuilder = webConfigBuilder;
        this.connectorConfigBuilder = connectorConfigBuilder;
        this.appClientConfigBuilder = appClientConfigBuilder;
        this.securityBuilders = new NamespaceDrivenBuilderCollection(securityBuilders, GerSecurityDocument.type.getDocumentElementName());
        this.serviceBuilders = new NamespaceDrivenBuilderCollection(serviceBuilders, GBeanBuilder.SERVICE_QNAME);
        this.persistenceUnitBuilders = persistenceUnitBuilders;
        this.transactionManagerObjectName = transactionManagerAbstractName;
        this.connectionTrackerObjectName = connectionTrackerAbstractName;
        this.transactionalTimerObjectName = transactionalTimerAbstractName;
        this.nonTransactionalTimerObjectName = nonTransactionalTimerAbstractName;
        this.corbaGBeanObjectName = corbaGBeanAbstractName;
        this.serverName = serverName;
        this.naming = naming;
        this.artifactResolvers = artifactResolvers;
    }

    @Override
    public AbstractNameQuery getCorbaGBeanName() {
        return this.corbaGBeanObjectName;
    }

    private ModuleBuilder getEjbConfigBuilder() {
        return (ModuleBuilder)this.ejbConfigBuilder.getElement();
    }

    private ModuleBuilder getWebConfigBuilder() {
        return (ModuleBuilder)this.webConfigBuilder.getElement();
    }

    private ModuleBuilder getConnectorConfigBuilder() {
        return (ModuleBuilder)this.connectorConfigBuilder.getElement();
    }

    private ModuleBuilder getAppClientConfigBuilder() {
        return (ModuleBuilder)this.appClientConfigBuilder.getElement();
    }

    public Object getDeploymentPlan(File planFile, JarFile jarFile, ModuleIDBuilder idBuilder) throws DeploymentException {
        if (planFile == null && jarFile == null) {
            return null;
        }
        ApplicationInfo plan = this.getEarPlan(planFile, jarFile, idBuilder);
        if (plan != null) {
            return plan;
        }
        if (jarFile == null) {
            return null;
        }
        Module module = null;
        if (this.getWebConfigBuilder() != null) {
            module = this.getWebConfigBuilder().createModule(planFile, jarFile, this.naming, idBuilder);
        }
        if (module == null && this.getEjbConfigBuilder() != null) {
            module = this.getEjbConfigBuilder().createModule(planFile, jarFile, this.naming, idBuilder);
        }
        if (module == null && this.getConnectorConfigBuilder() != null) {
            module = this.getConnectorConfigBuilder().createModule(planFile, jarFile, this.naming, idBuilder);
        }
        if (module == null && this.getAppClientConfigBuilder() != null) {
            module = this.getAppClientConfigBuilder().createModule(planFile, jarFile, this.naming, idBuilder);
        }
        if (module == null) {
            return null;
        }
        if (module instanceof ApplicationInfo) {
            return module;
        }
        return new ApplicationInfo(module.getType(), module.getEnvironment(), module.getModuleName(), jarFile, null, null, new LinkedHashSet<Module>(Collections.singleton(module)), new ModuleList(), null);
    }

    private ApplicationInfo getEarPlan(File planFile, JarFile earFile, ModuleIDBuilder idBuilder) throws DeploymentException {
        ApplicationType application;
        block19: {
            application = null;
            if (earFile != null) {
                try {
                    URL applicationXmlUrl = DeploymentUtil.createJarURL((JarFile)earFile, (String)"META-INF/application.xml");
                    String specDD = DeploymentUtil.readAll((URL)applicationXmlUrl);
                    XmlObject xmlObject = XmlBeansUtil.parse((String)specDD);
                    application = EARConfigBuilder.convertToApplicationSchema(xmlObject).getApplication();
                }
                catch (XmlException e) {
                    throw new DeploymentException("Could not parse application.xml", (Throwable)e);
                }
                catch (Exception e) {
                    if (earFile.getName().endsWith(".ear")) break block19;
                    return null;
                }
            }
        }
        GerApplicationType gerApplication = null;
        try {
            try {
                XmlObject rawPlan;
                if (planFile != null) {
                    rawPlan = XmlBeansUtil.parse((URL)planFile.toURL(), (ClassLoader)this.getClass().getClassLoader());
                    gerApplication = (GerApplicationType)SchemaConversionUtils.fixGeronimoSchema((XmlObject)rawPlan, (QName)APPLICATION_QNAME, (SchemaType)GerApplicationType.type);
                    if (gerApplication == null) {
                        return null;
                    }
                } else {
                    URL path = DeploymentUtil.createJarURL((JarFile)earFile, (String)"META-INF/geronimo-application.xml");
                    rawPlan = XmlBeansUtil.parse((URL)path, (ClassLoader)this.getClass().getClassLoader());
                    gerApplication = (GerApplicationType)SchemaConversionUtils.fixGeronimoSchema((XmlObject)rawPlan, (QName)APPLICATION_QNAME, (SchemaType)GerApplicationType.type);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (gerApplication == null) {
                gerApplication = this.createDefaultPlan(application, earFile);
            }
        }
        catch (XmlException e) {
            throw new DeploymentException((Throwable)e);
        }
        EnvironmentType environmentType = gerApplication.getEnvironment();
        Environment environment = EnvironmentBuilder.buildEnvironment((EnvironmentType)environmentType, (Environment)this.defaultEnvironment);
        idBuilder.resolve(environment, earFile == null ? planFile.getName() : new File(earFile.getName()).getName(), "ear");
        idBuilder.setDefaultGroup(environment.getConfigId().getGroupId());
        idBuilder.setDefaultVersion(environment.getConfigId().getVersion());
        Artifact artifact = environment.getConfigId();
        AbstractName earName = this.naming.createRootName(artifact, artifact.toString(), "J2EEApplication");
        ModuleList moduleLocations = new ModuleList();
        LinkedHashSet<Module> modules = new LinkedHashSet<Module>();
        try {
            this.addModules(earFile, application, gerApplication, moduleLocations, modules, environment, earName, idBuilder);
            if (application == null && modules.isEmpty()) {
                return null;
            }
        }
        catch (Throwable e) {
            for (Module module : modules) {
                module.close();
            }
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new DeploymentException(e);
        }
        return new ApplicationInfo(ConfigurationModuleType.EAR, environment, earName, earFile, (XmlObject)application, gerApplication, modules, moduleLocations, application == null ? null : application.toString());
    }

    private GerApplicationType createDefaultPlan(ApplicationType application, JarFile module) {
        String id;
        GerApplicationType gerApplication = GerApplicationType.Factory.newInstance();
        EnvironmentType environmentType = gerApplication.addNewEnvironment();
        ArtifactType artifactType = environmentType.addNewModuleId();
        artifactType.setGroupId("default");
        String string = id = application != null ? application.getId() : null;
        if (id == null) {
            File fileName = new File(module.getName());
            id = fileName.getName();
            if (id.endsWith(".ear")) {
                id = id.substring(0, id.length() - 4);
            }
            if (id.endsWith("/")) {
                id = id.substring(0, id.length() - 1);
            }
        }
        artifactType.setArtifactId(id);
        artifactType.setVersion("" + System.currentTimeMillis());
        artifactType.setType("car");
        return gerApplication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ApplicationDocument convertToApplicationSchema(XmlObject xmlObject) throws XmlException {
        if (ApplicationDocument.type.equals(xmlObject.schemaType())) {
            XmlBeansUtil.validateDD((XmlObject)xmlObject);
            return (ApplicationDocument)xmlObject;
        }
        XmlCursor cursor = xmlObject.newCursor();
        XmlCursor moveable = xmlObject.newCursor();
        String schemaLocationURL = "http://java.sun.com/xml/ns/javaee/application_5.xsd";
        String version = "5";
        try {
            cursor.toStartDoc();
            cursor.toFirstChild();
            if ("http://java.sun.com/xml/ns/j2ee".equals(cursor.getName().getNamespaceURI())) {
                SchemaConversionUtils.convertSchemaVersion((XmlCursor)cursor, (String)"http://java.sun.com/xml/ns/javaee", (String)schemaLocationURL, (String)version);
                XmlObject result = xmlObject.changeType(ApplicationDocument.type);
                XmlBeansUtil.validateDD((XmlObject)result);
                ApplicationDocument applicationDocument = (ApplicationDocument)result;
                return applicationDocument;
            }
            SchemaConversionUtils.convertToSchema((XmlCursor)cursor, (String)"http://java.sun.com/xml/ns/javaee", (String)schemaLocationURL, (String)version);
            cursor.toStartDoc();
            cursor.toChild("http://java.sun.com/xml/ns/javaee", "application");
            cursor.toFirstChild();
            SchemaConversionUtils.convertToDescriptionGroup((String)"http://java.sun.com/xml/ns/javaee", (XmlCursor)cursor, (XmlCursor)moveable);
        }
        finally {
            cursor.dispose();
            moveable.dispose();
        }
        XmlObject result = xmlObject.changeType(ApplicationDocument.type);
        if (result != null) {
            XmlBeansUtil.validateDD((XmlObject)result);
            return (ApplicationDocument)result;
        }
        XmlBeansUtil.validateDD((XmlObject)xmlObject);
        return (ApplicationDocument)xmlObject;
    }

    public Artifact getConfigurationID(Object plan, JarFile module, ModuleIDBuilder idBuilder) throws IOException, DeploymentException {
        ApplicationInfo applicationInfo = (ApplicationInfo)plan;
        Artifact test = applicationInfo.getEnvironment().getConfigId();
        if (!test.isResolved()) {
            throw new IllegalStateException("Module ID should be fully resolved by now (not " + test + ")");
        }
        return test;
    }

    public DeploymentContext buildConfiguration(boolean inPlaceDeployment, Artifact configId, Object plan, JarFile earFile, Collection configurationStores, ArtifactResolver artifactResolver, ConfigurationStore targetConfigurationStore) throws IOException, DeploymentException {
        File configurationDir;
        assert (plan != null);
        ApplicationInfo applicationInfo = (ApplicationInfo)plan;
        EARContext earContext = null;
        ConfigurationModuleType applicationType = applicationInfo.getType();
        applicationInfo.getEnvironment().setConfigId(configId);
        try {
            configurationDir = targetConfigurationStore.createNewConfigurationDir(configId);
        }
        catch (ConfigurationAlreadyExistsException e) {
            throw new DeploymentException((Throwable)e);
        }
        ConfigurationManager configurationManager = this.configurationManager;
        if (configurationManager == null) {
            configurationManager = new SimpleConfigurationManager(configurationStores, artifactResolver, this.repositories);
        }
        try {
            earContext = new EARContext(configurationDir, inPlaceDeployment ? DeploymentUtil.toFile((JarFile)earFile) : null, applicationInfo.getEnvironment(), applicationType, this.naming, configurationManager, this.repositories, this.serverName, applicationInfo.getModuleName(), this.transactionManagerObjectName, this.connectionTrackerObjectName, this.transactionalTimerObjectName, this.nonTransactionalTimerObjectName, this.corbaGBeanObjectName);
            applicationInfo.setEarContext(earContext);
            applicationInfo.setRootEarContext(earContext);
            earContext.getGeneralData().put(ModuleList.class, applicationInfo.getModuleLocations());
            ModuleList moduleLocations = applicationInfo.getModuleLocations();
            ClassPathList libClasspath = new ClassPathList();
            if (ConfigurationModuleType.EAR == applicationType && earFile != null) {
                ApplicationType specDD = (ApplicationType)applicationInfo.getSpecDD();
                String libDir = this.getLibraryDirectory(specDD);
                Enumeration<JarEntry> e = earFile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    String entryName = entry.getName();
                    boolean addEntry = true;
                    for (Object moduleLocation : moduleLocations) {
                        String location = (String)moduleLocation;
                        if (!entryName.startsWith(location)) continue;
                        addEntry = false;
                        break;
                    }
                    if (libDir != null && entry.getName().startsWith(libDir) && entry.getName().endsWith(".jar")) {
                        NestedJarFile library = new NestedJarFile(earFile, entry.getName());
                        earContext.addIncludeAsPackedJar(URI.create(entry.getName()), (JarFile)library);
                        libClasspath.add((Object)entry.getName());
                        continue;
                    }
                    if (!addEntry) continue;
                    earContext.addFile(URI.create(entry.getName()), earFile, entry);
                }
                if (!libClasspath.isEmpty()) {
                    earContext.getGeneralData().put(ClassPathList.class, libClasspath);
                }
            }
            GerApplicationType geronimoApplication = (GerApplicationType)applicationInfo.getVendorDD();
            LinkedHashSet modules = applicationInfo.getModules();
            for (Object module2 : modules) {
                Module module = (Module)module2;
                this.getBuilder(module).installModule(earFile, earContext, module, configurationStores, targetConfigurationStore, this.repositories);
            }
            earContext.flush();
            ClassLoader cl = earContext.getClassLoader();
            for (Object module3 : modules) {
                Module module = (Module)module3;
                this.getBuilder(module).initContext(earContext, module, cl);
            }
            if (geronimoApplication != null) {
                this.securityBuilders.build((XmlObject)geronimoApplication, (DeploymentContext)earContext, (DeploymentContext)earContext);
                this.serviceBuilders.build((XmlObject)geronimoApplication, (DeploymentContext)earContext, (DeploymentContext)earContext);
            }
            if (ConfigurationModuleType.EAR == applicationType) {
                earContext.getGeneralData().put(ClassPathList.class, libClasspath);
                for (ModuleBuilderExtension mbe : this.persistenceUnitBuilders) {
                    mbe.initContext(earContext, applicationInfo, earContext.getClassLoader());
                }
                GBeanData gbeanData = new GBeanData(earContext.getModuleName(), J2EEApplicationImpl.GBEAN_INFO);
                try {
                    String originalSpecDD = applicationInfo.getOriginalSpecDD();
                    if (originalSpecDD == null) {
                        originalSpecDD = "Synthetic EAR";
                    }
                    gbeanData.setAttribute("deploymentDescriptor", (Object)originalSpecDD);
                }
                catch (Exception e) {
                    throw new DeploymentException("Error initializing J2EEApplication managed object", (Throwable)e);
                }
                gbeanData.setReferencePatterns("Server", new ReferencePatterns(new AbstractNameQuery(J2EEServer.class.getName())));
                Map<String, String> thisApp = Collections.singletonMap("J2EEApplication", earContext.getModuleName().getNameProperty("name"));
                LinkedHashSet<AbstractNameQuery> resourcePatterns = new LinkedHashSet<AbstractNameQuery>();
                resourcePatterns.add(new AbstractNameQuery(null, EARConfigBuilder.filter(thisApp, "j2eeType", "JavaMailResource"), J2EEResource.class.getName()));
                resourcePatterns.add(new AbstractNameQuery(null, EARConfigBuilder.filter(thisApp, "j2eeType", "JCAConnectionFactory"), J2EEResource.class.getName()));
                resourcePatterns.add(new AbstractNameQuery(null, EARConfigBuilder.filter(thisApp, "j2eeType", "JDBCResource"), J2EEResource.class.getName()));
                resourcePatterns.add(new AbstractNameQuery(null, EARConfigBuilder.filter(thisApp, "j2eeType", "JDBCDriver"), J2EEResource.class.getName()));
                resourcePatterns.add(new AbstractNameQuery(null, EARConfigBuilder.filter(thisApp, "j2eeType", "JMSResource"), J2EEResource.class.getName()));
                resourcePatterns.add(new AbstractNameQuery(null, EARConfigBuilder.filter(thisApp, "j2eeType", "JNDIResource"), J2EEResource.class.getName()));
                resourcePatterns.add(new AbstractNameQuery(null, EARConfigBuilder.filter(thisApp, "j2eeType", "JTAResource"), J2EEResource.class.getName()));
                resourcePatterns.add(new AbstractNameQuery(null, EARConfigBuilder.filter(thisApp, "j2eeType", "RMI_IIOPResource"), J2EEResource.class.getName()));
                resourcePatterns.add(new AbstractNameQuery(null, EARConfigBuilder.filter(thisApp, "j2eeType", "URLResource"), J2EEResource.class.getName()));
                gbeanData.setReferencePatterns("Resources", resourcePatterns);
                gbeanData.setReferencePatterns("AppClientModules", new ReferencePatterns(new AbstractNameQuery(null, thisApp, org.apache.geronimo.management.AppClientModule.class.getName())));
                gbeanData.setReferencePatterns("EJBModules", new ReferencePatterns(new AbstractNameQuery(null, thisApp, org.apache.geronimo.management.EJBModule.class.getName())));
                gbeanData.setReferencePatterns("ResourceAdapterModules", new ReferencePatterns(new AbstractNameQuery(null, thisApp, ResourceAdapterModule.class.getName())));
                gbeanData.setReferencePatterns("WebModules", new ReferencePatterns(new AbstractNameQuery(null, thisApp, org.apache.geronimo.management.geronimo.WebModule.class.getName())));
                earContext.addGBean(gbeanData);
            }
            for (Object module1 : modules) {
                Module module = (Module)module1;
                this.getBuilder(module).addGBeans(earContext, module, cl, this.repositories);
            }
            EARContext eARContext = earContext;
            return eARContext;
        }
        catch (GBeanAlreadyExistsException e) {
            this.cleanupContext(earContext, configurationDir);
            throw new DeploymentException((Throwable)e);
        }
        catch (IOException e) {
            this.cleanupContext(earContext, configurationDir);
            throw e;
        }
        catch (DeploymentException e) {
            this.cleanupContext(earContext, configurationDir);
            throw e;
        }
        catch (RuntimeException e) {
            this.cleanupContext(earContext, configurationDir);
            throw e;
        }
        catch (Error e) {
            this.cleanupContext(earContext, configurationDir);
            throw e;
        }
        finally {
            for (Object module1 : applicationInfo.getModules()) {
                Module module = (Module)module1;
                module.close();
            }
        }
    }

    private String getLibraryDirectory(ApplicationType specDD) {
        if (specDD == null || !specDD.isSetLibraryDirectory()) {
            return "lib";
        }
        String value = specDD.getLibraryDirectory().getStringValue();
        return value.trim().length() > 0 ? value : null;
    }

    private void cleanupContext(EARContext earContext, File configurationDir) {
        ArrayList configurations = new ArrayList();
        if (earContext != null) {
            configurations.addAll(earContext.getAdditionalDeployment());
            try {
                earContext.close();
            }
            catch (IOException ioe) {
            }
            catch (DeploymentException de) {
                // empty catch block
            }
        }
        if (configurationDir != null) {
            this.cleanupConfigurationDir(configurationDir);
        }
        for (ConfigurationData configurationData : configurations) {
            this.cleanupConfigurationDir(configurationData.getConfigurationDir());
        }
    }

    private boolean cleanupConfigurationDir(File configurationDir) {
        LinkedList cannotBeDeletedList = new LinkedList();
        if (!DeploymentUtil.recursiveDelete((File)configurationDir, cannotBeDeletedList)) {
            log.warn((Object)("Unable to delete " + cannotBeDeletedList.size() + " files while recursively deleting directory " + configurationDir.getAbsolutePath() + LINE_SEP + "The first file that could not be deleted was:" + LINE_SEP + "  " + (!cannotBeDeletedList.isEmpty() ? (String)cannotBeDeletedList.getFirst() : "")));
            return false;
        }
        return true;
    }

    private static Map<String, String> filter(Map<String, String> original, String key, String value) {
        LinkedHashMap<String, String> filter = new LinkedHashMap<String, String>(original);
        filter.put(key, value);
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addModules(JarFile earFile, ApplicationType application, GerApplicationType gerApplication, ModuleList moduleLocations, LinkedHashSet<Module> modules, Environment environment, AbstractName earName, ModuleIDBuilder idBuilder) throws DeploymentException {
        HashMap<String, Object> altVendorDDs = new HashMap<String, Object>();
        try {
            this.mapVendorPlans(gerApplication, altVendorDDs, earFile);
            if (earFile != null) {
                if (application != null) {
                    ModuleType[] moduleTypes;
                    for (ModuleType moduleXml : moduleTypes = application.getModuleArray()) {
                        NestedJarFile moduleFile;
                        String moduleTypeName;
                        ModuleBuilder builder;
                        String modulePath;
                        String moduleContextInfo = null;
                        if (moduleXml.isSetEjb()) {
                            modulePath = moduleXml.getEjb().getStringValue();
                            builder = this.getEjbConfigBuilder();
                            if (builder == null) {
                                throw new DeploymentException("Cannot deploy ejb application; No ejb deployer defined: " + modulePath);
                            }
                            moduleTypeName = "an EJB";
                        } else if (moduleXml.isSetWeb()) {
                            modulePath = moduleXml.getWeb().getWebUri().getStringValue();
                            if (this.getWebConfigBuilder() == null) {
                                throw new DeploymentException("Cannot deploy web application; No war deployer defined: " + modulePath);
                            }
                            builder = this.getWebConfigBuilder();
                            moduleTypeName = "a war";
                            moduleContextInfo = moduleXml.getWeb().getContextRoot().getStringValue().trim();
                        } else if (moduleXml.isSetConnector()) {
                            modulePath = moduleXml.getConnector().getStringValue();
                            if (this.getConnectorConfigBuilder() == null) {
                                throw new DeploymentException("Cannot deploy resource adapter; No rar deployer defined: " + modulePath);
                            }
                            builder = this.getConnectorConfigBuilder();
                            moduleTypeName = "a connector";
                        } else if (moduleXml.isSetJava()) {
                            modulePath = moduleXml.getJava().getStringValue();
                            if (this.getAppClientConfigBuilder() == null) {
                                throw new DeploymentException("Cannot deploy app client; No app client deployer defined: " + modulePath);
                            }
                            builder = this.getAppClientConfigBuilder();
                            moduleTypeName = "an application client";
                        } else {
                            throw new DeploymentException("Could not find a module builder for module: " + moduleXml);
                        }
                        moduleLocations.add((Object)modulePath);
                        try {
                            moduleFile = new NestedJarFile(earFile, modulePath);
                        }
                        catch (IOException e) {
                            throw new DeploymentException("Invalid moduleFile: " + modulePath, (Throwable)e);
                        }
                        Module module = builder.createModule(altVendorDDs.get(modulePath), (JarFile)moduleFile, modulePath, this.getAltSpecDDURL(earFile, moduleXml), environment, moduleContextInfo, earName, this.naming, idBuilder);
                        if (module == null) {
                            throw new DeploymentException("Module was not " + moduleTypeName + ": " + modulePath);
                        }
                        modules.add(module);
                    }
                } else {
                    Enumeration<JarEntry> entries = earFile.entries();
                    while (entries.hasMoreElements()) {
                        NestedJarFile moduleFile;
                        String moduleTypeName;
                        ModuleBuilder builder;
                        ZipEntry entry;
                        String moduleContextInfo;
                        block62: {
                            moduleContextInfo = null;
                            entry = entries.nextElement();
                            if (entry.getName().endsWith(".war")) {
                                if (this.getWebConfigBuilder() == null) {
                                    throw new DeploymentException("Cannot deploy web application; No war deployer defined: " + entry.getName());
                                }
                                builder = this.getWebConfigBuilder();
                                moduleTypeName = "a war";
                                moduleContextInfo = entry.getName().split(".war")[0];
                            } else if (entry.getName().endsWith(".rar")) {
                                if (this.getConnectorConfigBuilder() == null) {
                                    throw new DeploymentException("Cannot deploy resource adapter; No rar deployer defined: " + entry.getName());
                                }
                                builder = this.getConnectorConfigBuilder();
                                moduleTypeName = "a connector";
                            } else {
                                if (!entry.getName().endsWith(".jar") || this.isLibraryEntry(application, entry)) continue;
                                try {
                                    Module module;
                                    moduleFile = new NestedJarFile(earFile, entry.getName());
                                    Manifest mf = moduleFile.getManifest();
                                    if (mf.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS) != null) {
                                        if (this.getAppClientConfigBuilder() == null) {
                                            throw new DeploymentException("Cannot deploy app client; No app client deployer defined: " + entry.getName());
                                        }
                                        builder = this.getAppClientConfigBuilder();
                                        moduleTypeName = "an application client";
                                        break block62;
                                    }
                                    builder = this.getEjbConfigBuilder();
                                    if (builder == null || (module = builder.createModule(altVendorDDs.get(entry.getName()), (JarFile)moduleFile, entry.getName(), null, environment, moduleContextInfo, earName, this.naming, idBuilder)) == null) continue;
                                    moduleLocations.add((Object)entry.getName());
                                    modules.add(module);
                                    continue;
                                }
                                catch (IOException e) {
                                    throw new DeploymentException("Invalid moduleFile: " + entry.getName(), (Throwable)e);
                                }
                            }
                        }
                        moduleLocations.add((Object)entry.getName());
                        try {
                            moduleFile = new NestedJarFile(earFile, entry.getName());
                        }
                        catch (IOException e) {
                            throw new DeploymentException("Invalid moduleFile: " + entry.getName(), (Throwable)e);
                        }
                        Module module = builder.createModule(altVendorDDs.get(entry.getName()), (JarFile)moduleFile, entry.getName(), null, environment, moduleContextInfo, earName, this.naming, idBuilder);
                        if (module == null) {
                            throw new DeploymentException("Module was not " + moduleTypeName + ": " + entry.getName());
                        }
                        modules.add(module);
                    }
                }
            }
            if (!moduleLocations.containsAll(altVendorDDs.keySet())) {
                throw new DeploymentException("Geronimo ear plan contains modules that aren't in the ear: " + new HashSet(moduleLocations).removeAll(altVendorDDs.keySet()));
            }
            for (GerExtModuleType gerExtModule : gerApplication.getExtModuleArray()) {
                Object moduleFile;
                String moduleTypeName;
                ModuleBuilder builder;
                String moduleName;
                Object moduleContextInfo = null;
                if (gerExtModule.isSetEjb()) {
                    moduleName = gerExtModule.getEjb().getStringValue();
                    builder = this.getEjbConfigBuilder();
                    if (builder == null) {
                        throw new DeploymentException("Cannot deploy ejb application; No ejb deployer defined: " + moduleName);
                    }
                    moduleTypeName = "an EJB";
                } else if (gerExtModule.isSetWeb()) {
                    moduleName = gerExtModule.getWeb().getStringValue();
                    if (this.getWebConfigBuilder() == null) {
                        throw new DeploymentException("Cannot deploy web application; No war deployer defined: " + moduleName);
                    }
                    builder = this.getWebConfigBuilder();
                    moduleTypeName = "a war";
                } else if (gerExtModule.isSetConnector()) {
                    moduleName = gerExtModule.getConnector().getStringValue();
                    if (this.getConnectorConfigBuilder() == null) {
                        throw new DeploymentException("Cannot deploy resource adapter; No rar deployer defined: " + moduleName);
                    }
                    builder = this.getConnectorConfigBuilder();
                    moduleTypeName = "a connector";
                } else if (gerExtModule.isSetJava()) {
                    moduleName = gerExtModule.getJava().getStringValue();
                    if (this.getAppClientConfigBuilder() == null) {
                        throw new DeploymentException("Cannot deploy app client; No app client deployer defined: " + moduleName);
                    }
                    builder = this.getAppClientConfigBuilder();
                    moduleTypeName = "an application client";
                } else {
                    throw new DeploymentException("Could not find a module builder for module: " + gerExtModule);
                }
                XmlObject[] anys = gerExtModule.selectChildren(GerExtModuleType.type.qnameSetForWildcardElements());
                if (anys.length != 1) {
                    throw new DeploymentException("Unexpected count of xs:any elements in embedded vendor plan " + anys.length + " qnameset: " + GerExtModuleType.type.qnameSetForWildcardElements());
                }
                XmlObject vendorDD = anys[0];
                if (gerExtModule.isSetInternalPath()) {
                    String modulePath = gerExtModule.getInternalPath().trim();
                    moduleLocations.add((Object)modulePath);
                    try {
                        moduleFile = new NestedJarFile(earFile, modulePath);
                    }
                    catch (IOException e) {
                        throw new DeploymentException("Invalid moduleFile: " + modulePath, (Throwable)e);
                    }
                }
                PatternType patternType = gerExtModule.getExternalPath();
                String groupId = this.trim(patternType.getGroupId());
                String artifactId = this.trim(patternType.getArtifactId());
                String version = this.trim(patternType.getVersion());
                String type = this.trim(patternType.getType());
                Artifact artifact = new Artifact(groupId, artifactId, version, type);
                try {
                    artifact = this.getArtifactResolver().resolveInClassLoader(artifact);
                }
                catch (MissingDependencyException e) {
                    throw new DeploymentException("Could not resolve external rar location in repository: " + artifact, (Throwable)e);
                }
                File location = null;
                for (Repository repository : this.repositories) {
                    if (!repository.contains(artifact)) continue;
                    location = repository.getLocation(artifact);
                    break;
                }
                if (location == null) {
                    throw new DeploymentException(moduleTypeName + " is missing in repositories: " + artifact);
                }
                try {
                    moduleFile = new JarFile(location);
                }
                catch (IOException e) {
                    throw new DeploymentException("Could not access contents of " + moduleTypeName, (Throwable)e);
                }
                Module module = builder.createModule(vendorDD, (JarFile)moduleFile, moduleName, null, environment, moduleContextInfo, earName, this.naming, idBuilder);
                if (module == null) {
                    throw new DeploymentException("Module was not " + moduleTypeName + ": " + moduleName);
                }
                modules.add(module);
            }
        }
        finally {
            for (Object altVendorDD : altVendorDDs.values()) {
                if (!(altVendorDD instanceof File)) continue;
                ((File)altVendorDD).delete();
            }
        }
    }

    private ArtifactResolver getArtifactResolver() throws DeploymentException {
        if (this.artifactResolvers == null || this.artifactResolvers.isEmpty()) {
            throw new DeploymentException("No artifact resolver supplied to resolve external module");
        }
        return this.artifactResolvers.iterator().next();
    }

    private String trim(String s) {
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    private boolean isLibraryEntry(ApplicationType application, ZipEntry entry) {
        String libDir = this.getLibraryDirectory(application);
        return libDir != null && entry.getName().startsWith(libDir);
    }

    private void mapVendorPlans(GerApplicationType gerApplication, Map<String, Object> altVendorDDs, JarFile earFile) throws DeploymentException {
        for (GerModuleType gerModule : gerApplication.getModuleArray()) {
            String path = null;
            if (gerModule.isSetEjb()) {
                path = gerModule.getEjb().getStringValue();
            } else if (gerModule.isSetWeb()) {
                path = gerModule.getWeb().getStringValue();
            } else if (gerModule.isSetConnector()) {
                path = gerModule.getConnector().getStringValue();
            } else if (gerModule.isSetJava()) {
                path = gerModule.getJava().getStringValue();
            }
            if (gerModule.isSetAltDd()) {
                try {
                    altVendorDDs.put(path, DeploymentUtil.toTempFile((JarFile)earFile, (String)gerModule.getAltDd().getStringValue()));
                    continue;
                }
                catch (IOException e) {
                    throw new DeploymentException("Invalid alt vendor dd url: " + gerModule.getAltDd().getStringValue(), (Throwable)e);
                }
            }
            XmlObject[] anys = gerModule.selectChildren(GerModuleType.type.qnameSetForWildcardElements());
            if (anys.length != 1) {
                throw new DeploymentException("Unexpected count of xs:any elements in embedded vendor plan " + anys.length + " qnameset: " + GerModuleType.type.qnameSetForWildcardElements());
            }
            altVendorDDs.put(path, anys[0]);
        }
    }

    private URL getAltSpecDDURL(JarFile earFile, ModuleType moduleXml) throws DeploymentException {
        if (moduleXml != null && moduleXml.isSetAltDd()) {
            try {
                return DeploymentUtil.createJarURL((JarFile)earFile, (String)moduleXml.getAltDd().getStringValue());
            }
            catch (MalformedURLException e) {
                throw new DeploymentException("Invalid alt sped dd url: " + moduleXml.getAltDd().getStringValue(), (Throwable)e);
            }
        }
        return null;
    }

    private ModuleBuilder getBuilder(Module module) throws DeploymentException {
        if (module instanceof EJBModule) {
            if (this.getEjbConfigBuilder() == null) {
                throw new DeploymentException("Cannot deploy ejb application; No ejb deployer defined: " + module.getModuleURI());
            }
            return this.getEjbConfigBuilder();
        }
        if (module instanceof WebModule) {
            if (this.getWebConfigBuilder() == null) {
                throw new DeploymentException("Cannot deploy web application; No war deployer defined: " + module.getModuleURI());
            }
            return this.getWebConfigBuilder();
        }
        if (module instanceof ConnectorModule) {
            if (this.getConnectorConfigBuilder() == null) {
                throw new DeploymentException("Cannot deploy resource adapter; No rar deployer defined: " + module.getModuleURI());
            }
            return this.getConnectorConfigBuilder();
        }
        if (module instanceof AppClientModule) {
            if (this.getAppClientConfigBuilder() == null) {
                throw new DeploymentException("Cannot deploy app client; No app client deployer defined: " + module.getModuleURI());
            }
            return this.getAppClientConfigBuilder();
        }
        throw new IllegalArgumentException("Unknown module type: " + module.getClass().getName());
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(EARConfigBuilder.class, (String)"ConfigBuilder");
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("transactionManagerAbstractName", AbstractNameQuery.class, true);
        infoBuilder.addAttribute("connectionTrackerAbstractName", AbstractNameQuery.class, true);
        infoBuilder.addAttribute("transactionalTimerAbstractName", AbstractNameQuery.class, true);
        infoBuilder.addAttribute("nonTransactionalTimerAbstractName", AbstractNameQuery.class, true);
        infoBuilder.addAttribute("corbaGBeanAbstractName", AbstractNameQuery.class, true);
        infoBuilder.addAttribute("serverName", AbstractNameQuery.class, true);
        infoBuilder.addReference("Repositories", Repository.class, "Repository");
        infoBuilder.addReference("EJBConfigBuilder", ModuleBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("WebConfigBuilder", ModuleBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("ConnectorConfigBuilder", ModuleBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("ActivationSpecInfoLocator", ActivationSpecInfoLocator.class, "ModuleBuilder");
        infoBuilder.addReference("AppClientConfigBuilder", ModuleBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("SecurityBuilders", NamespaceDrivenBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("ServiceBuilders", NamespaceDrivenBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("PersistenceUnitBuilders", ModuleBuilderExtension.class, "ModuleBuilder");
        infoBuilder.addReference("ArtifactResolvers", ArtifactResolver.class, "ArtifactResolver");
        infoBuilder.addAttribute("kernel", Kernel.class, false);
        infoBuilder.setConstructor(new String[]{"defaultEnvironment", "transactionManagerAbstractName", "connectionTrackerAbstractName", "transactionalTimerAbstractName", "nonTransactionalTimerAbstractName", "corbaGBeanAbstractName", "serverName", "Repositories", "EJBConfigBuilder", "WebConfigBuilder", "ConnectorConfigBuilder", "ActivationSpecInfoLocator", "AppClientConfigBuilder", "SecurityBuilders", "ServiceBuilders", "PersistenceUnitBuilders", "ArtifactResolvers", "kernel"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

