/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.hot;

import java.io.File;
import org.apache.geronimo.deployment.hot.DirectoryMonitor;
import org.apache.geronimo.deployment.hot.HotDeployer;
import org.apache.geronimo.deployment.hot.ModuleHandler;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.DeploymentWatcher;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.main.ServerStatus;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryHotDeployer
implements HotDeployer,
DeploymentWatcher,
ServerStatus,
GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(DirectoryHotDeployer.class);
    private DirectoryMonitor monitor;
    private String path;
    private String monitorFileName;
    private ServerInfo serverInfo;
    private int pollIntervalMillis;
    private transient boolean serverRunning = false;
    private ModuleHandler moduleHandler;
    public static final GBeanInfo GBEAN_INFO;

    public DirectoryHotDeployer(String path, String monitorFileName, int pollIntervalMillis, ServerInfo serverInfo, ConfigurationManager configManager, Kernel kernel) {
        this.path = path;
        this.monitorFileName = monitorFileName;
        this.serverInfo = serverInfo;
        this.pollIntervalMillis = pollIntervalMillis;
        this.moduleHandler = new ModuleHandler(kernel, configManager);
    }

    public void deployed(Artifact id) {
    }

    public void undeployed(Artifact id) {
        if (this.monitor != null) {
            String moduleId = id.toString();
            if (moduleId.equals(this.moduleHandler.getWorkingOnConfigId())) {
                return;
            }
            this.monitor.removeFile(id.toString());
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public void setServerInfo(ServerInfo serverInfo) {
        this.serverInfo = serverInfo;
    }

    @Override
    public int getPollIntervalMillis() {
        return this.pollIntervalMillis;
    }

    @Override
    public void setPollIntervalMillis(int pollIntervalMillis) {
        this.pollIntervalMillis = pollIntervalMillis;
    }

    public String getDeploymentURI() {
        return this.moduleHandler.getDeploymentURI();
    }

    public void setDeploymentURI(String deploymentURI) {
        this.moduleHandler.setDeploymentURI(deploymentURI);
    }

    public String getDeploymentUser() {
        return this.moduleHandler.getDeploymentUser();
    }

    public void setDeploymentUser(String deploymentUser) {
        this.moduleHandler.setDeploymentUser(deploymentUser);
    }

    public String getDeploymentPassword() {
        return this.moduleHandler.getDeploymentPassword();
    }

    public void setDeploymentPassword(String deploymentPassword) {
        this.moduleHandler.setDeploymentPassword(deploymentPassword);
    }

    public void doStart() throws Exception {
        File dir = this.serverInfo.resolveServer(this.path);
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new IllegalStateException("Hot deploy directory " + dir.getAbsolutePath() + " does not exist and cannot be created!");
            }
        } else if (!dir.canRead() || !dir.isDirectory()) {
            throw new IllegalStateException("Hot deploy directory " + dir.getAbsolutePath() + " is not a readable directory!");
        }
        File monitorFile = null;
        if (!(this.monitorFileName == null || this.monitorFileName.isEmpty() || (monitorFile = this.serverInfo.resolveServer(dir + File.separator + this.monitorFileName)).createNewFile() || monitorFile.canWrite())) {
            throw new IllegalStateException("Hot deploy persist state file " + monitorFile.getAbsolutePath() + " could not be created or is not writable");
        }
        this.monitor = new DirectoryMonitor(dir, monitorFile, this.moduleHandler, this.pollIntervalMillis);
        log.debug("Hot deploy scanner intialized");
    }

    public void doStop() throws Exception {
        this.monitor.close();
    }

    public void doFail() {
        if (this.monitor != null) {
            this.monitor.close();
        }
    }

    public boolean isServerStarted() {
        return this.serverRunning;
    }

    public void setServerStarted(boolean started) {
        this.serverRunning = started;
        if (started) {
            Thread t = new Thread((Runnable)this.monitor, "Geronimo hot deploy scanner");
            t.setDaemon(true);
            t.start();
            log.debug("Hot deploy scanner started");
        }
    }

    public void started() {
        log.debug("Initialization complete; directory scanner entering normal scan mode");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(DirectoryHotDeployer.class);
        infoFactory.addAttribute("path", String.class, true, true);
        infoFactory.addAttribute("monitorFileName", String.class, true, true);
        infoFactory.addAttribute("pollIntervalMillis", Integer.TYPE, true, true);
        infoFactory.addAttribute("deploymentURI", String.class, true, true);
        infoFactory.addAttribute("deploymentUser", String.class, true, true);
        infoFactory.addAttribute("deploymentPassword", String.class, true, true);
        infoFactory.addReference("ConfigManager", ConfigurationManager.class, "ConfigurationManager");
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addAttribute("kernel", Kernel.class, false, false);
        infoFactory.addInterface(HotDeployer.class);
        infoFactory.setConstructor(new String[]{"path", "monitorFileName", "pollIntervalMillis", "ServerInfo", "ConfigManager", "kernel"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

