/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.hot;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.geronimo.kernel.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryMonitor
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(DirectoryMonitor.class);
    private int pollIntervalMillis;
    private File directory;
    private boolean done = false;
    private MonitorListener listener;
    private Map<String, FileInfo> fileRecords;
    private final ArrayList<String> toRemove = new ArrayList();
    private File monitorFile;

    public DirectoryMonitor(File directory, MonitorListener listener, int pollIntervalMillis) {
        this(directory, null, listener, pollIntervalMillis);
    }

    public DirectoryMonitor(File directory, File monitorFile, MonitorListener listener, int pollIntervalMillis) {
        this.directory = directory;
        this.listener = listener;
        this.pollIntervalMillis = pollIntervalMillis;
        this.monitorFile = monitorFile;
    }

    public int getPollIntervalMillis() {
        return this.pollIntervalMillis;
    }

    public void setPollIntervalMillis(int pollIntervalMillis) {
        this.pollIntervalMillis = pollIntervalMillis;
    }

    public MonitorListener getMonitorListener() {
        return this.listener;
    }

    public void setMonitorListener(MonitorListener listener) {
        this.listener = listener;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        if (!directory.isDirectory() || !directory.canRead()) {
            throw new IllegalArgumentException("Cannot monitor directory " + directory.getAbsolutePath());
        }
        this.directory = directory;
    }

    public synchronized boolean isDone() {
        return this.done;
    }

    public synchronized void close() {
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFile(String configId) {
        log.info("Hot deployer notified that an artifact was undeployed: " + configId);
        ArrayList<String> arrayList = this.toRemove;
        synchronized (arrayList) {
            this.toRemove.add(configId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemoves() {
        ArrayList<String> arrayList = this.toRemove;
        synchronized (arrayList) {
            Map<String, FileInfo> map = this.fileRecords;
            synchronized (map) {
                boolean changeMade = false;
                Iterator<String> idItr = this.toRemove.iterator();
                while (idItr.hasNext()) {
                    String configId = idItr.next();
                    Iterator<String> filesItr = this.fileRecords.keySet().iterator();
                    while (filesItr.hasNext()) {
                        String path = filesItr.next();
                        FileInfo info = this.fileRecords.get(path);
                        if (info.getConfigId() == null || !configId.equals(info.getConfigId())) continue;
                        File file = new File(path);
                        if (file.exists()) {
                            log.info("Hot deployer deleting " + path);
                            if (!FileUtils.recursiveDelete((File)file)) {
                                log.error("Hot deployer unable to delete " + path);
                            }
                        }
                        filesItr.remove();
                        changeMade = true;
                    }
                    idItr.remove();
                }
                if (changeMade) {
                    this.persistState();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistState() {
        if (this.monitorFile == null) {
            return;
        }
        log.info("Persisting directory monitor state to " + this.monitorFile.getName());
        ObjectOutputStream outputStream = null;
        try {
            outputStream = new ObjectOutputStream(new FileOutputStream(this.monitorFile));
            outputStream.writeObject(this.fileRecords);
        }
        catch (IOException ioe) {
            log.warn("Error persisting directory monitor state to " + this.monitorFile.getName(), (Throwable)ioe);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, FileInfo> readState() {
        Map newFiles = null;
        if (this.monitorFile != null) {
            ObjectInputStream inputStream = null;
            try {
                inputStream = new ObjectInputStream(new FileInputStream(this.monitorFile));
                newFiles = (Map)inputStream.readObject();
            }
            catch (IOException ex) {
                log.info("No directory monitor state to be read. This is to be expected on initial start of a new server");
            }
            catch (ClassNotFoundException cnfe) {
                log.warn("ClassNotFoundException reading directory monitor state from " + this.monitorFile.getName(), (Throwable)cnfe);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException ioe) {}
            }
        }
        if (newFiles == null) {
            newFiles = new HashMap();
        }
        return newFiles;
    }

    @Override
    public void run() {
        boolean initialized = false;
        while (!this.done) {
            try {
                Thread.sleep(this.pollIntervalMillis);
            }
            catch (InterruptedException e) {
                continue;
            }
            try {
                if (this.listener == null) continue;
                if (!initialized) {
                    initialized = true;
                    this.initialize();
                    continue;
                }
                this.doRemoves();
                this.scanDirectory();
            }
            catch (Exception e) {
                log.error("Error during hot deployment", (Throwable)e);
            }
        }
    }

    private void initialize() {
        this.fileRecords = this.readState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanDirectory() {
        File parent = this.directory;
        File[] children = parent.listFiles();
        if (!this.directory.exists() || children == null) {
            log.error("Hot deploy directory has disappeared!  Shutting down directory monitor.");
            this.done = true;
            return;
        }
        Map<String, FileInfo> map = this.fileRecords;
        synchronized (map) {
            HashSet<String> oldList = new HashSet<String>(this.fileRecords.keySet());
            ArrayList<FileInfo> addedFiles = new ArrayList<FileInfo>();
            ArrayList<FileInfo> modifiedFiles = new ArrayList<FileInfo>();
            ArrayList<FileInfo> deletedFiles = new ArrayList<FileInfo>();
            boolean changeMade = false;
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                if (!child.canRead() || child.equals(this.monitorFile)) continue;
                FileInfo now = this.getFileInfo(child);
                FileInfo last = this.fileRecords.get(now.getPath());
                if (last == null) {
                    now.setNewFile(true);
                    this.fileRecords.put(now.getPath(), now);
                    changeMade = true;
                    log.debug("New File: " + now.getPath());
                    continue;
                }
                oldList.remove(last.getPath());
                if (now.isSame(last)) {
                    if (!last.isChanging()) continue;
                    log.debug("File finished changing: " + now.getPath());
                    if (last.isNewFile()) {
                        addedFiles.add(last);
                        last.setNewFile(false);
                    } else {
                        modifiedFiles.add(last);
                    }
                    last.setChanging(false);
                    changeMade = true;
                    continue;
                }
                if (last.isNewFile()) {
                    now.setNewFile(last.isNewFile());
                } else {
                    now.setConfigId(last.getConfigId());
                }
                this.fileRecords.put(now.getPath(), now);
                changeMade = true;
                log.debug("File Changed: " + now.getPath());
            }
            for (String name : oldList) {
                FileInfo info = this.fileRecords.remove(name);
                changeMade = true;
                log.debug("File removed: " + name);
                deletedFiles.add(info);
            }
            this.validate(addedFiles, false);
            this.validate(modifiedFiles, false);
            if (!(addedFiles.isEmpty() && modifiedFiles.isEmpty() && deletedFiles.isEmpty())) {
                log.debug("Added files: {}", addedFiles);
                log.debug("Modified files: {}", modifiedFiles);
                log.debug("Deleted files: {}", deletedFiles);
                try {
                    this.listener.scanComplete(addedFiles, modifiedFiles, deletedFiles);
                }
                catch (Throwable e) {
                    log.warn("Error calling scanComplete()", e);
                }
            }
            if (changeMade) {
                this.persistState();
            }
        }
    }

    private void validate(Collection<FileInfo> updatedFiles, boolean delete) {
        Iterator<FileInfo> it = updatedFiles.iterator();
        while (it.hasNext()) {
            FileInfo info = it.next();
            if (this.listener.validateFile(new File(info.getPath()), info.getConfigId())) continue;
            it.remove();
            if (!delete) continue;
            this.fileRecords.remove(info.getPath());
        }
    }

    private FileInfo getFileInfo(File file) {
        FileInfo info = new FileInfo(file.getAbsolutePath());
        info.setSize(file.isDirectory() ? 0L : file.length());
        info.setModified(DirectoryMonitor.getLastModified(file));
        return info;
    }

    public static long getLastModified(File file) {
        long value = file.lastModified();
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            for (int i = 0; i < children.length; ++i) {
                long test;
                File child = children[i];
                if (!child.canRead() || (test = DirectoryMonitor.getLastModified(child)) <= value) continue;
                value = test;
            }
        }
        return value;
    }

    public static class FileInfo
    implements Serializable {
        private String path;
        private long size;
        private long modified;
        private boolean newFile;
        private boolean changing;
        private String configId;

        public FileInfo(String path) {
            this.path = path;
            this.newFile = false;
            this.changing = true;
        }

        public String getPath() {
            return this.path;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public long getModified() {
            return this.modified;
        }

        public void setModified(long modified) {
            this.modified = modified;
        }

        public boolean isNewFile() {
            return this.newFile;
        }

        public void setNewFile(boolean newFile) {
            this.newFile = newFile;
        }

        public boolean isChanging() {
            return this.changing;
        }

        public void setChanging(boolean changing) {
            this.changing = changing;
        }

        public String getConfigId() {
            return this.configId;
        }

        public void setConfigId(String configId) {
            this.configId = configId;
        }

        public boolean isSame(FileInfo info) {
            if (!this.path.equals(info.path)) {
                throw new IllegalArgumentException("Should only be used to compare two files representing the same path!");
            }
            return this.size == info.size && this.modified == info.modified;
        }
    }

    public static interface MonitorListener {
        public boolean validateFile(File var1, String var2);

        public void scanComplete(Collection<FileInfo> var1, Collection<FileInfo> var2, Collection<FileInfo> var3);
    }
}

