/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.hot;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.kernel.config.IOUtil;
import org.apache.geronimo.kernel.repository.Artifact;

public class DirectoryMonitor
implements Runnable {
    private static final Log log = LogFactory.getLog(DirectoryMonitor.class);
    private int pollIntervalMillis;
    private File directory;
    private boolean done = false;
    private Listener listener;
    private final Map files = new HashMap();
    private volatile String workingOnConfigId;

    public DirectoryMonitor(File directory, Listener listener, int pollIntervalMillis) {
        this.directory = directory;
        this.listener = listener;
        this.pollIntervalMillis = pollIntervalMillis;
    }

    public int getPollIntervalMillis() {
        return this.pollIntervalMillis;
    }

    public void setPollIntervalMillis(int pollIntervalMillis) {
        this.pollIntervalMillis = pollIntervalMillis;
    }

    public Listener getListener() {
        return this.listener;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        if (!directory.isDirectory() || !directory.canRead()) {
            throw new IllegalArgumentException("Cannot monitor directory " + directory.getAbsolutePath());
        }
        this.directory = directory;
    }

    public synchronized boolean isDone() {
        return this.done;
    }

    public synchronized void close() {
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModuleId(Artifact id) {
        log.info((Object)("Hot deployer notified that an artifact was removed: " + id));
        if (id.toString().equals(this.workingOnConfigId)) {
            return;
        }
        Map map = this.files;
        synchronized (map) {
            Iterator it = this.files.keySet().iterator();
            while (it.hasNext()) {
                File file;
                String path = (String)it.next();
                FileInfo info = (FileInfo)this.files.get(path);
                Artifact target = Artifact.create((String)info.getConfigId());
                if (!id.matches(target) || !(file = new File(path)).exists()) continue;
                log.info((Object)("Hot deployer deleting " + id));
                if (!IOUtil.recursiveDelete((File)file)) {
                    log.error((Object)("Hot deployer unable to delete " + path));
                }
                it.remove();
            }
        }
    }

    public void run() {
        boolean serverStarted = false;
        boolean initialized = false;
        while (!this.done) {
            try {
                Thread.sleep(this.pollIntervalMillis);
            }
            catch (InterruptedException e) {
                continue;
            }
            try {
                if (this.listener == null) continue;
                if (!serverStarted && this.listener.isServerRunning()) {
                    serverStarted = true;
                }
                if (!serverStarted) continue;
                if (!initialized) {
                    initialized = true;
                    this.initialize();
                    this.listener.started();
                    continue;
                }
                this.scanDirectory();
            }
            catch (Exception e) {
                log.error((Object)"Error during hot deployment", (Throwable)e);
            }
        }
    }

    public void initialize() {
        File parent = this.directory;
        File[] children = parent.listFiles();
        for (int i = 0; i < children.length; ++i) {
            File child = children[i];
            if (!child.canRead()) continue;
            FileInfo now = child.isDirectory() ? this.getDirectoryInfo(child) : this.getFileInfo(child);
            now.setChanging(false);
            try {
                now.setConfigId(this.calculateModuleId(child));
                if (this.listener != null && !this.listener.isFileDeployed(child, now.getConfigId())) continue;
                if (this.listener != null) {
                    now.setModified(this.listener.getDeploymentTime(child, now.getConfigId()));
                }
                log.info((Object)("At startup, found " + now.getPath() + " with deploy time " + now.getModified() + " and file time " + new File(now.getPath()).lastModified()));
                this.files.put(now.getPath(), now);
                continue;
            }
            catch (Exception e) {
                log.error((Object)("Unable to scan file " + child.getAbsolutePath() + " during initialization"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanDirectory() {
        File parent = this.directory;
        File[] children = parent.listFiles();
        if (!this.directory.exists() || children == null) {
            log.error((Object)"Hot deploy directory has disappeared!  Shutting down directory monitor.");
            this.done = true;
            return;
        }
        Map map = this.files;
        synchronized (map) {
            HashSet oldList = new HashSet(this.files.keySet());
            LinkedList<FileAction> actions = new LinkedList<FileAction>();
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                if (!child.canRead()) continue;
                FileInfo now = child.isDirectory() ? this.getDirectoryInfo(child) : this.getFileInfo(child);
                FileInfo then = (FileInfo)this.files.get(now.getPath());
                if (then == null) {
                    now.setNewFile(true);
                    this.files.put(now.getPath(), now);
                    log.debug((Object)("New File: " + now.getPath()));
                    continue;
                }
                oldList.remove(then.getPath());
                if (now.isSame(then)) {
                    if (!then.isChanging()) continue;
                    log.debug((Object)("File finished changing: " + now.getPath()));
                    if (then.isNewFile()) {
                        actions.add(new FileAction(FileAction.NEW_FILE, child, then));
                    } else {
                        actions.add(new FileAction(FileAction.UPDATED_FILE, child, then));
                    }
                    then.setChanging(false);
                    continue;
                }
                if (!then.isNewFile() && now.getModified() <= then.getModified()) continue;
                now.setConfigId(then.getConfigId());
                now.setNewFile(then.isNewFile());
                this.files.put(now.getPath(), now);
                log.debug((Object)("File Changed: " + now.getPath()));
            }
            for (String name : oldList) {
                FileInfo info = (FileInfo)this.files.get(name);
                log.debug((Object)("File removed: " + name));
                if (info.isNewFile()) {
                    this.files.remove(name);
                    continue;
                }
                actions.add(new FileAction(FileAction.REMOVED_FILE, new File(name), info));
            }
            if (this.listener != null) {
                Iterator it = actions.iterator();
                while (it.hasNext()) {
                    FileAction action = (FileAction)it.next();
                    if (this.listener.validateFile(action.child, action.info.getConfigId())) continue;
                    this.resolveFile(action);
                    it.remove();
                }
                for (FileAction action : actions) {
                    try {
                        String result;
                        if (action.action == FileAction.REMOVED_FILE) {
                            this.workingOnConfigId = action.info.getConfigId();
                            if (action.info.getConfigId() == null || this.listener.fileRemoved(action.child, action.info.getConfigId())) {
                                this.files.remove(action.child.getPath());
                            }
                            this.workingOnConfigId = null;
                            continue;
                        }
                        if (action.action == FileAction.NEW_FILE) {
                            if (this.listener.isFileDeployed(action.child, this.calculateModuleId(action.child))) {
                                this.workingOnConfigId = this.calculateModuleId(action.child);
                                result = this.listener.fileUpdated(action.child, this.workingOnConfigId);
                                if (result != null) {
                                    if (!result.equals("")) {
                                        action.info.setConfigId(result);
                                    } else {
                                        action.info.setConfigId(this.calculateModuleId(action.child));
                                    }
                                }
                                File[] childs = this.directory.listFiles();
                                for (int i = 0; i < childs.length; ++i) {
                                    String path = childs[i].getAbsolutePath();
                                    String configId = ((FileInfo)this.files.get(path)).configId;
                                    if (configId == null || !configId.equals(this.workingOnConfigId) || action.child.getAbsolutePath().equals(path)) continue;
                                    File fd = new File(path);
                                    if (fd.isDirectory()) {
                                        log.info((Object)("Deleting the Directory: " + path));
                                        if (DeploymentUtil.recursiveDelete((File)fd)) {
                                            log.debug((Object)("Successfully deleted the Directory: " + path));
                                        } else {
                                            log.error((Object)("Couldn't delete the hot deployed directory=" + path));
                                        }
                                    } else if (fd.isFile()) {
                                        log.info((Object)("Deleting the File: " + path));
                                        if (fd.delete()) {
                                            log.debug((Object)("Successfully deleted the File: " + path));
                                        } else {
                                            log.error((Object)("Couldn't delete the hot deployed file=" + path));
                                        }
                                    }
                                    this.files.remove(path);
                                }
                                this.workingOnConfigId = null;
                            } else {
                                result = this.listener.fileAdded(action.child);
                                if (result != null) {
                                    if (!result.equals("")) {
                                        action.info.setConfigId(result);
                                    } else {
                                        action.info.setConfigId(this.calculateModuleId(action.child));
                                    }
                                }
                            }
                            action.info.setNewFile(false);
                            continue;
                        }
                        if (action.action != FileAction.UPDATED_FILE) continue;
                        this.workingOnConfigId = action.info.getConfigId();
                        result = this.listener.fileUpdated(action.child, action.info.getConfigId());
                        FileInfo update = action.info;
                        if (result != null) {
                            if (!result.equals("")) {
                                update.setConfigId(result);
                            } else {
                                update.setConfigId(this.calculateModuleId(action.child));
                            }
                        }
                        this.workingOnConfigId = null;
                    }
                    catch (Exception e) {
                        log.error((Object)("Unable to " + action.getActionName() + " file " + action.child.getAbsolutePath()), (Throwable)e);
                    }
                    finally {
                        this.resolveFile(action);
                    }
                }
            }
        }
    }

    private void resolveFile(FileAction action) {
        if (action.action == FileAction.REMOVED_FILE) {
            this.files.remove(action.child.getPath());
        } else {
            action.info.setChanging(false);
        }
    }

    private String calculateModuleId(File module) {
        String moduleId = null;
        try {
            moduleId = DeployUtils.extractModuleIdFromArchive((File)module);
        }
        catch (Exception e) {
            try {
                moduleId = DeployUtils.extractModuleIdFromPlan((File)module);
            }
            catch (IOException e2) {
                log.warn((Object)("Unable to calculate module ID for file " + module.getAbsolutePath() + " [" + e2.getMessage() + "]"));
            }
        }
        if (moduleId == null) {
            int pos = module.getName().lastIndexOf(46);
            moduleId = pos > -1 ? module.getName().substring(0, pos) : module.getName();
            moduleId = this.listener.getModuleId(moduleId);
        }
        return moduleId;
    }

    private FileInfo getDirectoryInfo(File dir) {
        FileInfo info = new FileInfo(dir.getAbsolutePath());
        info.setSize(0L);
        info.setModified(this.getLastModifiedInDir(dir));
        return info;
    }

    private long getLastModifiedInDir(File dir) {
        long value = dir.lastModified();
        File[] children = dir.listFiles();
        for (int i = 0; i < children.length; ++i) {
            long test;
            File child = children[i];
            if (!child.canRead() || (test = child.isDirectory() ? this.getLastModifiedInDir(child) : child.lastModified()) <= value) continue;
            value = test;
        }
        return value;
    }

    private FileInfo getFileInfo(File child) {
        FileInfo info = new FileInfo(child.getAbsolutePath());
        info.setSize(child.length());
        info.setModified(child.lastModified());
        return info;
    }

    private static class FileInfo
    implements Serializable {
        private String path;
        private long size;
        private long modified;
        private boolean newFile;
        private boolean changing;
        private String configId;

        public FileInfo(String path) {
            this.path = path;
            this.newFile = false;
            this.changing = true;
        }

        public String getPath() {
            return this.path;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public long getModified() {
            return this.modified;
        }

        public void setModified(long modified) {
            this.modified = modified;
        }

        public boolean isNewFile() {
            return this.newFile;
        }

        public void setNewFile(boolean newFile) {
            this.newFile = newFile;
        }

        public boolean isChanging() {
            return this.changing;
        }

        public void setChanging(boolean changing) {
            this.changing = changing;
        }

        public String getConfigId() {
            return this.configId;
        }

        public void setConfigId(String configId) {
            this.configId = configId;
        }

        public boolean isSame(FileInfo info) {
            if (!this.path.equals(info.path)) {
                throw new IllegalArgumentException("Should only be used to compare two files representing the same path!");
            }
            return this.size == info.size && this.modified == info.modified;
        }
    }

    private static class FileAction {
        private static int NEW_FILE = 1;
        private static int UPDATED_FILE = 2;
        private static int REMOVED_FILE = 3;
        private int action;
        private File child;
        private FileInfo info;

        public FileAction(int action, File child, FileInfo info) {
            this.action = action;
            this.child = child;
            this.info = info;
        }

        public String getActionName() {
            return this.action == NEW_FILE ? "deploy" : (this.action == UPDATED_FILE ? "redeploy" : "undeploy");
        }
    }

    public static interface Listener {
        public boolean isServerRunning();

        public boolean isFileDeployed(File var1, String var2);

        public long getDeploymentTime(File var1, String var2);

        public void started();

        public boolean validateFile(File var1, String var2);

        public String fileAdded(File var1);

        public boolean fileRemoved(File var1, String var2);

        public String fileUpdated(File var1, String var2);

        public String getModuleId(String var1);
    }
}

