/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.farm.discovery;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.URI;
import java.util.concurrent.TimeUnit;

public class MulticastSearch {
    private static final int BUFF_SIZE = 8192;
    private final MulticastSocket multicast;

    public MulticastSearch() throws IOException {
        this("239.255.3.2", 6142);
    }

    public MulticastSearch(String host, int port) throws IOException {
        InetAddress inetAddress = InetAddress.getByName(host);
        this.multicast = new MulticastSocket(port);
        this.multicast.joinGroup(inetAddress);
        this.multicast.setSoTimeout(500);
    }

    public URI search(int timeout, TimeUnit milliseconds) throws IOException {
        return this.search(new DefaultFilter(), timeout, milliseconds);
    }

    public URI search() throws IOException {
        return this.search(new DefaultFilter(), 0L, TimeUnit.MILLISECONDS);
    }

    public URI search(Filter filter) throws IOException {
        return this.search(filter, 0L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI search(Filter filter, long timeout, TimeUnit unit) throws IOException {
        timeout = unit.convert(timeout, TimeUnit.MILLISECONDS);
        long waited = 0L;
        byte[] buf = new byte[8192];
        DatagramPacket packet = new DatagramPacket(buf, 0, buf.length);
        while (timeout == 0L || waited < timeout) {
            long start = System.currentTimeMillis();
            try {
                String str;
                URI service;
                this.multicast.receive(packet);
                if (packet.getLength() <= 0 || (service = URI.create(str = new String(packet.getData(), packet.getOffset(), packet.getLength()))) == null || !filter.accept(service)) continue;
                URI uRI = service;
                return uRI;
            }
            catch (SocketException e) {}
            continue;
            finally {
                long stop = System.currentTimeMillis();
                waited += stop - start;
            }
        }
        return null;
    }

    public static class DefaultFilter
    implements Filter {
        public boolean accept(URI service) {
            return true;
        }
    }

    public static interface Filter {
        public boolean accept(URI var1);
    }
}

