/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.farm.deployment;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.farm.config.ClusterInfo;
import org.apache.geronimo.farm.config.NodeInfo;
import org.apache.geronimo.farm.deployment.ClusterConfigurationController;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.repository.Artifact;

public class BasicClusterConfigurationController
implements GBeanLifecycle,
ClusterConfigurationController {
    private static final Log log = LogFactory.getLog(BasicClusterConfigurationController.class);
    private final ClusterInfo clusterInfo;
    private final String nodeName;
    private final Artifact artifact;
    private boolean startConfigurationUponStart;
    private boolean ignoreStartConfigurationFailureUponStart;
    public static final GBeanInfo GBEAN_INFO;
    public static final String GBEAN_J2EE_TYPE = "ClusterConfigurationController";
    public static final String GBEAN_ATTR_NODE_NAME = "nodeName";
    public static final String GBEAN_ATTR_ARTIFACT = "artifact";
    public static final String GBEAN_ATTR_START_CONF_UPON_START = "startConfigurationUponStart";
    public static final String GBEAN_ATTR_IGNORE_START_CONF_FAIL_UPON_START = "ignoreStartConfigurationFailureUponStart";
    public static final String GBEAN_REF_CLUSTER_INFO = "ClusterInfo";

    public BasicClusterConfigurationController(ClusterInfo clusterInfo, String nodeName, Artifact artifact, boolean startConfigurationUponStart, boolean ignoreStartConfigurationFailureUponStart) {
        if (null == clusterInfo) {
            throw new IllegalArgumentException("clusterInfo is required");
        }
        if (null == nodeName) {
            throw new IllegalArgumentException("nodeName is required");
        }
        if (null == artifact) {
            throw new IllegalArgumentException("artifact is required");
        }
        this.clusterInfo = clusterInfo;
        this.nodeName = nodeName;
        this.artifact = artifact;
        this.startConfigurationUponStart = startConfigurationUponStart;
        this.ignoreStartConfigurationFailureUponStart = ignoreStartConfigurationFailureUponStart;
    }

    public void doStart() throws Exception {
        if (this.startConfigurationUponStart) {
            try {
                this.startConfiguration();
            }
            catch (Exception e) {
                if (this.ignoreStartConfigurationFailureUponStart) {
                    log.info((Object)("Exception while starting configuration [" + this.artifact + "] on [" + this.nodeName + "]. Ignoring."), (Throwable)e);
                }
                log.error((Object)("Exception while starting configuration [" + this.artifact + "] on [" + this.nodeName + "]."), (Throwable)e);
                throw e;
            }
        }
    }

    public void doFail() {
        try {
            this.stopConfiguration();
        }
        catch (Exception e) {
            log.error((Object)("Exception while stopping configuration [" + this.artifact + "] on [" + this.nodeName + "]."), (Throwable)e);
        }
    }

    public void doStop() throws Exception {
        try {
            this.stopConfiguration();
        }
        catch (Exception e) {
            log.error((Object)("Exception while stopping configuration [" + this.artifact + "] on [" + this.nodeName + "]."), (Throwable)e);
            throw e;
        }
    }

    public void startConfiguration() throws Exception {
        for (NodeInfo nodeInfo : this.clusterInfo.getNodeInfos()) {
            if (!nodeInfo.getName().equals(this.nodeName)) continue;
            Kernel kernel = nodeInfo.newKernel();
            ConfigurationManager configurationManager = this.newConfigurationManager(kernel);
            if (!configurationManager.isLoaded(this.artifact)) {
                configurationManager.loadConfiguration(this.artifact);
            }
            configurationManager.startConfiguration(this.artifact);
        }
    }

    public void stopConfiguration() throws Exception {
        for (NodeInfo nodeInfo : this.clusterInfo.getNodeInfos()) {
            if (!nodeInfo.getName().equals(this.nodeName)) continue;
            Kernel kernel = nodeInfo.newKernel();
            ConfigurationManager configurationManager = this.newConfigurationManager(kernel);
            configurationManager.stopConfiguration(this.artifact);
        }
    }

    protected ConfigurationManager newConfigurationManager(Kernel kernel) {
        return ConfigurationUtil.getConfigurationManager((Kernel)kernel);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder builder = GBeanInfoBuilder.createStatic(BasicClusterConfigurationController.class, (String)GBEAN_J2EE_TYPE);
        builder.addAttribute(GBEAN_ATTR_NODE_NAME, String.class, true);
        builder.addAttribute(GBEAN_ATTR_ARTIFACT, Artifact.class, true);
        builder.addAttribute(GBEAN_ATTR_START_CONF_UPON_START, Boolean.TYPE, true);
        builder.addAttribute(GBEAN_ATTR_IGNORE_START_CONF_FAIL_UPON_START, Boolean.TYPE, true);
        builder.addReference(GBEAN_REF_CLUSTER_INFO, ClusterInfo.class);
        builder.addInterface(ClusterConfigurationController.class);
        builder.setConstructor(new String[]{GBEAN_REF_CLUSTER_INFO, GBEAN_ATTR_NODE_NAME, GBEAN_ATTR_ARTIFACT, GBEAN_ATTR_START_CONF_UPON_START, GBEAN_ATTR_IGNORE_START_CONF_FAIL_UPON_START});
        GBEAN_INFO = builder.getBeanInfo();
    }
}

