/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.derby;

import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.geronimo.derby.DerbySystem;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class DerbySystemGBean
implements DerbySystem,
GBeanLifecycle {
    private static final Log log = LogFactory.getLog((String)"DerbySystem");
    private static final String SYSTEM_HOME = "derby.system.home";
    private static final String SHUTDOWN_ALL = "jdbc:derby:;shutdown=true";
    private static final String DERBYNETWORK_GBEAN_NAME = "DerbyNetwork";
    private static final String DERBYNETWORK_GBEAN_ATTRIBUTE_USERNAME = "userName";
    private static final String DERBYNETWORK_GBEAN_ATTRIBUTE_USERPASSWORD = "userPassword";
    private final ServerInfo serverInfo;
    private final String systemHome;
    private String actualHome;
    private Kernel kernel;
    private boolean disableAuthentication = false;
    public static final GBeanInfo GBEAN_INFO;

    public DerbySystemGBean(ServerInfo serverInfo, String derbySystemHome, Kernel kernel) {
        this.serverInfo = serverInfo;
        this.systemHome = derbySystemHome;
        this.kernel = kernel;
    }

    public String getDerbyHome() {
        return this.actualHome;
    }

    private String getDerbyUserID() {
        try {
            return (String)this.kernel.getAttribute(DERBYNETWORK_GBEAN_NAME, DERBYNETWORK_GBEAN_ATTRIBUTE_USERNAME);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getDerbyUserPassword() {
        try {
            return (String)this.kernel.getAttribute(DERBYNETWORK_GBEAN_NAME, DERBYNETWORK_GBEAN_ATTRIBUTE_USERPASSWORD);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void doStart() throws Exception {
        this.actualHome = System.getProperty(SYSTEM_HOME);
        if (this.actualHome == null) {
            this.actualHome = this.serverInfo.resolveServerPath(this.systemHome);
        }
        System.setProperty(SYSTEM_HOME, this.actualHome);
        System.setProperty("derby.storage.fileSyncTransactionLog", "true");
        if (System.getProperty("derby.connection.requireAuthentication") != null && "false".equals(System.getProperty("derby.connection.requireAuthentication"))) {
            this.disableAuthentication = true;
        } else {
            System.setProperty("derby.connection.requireAuthentication", "true");
            System.setProperty("derby.authentication.provider", "org.apache.geronimo.derby.DerbyUserAuthenticator");
        }
        new EmbeddedDriver();
        log.debug((Object)("Started in " + this.actualHome));
    }

    public void doStop() throws Exception {
        try {
            if (this.disableAuthentication) {
                DriverManager.getConnection(SHUTDOWN_ALL, null, null);
            } else {
                DriverManager.getConnection(SHUTDOWN_ALL, this.getDerbyUserID(), this.getDerbyUserPassword());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        System.gc();
        log.debug((Object)"Stopped");
    }

    public void doFail() {
        try {
            if (this.disableAuthentication) {
                DriverManager.getConnection(SHUTDOWN_ALL, null, null);
            } else {
                DriverManager.getConnection(SHUTDOWN_ALL, this.getDerbyUserID(), this.getDerbyUserPassword());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        System.gc();
        log.warn((Object)"Failed");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(DerbySystemGBean.class);
        infoFactory.addAttribute("derbySystemHome", String.class, true);
        infoFactory.addAttribute("derbyHome", String.class, false);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.setConstructor(new String[]{"ServerInfo", "derbySystemHome", "kernel"});
        infoFactory.setPriority(1);
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

